/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import org.apache.mina.common.ByteBuffer;

public abstract class Http2Frame {
    private final int length;
    private final short type;
    private byte flags;
    private final int streamID;

    public int getLength() {
        return this.length;
    }

    public short getType() {
        return this.type;
    }

    public byte getFlags() {
        return this.flags;
    }

    protected boolean isFlagSet(byte by) {
        return (this.getFlags() & by) == by;
    }

    public int getStreamID() {
        return this.streamID;
    }

    public boolean isEndStream() {
        return this.isFlagSet((byte)1);
    }

    public boolean isEndHeaders() {
        return this.isFlagSet((byte)4);
    }

    protected void endHeaders() {
        this.flags = (byte)(this.flags | 4);
    }

    public ByteBuffer toBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(9 + this.getLength(), true);
        byteBuffer.put((byte)(this.getLength() >> 16));
        byteBuffer.put((byte)(this.getLength() >> 8));
        byteBuffer.put((byte)this.getLength());
        byteBuffer.put((byte)this.getType());
        byteBuffer.put(this.getFlags());
        byteBuffer.putInt(this.getStreamID());
        this.writePayload(byteBuffer);
        byteBuffer.flip();
        return byteBuffer;
    }

    public abstract void writePayload(ByteBuffer var1);

    protected <T extends AbstractHttp2FrameBuilder<T, V>, V extends Http2Frame> Http2Frame(AbstractHttp2FrameBuilder<T, V> abstractHttp2FrameBuilder) {
        this.length = abstractHttp2FrameBuilder.getLength();
        this.type = abstractHttp2FrameBuilder.getType();
        this.flags = abstractHttp2FrameBuilder.getFlags();
        this.streamID = abstractHttp2FrameBuilder.getStreamID();
    }

    public static abstract class AbstractHttp2FrameBuilder<T extends AbstractHttp2FrameBuilder<T, V>, V extends Http2Frame> {
        private int length = -1;
        private short type;
        private byte flags;
        private int streamID;

        protected void setLength(int n) {
            this.length = n;
        }

        public T length(int n) {
            this.setLength(n);
            return (T)this;
        }

        public int getLength() {
            return this.length;
        }

        public T type(short s) {
            this.type = s;
            return (T)this;
        }

        public short getType() {
            return this.type;
        }

        protected void setFlags(byte by) {
            this.flags = by;
        }

        public T flags(byte by) {
            this.setFlags(by);
            return (T)this;
        }

        public byte getFlags() {
            return this.flags;
        }

        public T endHeaders() {
            this.addFlag((byte)4);
            return (T)this;
        }

        public T endStream() {
            this.addFlag((byte)1);
            return (T)this;
        }

        public T addFlag(byte by) {
            this.setFlags((byte)(this.getFlags() | by));
            return (T)this;
        }

        public boolean isFlagSet(byte by) {
            return (this.getFlags() & by) == by;
        }

        public T streamID(int n) {
            this.streamID = n;
            return (T)this;
        }

        public int getStreamID() {
            return this.streamID;
        }

        public abstract V build();
    }
}

