/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2Constants;
import org.apache.mina.http2.api.Http2Frame;

public class Http2DataFrame
extends Http2Frame {
    private final byte[] data;
    private final int offset;
    private final int dataLength;
    private final byte[] padding;

    public byte[] getData() {
        return this.data;
    }

    public byte[] getPadding() {
        return this.padding;
    }

    @Override
    public void writePayload(ByteBuffer byteBuffer) {
        if (this.isFlagSet((byte)8)) {
            byteBuffer.put((byte)this.getPadding().length);
        }
        byteBuffer.put(this.getData(), this.offset, this.dataLength);
        if (this.isFlagSet((byte)8)) {
            byteBuffer.put(this.getPadding());
        }
    }

    protected Http2DataFrame(Http2DataFrameBuilder http2DataFrameBuilder) {
        super(http2DataFrameBuilder);
        this.data = http2DataFrameBuilder.getData();
        this.offset = http2DataFrameBuilder.getOffset();
        this.dataLength = http2DataFrameBuilder.getDataLength();
        this.padding = http2DataFrameBuilder.getPadding();
    }

    public static class Http2DataFrameBuilder
    extends Http2Frame.AbstractHttp2FrameBuilder<Http2DataFrameBuilder, Http2DataFrame> {
        private byte[] data = Http2Constants.EMPTY_BYTE_ARRAY;
        private int offset = 0;
        private int dataLength = 0;
        private byte[] padding = Http2Constants.EMPTY_BYTE_ARRAY;

        public Http2DataFrameBuilder data(byte[] byArray) {
            this.data = byArray;
            this.dataLength = byArray.length;
            return this;
        }

        public Http2DataFrameBuilder data(byte[] byArray, int n, int n2) {
            this.data = byArray;
            this.offset = n;
            this.dataLength = n2;
            return this;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public Http2DataFrameBuilder padding(byte[] byArray) {
            this.padding = byArray;
            this.addFlag((byte)8);
            return this;
        }

        public byte[] getPadding() {
            return this.padding;
        }

        @Override
        public Http2DataFrame build() {
            if (this.getLength() == -1) {
                int n = this.dataLength;
                if (this.isFlagSet((byte)8)) {
                    n += this.getPadding().length + 1;
                }
                this.length(n);
            }
            return new Http2DataFrame((Http2DataFrameBuilder)this.type((short)0));
        }

        public static Http2DataFrameBuilder builder() {
            return new Http2DataFrameBuilder();
        }
    }
}

