/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import com.twitter.hpack.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2Constants;
import org.apache.mina.http2.api.Http2Frame;
import org.apache.mina.http2.impl.ConnectionErrorException;

public class Http2ContinuationFrame
extends Http2Frame {
    private final byte[] headerBlockFragment;

    public byte[] getHeaderBlockFragment() {
        return this.headerBlockFragment;
    }

    @Override
    public void writePayload(ByteBuffer byteBuffer) {
        byteBuffer.put(this.getHeaderBlockFragment());
    }

    protected Http2ContinuationFrame(Http2ContinuationFrameBuilder http2ContinuationFrameBuilder) {
        super(http2ContinuationFrameBuilder);
        this.headerBlockFragment = http2ContinuationFrameBuilder.getHeaderBlockFragment();
    }

    public static class Http2ContinuationFrameBuilder
    extends Http2Frame.AbstractHttp2FrameBuilder<Http2ContinuationFrameBuilder, Http2ContinuationFrame> {
        private byte[] headerBlockFragment = null;
        private ByteArrayOutputStream encoderOutput = new ByteArrayOutputStream();

        public Http2ContinuationFrameBuilder headerBlockFragment(byte[] byArray) {
            this.headerBlockFragment = byArray;
            return this;
        }

        public byte[] getHeaderBlockFragment() {
            return this.headerBlockFragment;
        }

        public Http2ContinuationFrameBuilder header(String string, String string2, Encoder encoder) throws ConnectionErrorException {
            try {
                encoder.encodeHeader((OutputStream)this.encoderOutput, string.toLowerCase().getBytes(Http2Constants.US_ASCII_CHARSET), string2.getBytes(Http2Constants.US_ASCII_CHARSET), false);
            }
            catch (IOException iOException) {
                throw new ConnectionErrorException(9, "Error decoding headers frame: " + iOException.getMessage());
            }
            return this;
        }

        public Http2ContinuationFrameBuilder headers(Map<String, String> map, Encoder encoder) throws ConnectionErrorException {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.header(entry.getKey(), entry.getValue(), encoder);
            }
            return this;
        }

        @Override
        public Http2ContinuationFrame build() {
            if (this.getHeaderBlockFragment() == null) {
                this.headerBlockFragment = this.encoderOutput.toByteArray();
            }
            int n = this.getHeaderBlockFragment() == null ? 0 : this.getHeaderBlockFragment().length;
            this.setLength(n);
            return new Http2ContinuationFrame((Http2ContinuationFrameBuilder)this.type((short)9));
        }

        public static Http2ContinuationFrameBuilder builder() {
            return new Http2ContinuationFrameBuilder();
        }
    }
}

