/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import java.nio.charset.Charset;
import java.util.Map;

public final class Http2Constants {
    public static final int HTTP2_31BITS_MASK = Integer.MAX_VALUE;
    public static final int HTTP2_EXCLUSIVE_MASK = Integer.MIN_VALUE;
    public static final int HTTP2_HEADER_LENGTH = 9;
    public static final short FRAME_TYPE_DATA = 0;
    public static final short FRAME_TYPE_HEADERS = 1;
    public static final short FRAME_TYPE_PRIORITY = 2;
    public static final short FRAME_TYPE_RST_STREAM = 3;
    public static final short FRAME_TYPE_SETTINGS = 4;
    public static final short FRAME_TYPE_PUSH_PROMISE = 5;
    public static final short FRAME_TYPE_PING = 6;
    public static final short FRAME_TYPE_GOAWAY = 7;
    public static final short FRAME_TYPE_WINDOW_UPDATE = 8;
    public static final short FRAME_TYPE_CONTINUATION = 9;
    public static final byte FLAGS_END_STREAM = 1;
    public static final byte FLAGS_ACK = 1;
    public static final byte FLAGS_END_HEADERS = 4;
    public static final byte FLAGS_PADDING = 8;
    public static final byte FLAGS_PRIORITY = 32;
    public static final Map<Integer, String> ERROR_CODES = Map.ofEntries(Map.entry(0, "NO_ERROR"), Map.entry(1, "PROTOCOL_ERROR"), Map.entry(2, "INTERNAL_ERROR"), Map.entry(3, "FLOW_CONTROL_ERROR"), Map.entry(4, "SETTINGS_TIMEOUT"), Map.entry(5, "STREAM_CLOSED"), Map.entry(6, "FRAME_SIZE_ERROR"), Map.entry(7, "REFUSED_STREAM"), Map.entry(8, "CANCEL"), Map.entry(9, "COMPRESSION_ERROR"), Map.entry(10, "CONNECT_ERROR"), Map.entry(11, "ENHANCE_YOUR_CALM"), Map.entry(12, "INADEQUATE_SECURITY"), Map.entry(13, "HTTP_1_1_REQUIRED"));
    public static final int NO_ERROR = 0;
    public static final int PROTOCOL_ERROR = 1;
    public static final int INTERNAL_ERROR = 2;
    public static final int FLOW_CONTROL_ERROR = 3;
    public static final int SETTINGS_TIMEOUT = 4;
    public static final int STREAM_CLOSED = 5;
    public static final int FRAME_SIZE_ERROR = 6;
    public static final int REFUSED_STREAM = 7;
    public static final int CANCEL = 8;
    public static final int COMPRESSION_ERROR = 9;
    public static final int CONNECT_ERROR = 10;
    public static final int ENHANCE_YOUR_CALM = 11;
    public static final int INADEQUATE_SECURITY = 12;
    public static final int HTTP_1_1_REQUIRED = 13;
    public static final int SETTINGS_HEADER_TABLE_SIZE = 1;
    public static final int SETTINGS_HEADER_TABLE_SIZE_DEFAULT = 4096;
    public static final int SETTINGS_ENABLE_PUSH = 2;
    public static final int SETTINGS_ENABLE_PUSH_DEFAULT = 1;
    public static final int SETTINGS_MAX_CONCURRENT_STREAMS = 3;
    public static final int SETTINGS_MAX_CONCURRENT_STREAMS_DEFAULT = Integer.MAX_VALUE;
    public static final int SETTINGS_INITIAL_WINDOW_SIZE = 4;
    public static final int SETTINGS_INITIAL_WINDOW_SIZE_DEFAULT = 65535;
    public static final int SETTINGS_MAX_FRAME_SIZE = 5;
    public static final int SETTINGS_MAX_FRAME_SIZE_DEFAULT = 16384;
    public static final int SETTINGS_MAX_HEADER_LIST_SIZE = 6;
    public static final int SETTINGS_MAX_HEADER_LIST_SIZE_DEFAULT = Integer.MAX_VALUE;
    public static final Charset US_ASCII_CHARSET = Charset.forName("US-ASCII");
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final String HTTP2_PROTOCOL_STR = "HTTP/2";
    public static final String HTTP2_DEBUG_STR = "debugHttp2Connections";
    public static final String HTTP2_TRACE_STR = "traceHttp2Connections";
}

