/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import com.twitter.hpack.Decoder;
import com.twitter.hpack.Encoder;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Http2PushBuilder;
import com.wowza.wms.server.Http2ResponseMessage;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.Server;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.http2.api.Http2Constants;
import org.apache.mina.http2.api.Http2ContinuationFrame;
import org.apache.mina.http2.api.Http2DataFrame;
import org.apache.mina.http2.api.Http2Frame;
import org.apache.mina.http2.api.Http2GoAwayFrame;
import org.apache.mina.http2.api.Http2Header;
import org.apache.mina.http2.api.Http2HeadersFrame;
import org.apache.mina.http2.api.Http2PingFrame;
import org.apache.mina.http2.api.Http2PushPromiseFrame;
import org.apache.mina.http2.api.Http2RstStreamFrame;
import org.apache.mina.http2.api.Http2ServerConnectionInput;
import org.apache.mina.http2.api.Http2ServerConnectionOutput;
import org.apache.mina.http2.api.Http2SettingsFrame;
import org.apache.mina.http2.api.Http2SettingsModel;
import org.apache.mina.http2.api.Http2Stream;
import org.apache.mina.http2.api.Http2StreamManager;
import org.apache.mina.http2.api.Http2WindowUpdateFrame;
import org.apache.mina.http2.impl.ConnectionErrorException;
import org.apache.mina.http2.impl.StreamErrorException;

public class Http2Connection
implements Http2ServerConnectionInput,
Http2ServerConnectionOutput {
    public static final String HTTP2_CONNECTION_PREAMBLE_STRING = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n";
    public static final java.nio.ByteBuffer HTTP2_CONNECTION_PREAMBLE = java.nio.ByteBuffer.wrap("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(StandardCharsets.UTF_8));
    public static final int HTTP2_CONNECTION_RESERVED_STREAM_ID = 0;
    private final String debugContextString;
    private final String remoteAddress;
    private final Http2StreamManager streamManager;
    private final IoSession session;
    private final ProtocolDecoderOutput protocolDecoderOutput;
    private boolean canCreateMoreStreams = true;
    private final Decoder decoder;
    private final Encoder encoder;
    private static final Class<Http2Connection> CLASS = Http2Connection.class;
    private final boolean debugHttp2;
    private final boolean traceHttp2;
    private boolean isPushAllowed = true;
    private int maxHeaderListSize = Integer.MAX_VALUE;

    private Http2Connection(IoSession ioSession, ProtocolDecoderOutput protocolDecoderOutput) {
        this.session = ioSession;
        this.protocolDecoderOutput = protocolDecoderOutput;
        this.remoteAddress = ioSession.getRemoteAddress().toString();
        this.debugContextString = this.getClass().getSimpleName() + "[Socket:" + this.remoteAddress + "]";
        this.sendSettings();
        this.decoder = new Decoder(Integer.MAX_VALUE, 4096);
        this.encoder = new Encoder(4096);
        Server server = Server.getInstance();
        this.debugHttp2 = server.debugHttp2Connections();
        this.traceHttp2 = server.traceHttp2Connections();
        this.streamManager = new Http2StreamManager(this.traceHttp2);
        if (this.debugHttp2) {
            this.logDebug("connection preface received, HTTP2 connection created");
        }
    }

    public static Http2Connection openConnection(ByteBuffer byteBuffer, IoSession ioSession, ProtocolDecoderOutput protocolDecoderOutput) throws Exception {
        byte[] byArray = new byte[24];
        if (byteBuffer.remaining() >= 24) {
            byteBuffer.get(byArray);
        }
        Http2Connection http2Connection = new Http2Connection(ioSession, protocolDecoderOutput);
        if (!java.nio.ByteBuffer.wrap(byArray).equals(HTTP2_CONNECTION_PREAMBLE)) {
            http2Connection.sendGoAwayFrame(1);
        }
        return http2Connection;
    }

    public void close() {
        if (this.debugHttp2) {
            this.logDebug("Close called for Http2ServerConnection");
        }
        this.streamManager.close();
        this.sendGoAwayFrame(0);
    }

    private void sendSettings() {
        if (this.traceHttp2) {
            this.logTrace("Sending default server connection settings");
        }
        this.session.write(Http2SettingsFrame.getConnectionSettingsDefaults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSettingsReceieved(Http2SettingsFrame http2SettingsFrame) {
        if (http2SettingsFrame.getStreamID() != 0) {
            this.sendGoAwayFrame(1, "SETTINGS frame received for stream other than reserved connection stream ID 0");
        }
        if (!http2SettingsFrame.isAckSettingsFrame()) {
            Http2SettingsModel http2SettingsModel = null;
            try {
                http2SettingsModel = new Http2SettingsModel(http2SettingsFrame);
                if (this.traceHttp2) {
                    this.logTrace("Received client SETTINGS frame: " + http2SettingsModel.toString());
                }
            }
            catch (Exception exception) {
                this.logError("Invalid SETTINGS frame received: " + exception.getMessage());
                this.sendGoAwayFrame(1);
                return;
            }
            try {
                this.isPushAllowed = http2SettingsModel.isPushEnabled();
                this.maxHeaderListSize = http2SettingsModel.getMaxHeaderListSize();
                this.streamManager.updateClientSettings(http2SettingsModel);
                Http2Connection http2Connection = this;
                synchronized (http2Connection) {
                    if (http2SettingsModel.getHeaderTableSize() < this.encoder.getMaxHeaderTableSize()) {
                        this.encoder.setMaxHeaderTableSize(new OutputStream(){

                            @Override
                            public void write(int n) throws IOException {
                            }
                        }, http2SettingsModel.getHeaderTableSize());
                    }
                }
            }
            catch (Exception exception) {
                this.sendGoAwayFrame(1, "Error occured while updating client SETTINGS: " + exception.getMessage());
            }
            this.session.write(Http2SettingsFrame.createAcknowledgementSettignsFrame());
        } else if (this.traceHttp2) {
            this.logDebug("Server SETTINGS frame acknowledged.");
        }
    }

    @Override
    public List<Http2Frame> sendResponse(Http2ResponseMessage http2ResponseMessage) {
        Http2Stream.StreamState streamState;
        int n = http2ResponseMessage.getHttp2StreamID();
        if (this.debugHttp2) {
            this.logDebug("Sending HTTP2 response for Stream: " + n + ", response code: " + http2ResponseMessage.getResponseCode() + ", response payload length: " + http2ResponseMessage.getBodyLength());
        }
        if ((streamState = this.streamManager.getStreamState(n)).equals((Object)Http2Stream.StreamState.HALF_CLOSED_REMOTE) || streamState.equals((Object)Http2Stream.StreamState.RESERVED_LOCAL)) {
            List<Http2Frame> list = this.streamManager.onSendResponse(http2ResponseMessage);
            if (!list.isEmpty() && list.get(list.size() - 1).isEndStream()) {
                this.streamManager.closeStream(http2ResponseMessage.getHttp2StreamID());
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public int sendPushPromise(Http2PushPromiseFrame http2PushPromiseFrame) {
        if (!this.isValidPushPromiseFrame(http2PushPromiseFrame)) {
            return 0;
        }
        if (this.traceHttp2) {
            this.logDebug(Http2Connection.streamLogPrefix(http2PushPromiseFrame) + "Sending PUSH_PROMISE frame");
        }
        int n = this.streamManager.createStream(http2PushPromiseFrame);
        http2PushPromiseFrame.setPromisedStreamId(n);
        if (this.traceHttp2) {
            this.logDebug("Reserved stream ID: " + n);
        }
        this.session.write(http2PushPromiseFrame);
        return n;
    }

    private boolean isValidPushPromiseFrame(Http2PushPromiseFrame http2PushPromiseFrame) {
        Http2Stream.StreamState streamState = this.streamManager.getStreamState(http2PushPromiseFrame.getStreamID());
        if (!this.canCreateMoreStreams || !this.isPushAllowed) {
            if (this.traceHttp2 && !this.canCreateMoreStreams) {
                this.logTrace(Http2Connection.streamLogPrefix(http2PushPromiseFrame) + "Send PUSH_PROMISE attempted, but streams are not allowed to be created");
            }
            if (this.traceHttp2 && !this.isPushAllowed) {
                this.logTrace(Http2Connection.streamLogPrefix(http2PushPromiseFrame) + "Send PUSH_PROMISE attempted, but has been disabled by client settings");
            }
            return false;
        }
        if (!streamState.equals((Object)Http2Stream.StreamState.HALF_CLOSED_REMOTE) && !streamState.equals((Object)Http2Stream.StreamState.OPEN)) {
            if (this.traceHttp2) {
                this.logTrace(Http2Connection.streamLogPrefix(http2PushPromiseFrame) + "Send PUSH_PROMISE attempted, but stream is not in HALF_CLOSED_REMOTE or OPEN state: " + streamState);
            }
            return false;
        }
        return true;
    }

    @Override
    public void onGoAwayFrameReceieved(Http2GoAwayFrame http2GoAwayFrame) {
        int n = (int)http2GoAwayFrame.getErrorCode();
        if (n == 8 || n == 0) {
            if (this.traceHttp2) {
                this.logDebug("GO_AWAY Frame received. Error code: " + n + ":" + Http2Constants.ERROR_CODES.get(n) + ", DebugInfo: " + StandardCharsets.UTF_8.decode(java.nio.ByteBuffer.wrap(http2GoAwayFrame.getData())) + "]");
            }
        } else {
            this.logWarn("GO_AWAY Frame received. Error code: " + n + ":" + Http2Constants.ERROR_CODES.get(n) + ", DebugInfo: " + StandardCharsets.UTF_8.decode(java.nio.ByteBuffer.wrap(http2GoAwayFrame.getData())) + "]");
        }
        this.canCreateMoreStreams = false;
        if (http2GoAwayFrame.getStreamID() != 0) {
            this.sendGoAwayFrame(1, "Received GO_AWAY frame on stream other than reserved connection stream ID 0");
        } else {
            this.close();
        }
    }

    @Override
    public void afterSendResponse(Http2ResponseMessage http2ResponseMessage) {
        Http2PushBuilder http2PushBuilder = http2ResponseMessage.getPushBuilder();
        if (http2PushBuilder != null) {
            CompletableFuture.runAsync(() -> http2PushBuilder.initiatePushRequests(this.session, this.protocolDecoderOutput));
        }
    }

    @Override
    public void onResetStreamFrame(Http2RstStreamFrame http2RstStreamFrame) {
        int n = (int)http2RstStreamFrame.getErrorCode();
        if (n == 8 || n == 0) {
            if (this.traceHttp2) {
                this.logTrace("RST_STREAM Frame received. Stream ID: " + http2RstStreamFrame.getStreamID() + ", error code: " + n + ", description: " + Http2Constants.ERROR_CODES.get((int)http2RstStreamFrame.getErrorCode()));
            }
        } else {
            this.logWarn("RST_FRAME Frame received. Stream ID: " + http2RstStreamFrame.getStreamID() + ", error code: " + n + ", description: " + Http2Constants.ERROR_CODES.get((int)http2RstStreamFrame.getErrorCode()));
        }
        if (http2RstStreamFrame.getStreamID() == 0) {
            this.sendGoAwayFrame(1, "RST_STREAM received on reserved connection stream ID 0");
        } else if (this.streamManager.getStreamState(http2RstStreamFrame.getStreamID()).equals((Object)Http2Stream.StreamState.IDLE)) {
            this.sendGoAwayFrame(1, "Received RST_STREAM for IDLE stream: " + http2RstStreamFrame.getStreamID());
        } else {
            this.streamManager.closeStream(http2RstStreamFrame.getStreamID());
        }
    }

    @Override
    public boolean onHeadersFrame(Http2HeadersFrame http2HeadersFrame) {
        boolean bl = this.isValidHeadersFrame(http2HeadersFrame);
        if (bl) {
            bl = this.streamManager.createStream(http2HeadersFrame);
        }
        if (bl && http2HeadersFrame.isEndHeaders()) {
            try {
                http2HeadersFrame.decodeHeaders(this.decoder);
            }
            catch (ConnectionErrorException connectionErrorException) {
                this.sendGoAwayFrame(connectionErrorException.getErrorCode(), "Stream ID: " + http2HeadersFrame.getStreamID() + ". " + connectionErrorException.getMessage());
                bl = false;
            }
            if (bl) {
                bl = this.isValidHeaders(http2HeadersFrame);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isValidHeadersFrame(Http2HeadersFrame http2HeadersFrame) {
        int n = http2HeadersFrame.getStreamID();
        if (n == 0) {
            this.sendGoAwayFrame(1, "HEADERS frame received on reserved connection stream id 0");
            return false;
        }
        if (n % 2 == 0) {
            this.sendGoAwayFrame(1, "HEADERS frame received on stream ID reserved for servers");
            return false;
        }
        Http2Stream.StreamState streamState = this.streamManager.getStreamState(n);
        if (streamState.equals((Object)Http2Stream.StreamState.CLOSED)) {
            this.sendGoAwayFrame(5, "HEADERS frame received on CLOSED stream");
            return false;
        }
        if (!streamState.equals((Object)Http2Stream.StreamState.IDLE)) {
            this.logWarn(Http2Connection.streamLogPrefix(http2HeadersFrame) + "HEADERS frame received for stream not in IDLE state, sending RST_STREAM");
            this.sendResetStream(5, n);
            return false;
        }
        return true;
    }

    private boolean isValidHeaders(Http2HeadersFrame http2HeadersFrame) {
        int n = http2HeadersFrame.getStreamID();
        String string = http2HeadersFrame.getHeaders().get(Http2Header.METHOD.getName());
        String string2 = http2HeadersFrame.getHeaders().get(Http2Header.PATH.getName());
        if (string == null || string2 == null) {
            this.logWarn("HEADERS frame received. " + Http2Connection.streamLogPrefix(http2HeadersFrame) + "Required pseudo-headers for: PATH, or METHOD not present. PATH: " + string2 + ", METHOD: " + string);
            this.sendResetStream(1, n);
            return false;
        }
        if (!((string.equals("GET") || string.equals("OPTIONS") || string.equals("CONNECT") || string.equals("HEAD")) && http2HeadersFrame.isEndStream())) {
            this.logWarn("HEADERS frame recieved. " + Http2Connection.streamLogPrefix(http2HeadersFrame) + "Only \"GET\",\"OPTIONS\",\"HEAD\" operations are permitted");
            this.sendUnsupportedOperationHttpResponse(n);
            return false;
        }
        if (this.debugHttp2) {
            this.logDebug("HEADERS frame received. Stream ID: " + n + ", PATH: " + string2 + ", METHOD: " + string);
        }
        return true;
    }

    private void sendUnsupportedOperationHttpResponse(int n) {
        RtmpRequestMessage rtmpRequestMessage = new RtmpRequestMessage();
        rtmpRequestMessage.setHttp2StreamId(n);
        Http2ResponseMessage http2ResponseMessage = new Http2ResponseMessage(null, rtmpRequestMessage);
        http2ResponseMessage.setResponseCode(501);
        this.session.write(http2ResponseMessage);
    }

    @Override
    public Http2HeadersFrame onContinuationFrame(Http2ContinuationFrame http2ContinuationFrame) {
        Http2HeadersFrame http2HeadersFrame;
        boolean bl = true;
        int n = http2ContinuationFrame.getStreamID();
        if (this.traceHttp2) {
            this.logDebug("CONTINUATION frame received for stream stream ID: " + n + ". Has headers?: " + (http2ContinuationFrame.getHeaderBlockFragment().length == 0));
        }
        Http2Stream.StreamState streamState = this.streamManager.getStreamState(n);
        if (!Http2Connection.isValidStreamIDForServer(n) || !streamState.equals((Object)Http2Stream.StreamState.OPEN)) {
            if (streamState.equals((Object)Http2Stream.StreamState.IDLE) || streamState.equals((Object)Http2Stream.StreamState.RESERVED_LOCAL)) {
                this.sendGoAwayFrame(1, "Continuation frame received for stream not in OPEN state, or has invalid stream ID: " + n);
            } else {
                this.logWarn(Http2Connection.streamLogPrefix(http2ContinuationFrame) + "Continuation frame received for invalid state: " + this.streamManager.getStreamState(n) + ". Has headers?: " + (http2ContinuationFrame.getHeaderBlockFragment().length == 0));
                this.sendResetStream(5, n);
            }
            bl = false;
        }
        if ((http2HeadersFrame = this.streamManager.onContinuationFrame(http2ContinuationFrame)) != null) {
            try {
                http2HeadersFrame.decodeHeaders(this.decoder);
            }
            catch (ConnectionErrorException connectionErrorException) {
                this.sendGoAwayFrame(connectionErrorException.getErrorCode(), "Error when decoding headers for continuation frame, StreamID: " + http2HeadersFrame.getStreamID() + ". Error: " + connectionErrorException.getMessage());
                bl = false;
            }
            if (bl && this.isValidHeaders(http2HeadersFrame)) {
                return http2HeadersFrame;
            }
        }
        return null;
    }

    @Override
    public void onWindowUpdateFrame(Http2WindowUpdateFrame http2WindowUpdateFrame) {
        if (http2WindowUpdateFrame.getWindowUpdateIncrement() <= 0) {
            if (http2WindowUpdateFrame.getWindowUpdateIncrement() == 0) {
                if (http2WindowUpdateFrame.getStreamID() == 0) {
                    this.sendGoAwayFrame(1);
                } else {
                    this.sendResetStream(1, http2WindowUpdateFrame.getStreamID());
                }
            } else if (http2WindowUpdateFrame.getStreamID() == 0) {
                this.sendGoAwayFrame(3);
            } else {
                this.sendResetStream(3, http2WindowUpdateFrame.getStreamID());
            }
        } else {
            try {
                List<Http2DataFrame> list;
                if (this.traceHttp2) {
                    this.logTrace("WINDOW_UPDATE frame received for stream: " + http2WindowUpdateFrame.getStreamID() + ", amount: " + http2WindowUpdateFrame.getWindowUpdateIncrement());
                }
                if (!(list = this.streamManager.onWindowUpdate(http2WindowUpdateFrame)).isEmpty()) {
                    this.session.write(list);
                }
            }
            catch (ConnectionErrorException connectionErrorException) {
                this.sendGoAwayFrame(1, connectionErrorException.getMessage());
            }
            catch (StreamErrorException streamErrorException) {
                this.sendGoAwayFrame(streamErrorException.getErrorCode(), streamErrorException.getMessage());
            }
        }
    }

    @Override
    public void onUnknownFrame(Http2Frame http2Frame) {
        if (this.traceHttp2) {
            this.logTrace("UnknownFrame of type: " + http2Frame.getType() + " found for stream" + http2Frame.getStreamID());
        }
    }

    @Override
    public void onPingFrame(Http2PingFrame http2PingFrame) {
        boolean bl = this.isValidPingFrame(http2PingFrame);
        if (bl) {
            this.session.write(((Http2PingFrame.Http2PingFrameBuilder)((Http2PingFrame.Http2PingFrameBuilder)Http2PingFrame.Http2PingFrameBuilder.builder().data(http2PingFrame.getData()).addFlag((byte)1)).length(8)).build());
        }
    }

    private boolean isValidPingFrame(Http2PingFrame http2PingFrame) {
        if (http2PingFrame.getStreamID() != 0) {
            this.sendGoAwayFrame(1, "Ping frame received on non-zero stream ID");
            return false;
        }
        if (http2PingFrame.getLength() != 8) {
            this.sendGoAwayFrame(6, "Ping frame received without 8 byte data length");
            return false;
        }
        return true;
    }

    private static boolean isValidStreamIDForServer(int n) {
        return n != 0 && n % 2 != 0;
    }

    private void sendResetStream(int n, int n2) {
        Http2RstStreamFrame http2RstStreamFrame = ((Http2RstStreamFrame.Http2RstStreamFrameBuilder)((Http2RstStreamFrame.Http2RstStreamFrameBuilder)Http2RstStreamFrame.Http2RstStreamFrameBuilder.builder().errorCode(n).streamID(n2)).endStream()).build();
        this.closeStream(http2RstStreamFrame);
    }

    private void sendGoAwayFrame(int n) {
        this.sendGoAwayFrame(n, null);
    }

    public void sendGoAwayFrame(int n, String string) {
        if (n != 0) {
            this.logError("GO_AWAY frame being sent for connection: [" + n + ":" + Http2Constants.ERROR_CODES.get(n) + ",DebugInfo:" + string + "]");
        } else if (this.traceHttp2) {
            this.logWarn("GO_AWAY frame being sent for connection: [" + n + ":" + Http2Constants.ERROR_CODES.get(n) + ",DebugInfo:" + string + "]");
        }
        Http2GoAwayFrame http2GoAwayFrame = this.streamManager.createConnectionError(n, string);
        this.session.write(http2GoAwayFrame);
    }

    private void closeStream(Http2Frame http2Frame) {
        this.streamManager.closeStream(http2Frame.getStreamID());
        this.session.write(http2Frame);
    }

    public Http2Stream.StreamState getStreamState(int n) {
        return this.streamManager.getStreamState(n);
    }

    public String toString() {
        return this.remoteAddress;
    }

    @Override
    public void onPushPromiseFrame(Http2PushPromiseFrame http2PushPromiseFrame) {
        this.sendGoAwayFrame(1, "Clients can not send PUSH_PROMISE frames to servers");
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public int getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    private void logInfo(String string) {
        WMSLoggerFactory.getLogger(CLASS).info(this.debugContextString + ": " + string + ". Time: " + System.currentTimeMillis());
    }

    private void logDebug(String string) {
        WMSLoggerFactory.getLogger(CLASS).info(this.debugContextString + ": " + string + ". Time: " + System.currentTimeMillis());
    }

    private void logTrace(String string) {
        WMSLoggerFactory.getLogger(CLASS).info(this.debugContextString + ": " + string + ". Time: " + System.currentTimeMillis());
    }

    private void logWarn(String string) {
        WMSLoggerFactory.getLogger(CLASS).warn(this.debugContextString + ": " + string + ". Time: " + System.currentTimeMillis());
    }

    private void logError(String string) {
        WMSLoggerFactory.getLogger(CLASS).error(this.debugContextString + ": " + string + ". Time: " + System.currentTimeMillis());
    }

    private static String streamLogPrefix(Http2Frame http2Frame) {
        return "StreamID: " + http2Frame.getStreamID() + ": ";
    }
}

