/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.support.IoSessionInputStream;
import org.apache.mina.util.SessionLog;

public abstract class StreamIoHandler
extends IoHandlerAdapter {
    private static final String KEY_IN = StreamIoHandler.class.getName() + ".in";
    private static final String KEY_OUT = StreamIoHandler.class.getName() + ".out";
    private int readTimeout;
    private int writeTimeout;

    protected StreamIoHandler() {
    }

    protected abstract void processStreamIo(IoSession var1, InputStream var2, OutputStream var3);

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int n) {
        this.writeTimeout = n;
    }

    @Override
    public void sessionOpened(IoSession ioSession) {
        ioSession.setWriteTimeout(this.writeTimeout);
        ioSession.setIdleTime(IdleStatus.READER_IDLE, this.readTimeout);
        IoSessionInputStream ioSessionInputStream = new IoSessionInputStream();
        OutputStream outputStream = null;
        ioSession.setAttribute(KEY_IN, ioSessionInputStream);
        ioSession.setAttribute(KEY_OUT, outputStream);
        this.processStreamIo(ioSession, ioSessionInputStream, outputStream);
    }

    @Override
    public void messageReceived(IoSession ioSession, Object object) {
        IoSessionInputStream ioSessionInputStream = (IoSessionInputStream)ioSession.getAttribute(KEY_IN);
        ioSessionInputStream.write((ByteBuffer)object);
    }

    @Override
    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
        IoSessionInputStream ioSessionInputStream = (IoSessionInputStream)ioSession.getAttribute(KEY_IN);
        IOException iOException = null;
        if (throwable instanceof StreamIoException) {
            iOException = (IOException)throwable.getCause();
        } else if (throwable instanceof IOException) {
            iOException = (IOException)throwable;
        }
        if (iOException != null && ioSessionInputStream != null) {
            ioSessionInputStream.throwException(iOException);
        } else {
            SessionLog.warn(ioSession, "Unexpected exception.", throwable);
            ioSession.close();
        }
    }

    @Override
    public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) {
        if (idleStatus == IdleStatus.READER_IDLE) {
            throw new StreamIoException(new SocketTimeoutException("Read timeout"));
        }
    }

    private static class StreamIoException
    extends RuntimeException {
        private static final long serialVersionUID = 3976736960742503222L;

        public StreamIoException(IOException iOException) {
            super(iOException);
        }
    }
}

