/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.mina.filter.support.ISSLSNIHandler;
import org.apache.mina.filter.support.SSLCapabilities;
import org.apache.mina.filter.support.SSLExplorer;
import org.apache.mina.filter.support.SSLSNIServerName;

public class SSLSNIHandler
implements ISSLSNIHandler {
    public static final int SNI_INITIALBUFFERSIZE = 1024;
    private byte[] buffer = new byte[1024];
    private int position = 0;
    private boolean doneHello = false;
    private String versionRecord = null;
    private String versionHello = null;
    private SSLSNIServerName hostName = null;

    @Override
    public void handleMessage(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2 = byteBuffer.remaining();
        if (this.position + n2 > this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.position + n2);
        }
        byteBuffer.get(this.buffer, this.position, n2);
        this.position += n2;
        if (this.position >= 5 && (n = SSLExplorer.getRequiredSize(this.buffer, 0, this.position)) > 0 && this.position >= n) {
            this.doneHello = true;
            SSLCapabilities sSLCapabilities = SSLExplorer.explore(this.buffer, 0, n);
            if (sSLCapabilities != null) {
                this.versionRecord = sSLCapabilities.getRecordVersion();
                this.versionHello = sSLCapabilities.getHelloVersion();
                List<SSLSNIServerName> list = sSLCapabilities.getServerNames();
                if (list != null && list.size() > 0) {
                    for (SSLSNIServerName sSLSNIServerName : list) {
                        if (sSLSNIServerName.getType() != 0) continue;
                        this.hostName = sSLSNIServerName;
                    }
                }
            }
        }
    }

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean isDoneHello() {
        return this.doneHello;
    }

    @Override
    public String getVersionRecord() {
        return this.versionRecord;
    }

    @Override
    public String getVersionHello() {
        return this.versionHello;
    }

    @Override
    public SSLSNIServerName getHostName() {
        return this.hostName;
    }
}

