/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.support;

import com.wowza.util.StringUtils;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.vhost.DomainToKeyStoreMapEntry;
import com.wowza.wms.vhost.DomainToKeyStoreMapList;
import com.wowza.wms.vhost.IVHost;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.DefaultWriteFuture;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.support.SSLByteBufferSimple;
import org.apache.mina.filter.support.SSLSNIHandler;
import org.apache.mina.filter.support.SSLSNIServerName;
import org.apache.mina.util.SessionLog;

public class SSLHandler {
    private static final String CLASSNAME = "SSLHandler";
    private static final Class<SSLHandler> CLASS = SSLHandler.class;
    public static final int DEFAULT_SSLPACKETSIZE = 32768;
    public static final int DEFAULT_SSLPERPACKETOVERHEAD = 128;
    private final SSLFilter parent;
    private final SSLContext ctx;
    private final IoSession session;
    private final Queue<Event> preHandshakeEventQueue = new ConcurrentLinkedQueue<Event>();
    private final Queue<Event> filterWriteEventQueue = new ConcurrentLinkedQueue<Event>();
    private final Queue<Event> messageReceivedEventQueue = new ConcurrentLinkedQueue<Event>();
    private SSLEngine sslEngine;
    public static boolean sslSessionDebug = false;
    public static final String HTTP_1_1 = "http/1.1";
    public static final String HTTP_1_0 = "http/1.0";
    public static final String HTTP_2_0 = "h2";
    public static Map<String, Byte> ALPN_SUPPORTED_PROTOCOL_MAP = Map.of("http/1.0", (byte)33, "http/1.1", (byte)33, "h2", (byte)52);
    private java.nio.ByteBuffer inNetBuffer;
    private java.nio.ByteBuffer outNetBuffer;
    private java.nio.ByteBuffer appBuffer;
    private final java.nio.ByteBuffer hsBB = java.nio.ByteBuffer.allocate(0);
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private boolean initialHandshakeComplete;
    private boolean handshakeComplete;
    private boolean writingEncryptedData;
    private String domainToKeyStoreMapPathStr = null;
    private IVHost vhost = null;
    private SSLSNIHandler sniHandler = null;
    private int packetBufferSize = 0;
    private int applicationBufferSize = 0;
    private WMSLogger debugLogger = null;
    private static BiFunction<SSLEngine, List<String>, String> applicationLayerProtocolSelector = (sSLEngine, list) -> {
        SSLSession sSLSession = sSLEngine.getHandshakeSession();
        for (String string : list) {
            if (!ALPN_SUPPORTED_PROTOCOL_MAP.containsKey(string)) continue;
            return string;
        }
        throw new IllegalStateException("No supported protocol between client and server found");
    };

    public SSLHandler(SSLFilter sSLFilter, SSLContext sSLContext, IoSession ioSession, IVHost iVHost, String string) throws SSLException {
        this.initLogging();
        this.parent = sSLFilter;
        this.session = ioSession;
        this.ctx = sSLContext;
        this.vhost = iVHost;
        this.domainToKeyStoreMapPathStr = string;
        this.init();
    }

    private void initLogging() {
        this.debugLogger = WMSLoggerFactory.getLogger(CLASS);
        if (this.debugLogger == null || !this.debugLogger.isDebugEnabled()) {
            this.debugLogger = null;
        }
    }

    public void init() throws SSLException {
        if (this.sslEngine != null) {
            return;
        }
        if (this.domainToKeyStoreMapPathStr == null) {
            this.initEngine(this.ctx);
        } else {
            this.sniHandler = new SSLSNIHandler();
        }
    }

    public void initEngine(SSLContext sSLContext) throws SSLException {
        Object object;
        if (this.sslEngine != null) {
            return;
        }
        if (this.parent.isUseClientMode() && (object = this.getSession().getRemoteAddress()) instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)object;
            String string = inetSocketAddress.getHostString();
            int n = inetSocketAddress.getPort();
            if (string != null && string.length() > 0) {
                this.sslEngine = sSLContext.createSSLEngine(string, n);
            }
        }
        if (this.sslEngine == null) {
            this.sslEngine = sSLContext.createSSLEngine();
        }
        this.sslEngine.setUseClientMode(this.parent.isUseClientMode());
        object = this.sslEngine.getSession();
        if (object != null) {
            this.packetBufferSize = object.getPacketBufferSize();
            this.applicationBufferSize = object.getApplicationBufferSize();
        }
        if (this.parent.isWantClientAuth()) {
            this.sslEngine.setWantClientAuth(true);
        }
        if (this.parent.isNeedClientAuth()) {
            this.sslEngine.setNeedClientAuth(true);
        }
        if (this.parent.getEnabledCipherSuites() != null) {
            this.sslEngine.setEnabledCipherSuites(this.parent.getEnabledCipherSuites());
        }
        if (this.parent.getEnabledProtocols() != null) {
            this.sslEngine.setEnabledProtocols(this.parent.getEnabledProtocols());
        }
        if (this.parent.doesAllowHttp2()) {
            this.sslEngine.setHandshakeApplicationProtocolSelector(applicationLayerProtocolSelector);
        }
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        this.handshakeComplete = false;
        this.initialHandshakeComplete = false;
        SSLByteBufferSimple.initiate(this.sslEngine);
        this.appBuffer = SSLByteBufferSimple.getApplicationBuffer();
        this.inNetBuffer = SSLByteBufferSimple.getPacketBuffer();
        this.outNetBuffer = SSLByteBufferSimple.getPacketBuffer();
        this.outNetBuffer.position(0);
        this.outNetBuffer.limit(0);
        this.writingEncryptedData = false;
    }

    public void destroy() {
        block7: {
            block6: {
                if (this.sslEngine == null) {
                    return;
                }
                try {
                    this.sslEngine.closeInbound();
                }
                catch (SSLException sSLException) {
                    if (this.debugLogger == null) break block6;
                    this.debugLogger.debug("SSLHandler.destroy: Unexpected exception from SSLEngine.closeInbound().", (Throwable)sSLException);
                }
            }
            try {
                do {
                    this.outNetBuffer.clear();
                } while (this.sslEngine.wrap(this.hsBB, this.outNetBuffer).bytesProduced() > 0);
            }
            catch (SSLException sSLException) {
                if (this.debugLogger == null) break block7;
                this.debugLogger.debug("SSLHandler.destroy: Unexpected exception from SSLEngine.wrap().", (Throwable)sSLException);
            }
        }
        this.sslEngine.closeOutbound();
        this.sslEngine = null;
        SSLByteBufferSimple.release(this.appBuffer);
        SSLByteBufferSimple.release(this.inNetBuffer);
        SSLByteBufferSimple.release(this.outNetBuffer);
        this.preHandshakeEventQueue.clear();
    }

    public SSLFilter getParent() {
        return this.parent;
    }

    public IoSession getSession() {
        return this.session;
    }

    public boolean isWritingEncryptedData() {
        return this.writingEncryptedData;
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public boolean isInboundDone() {
        return !(this.sniHandler != null && !this.sniHandler.isDoneHello() || this.sslEngine != null && !this.sslEngine.isInboundDone());
    }

    public boolean isOutboundDone() {
        return !(this.sniHandler != null && !this.sniHandler.isDoneHello() || this.sslEngine != null && !this.sslEngine.isOutboundDone());
    }

    public boolean needToCompleteHandshake() {
        return this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && !this.isInboundDone();
    }

    public void schedulePreHandshakeWriteRequest(IoFilter.NextFilter nextFilter, IoFilter.WriteRequest writeRequest) {
        this.preHandshakeEventQueue.offer(new Event(EventType.FILTER_WRITE, nextFilter, writeRequest));
    }

    public void flushPreHandshakeEvents() throws SSLException {
        Event event;
        while ((event = this.preHandshakeEventQueue.poll()) != null) {
            this.parent.filterWrite(event.nextFilter, this.session, (IoFilter.WriteRequest)event.data);
        }
    }

    public void scheduleFilterWrite(IoFilter.NextFilter nextFilter, IoFilter.WriteRequest writeRequest) {
        this.filterWriteEventQueue.offer(new Event(EventType.FILTER_WRITE, nextFilter, writeRequest));
    }

    public void flushFilterWrite() {
        Event event;
        while ((event = this.filterWriteEventQueue.poll()) != null) {
            event.nextFilter.filterWrite(this.session, (IoFilter.WriteRequest)event.data);
        }
    }

    public void scheduleMessageReceived(IoFilter.NextFilter nextFilter, Object object) {
        this.messageReceivedEventQueue.offer(new Event(EventType.RECEIVED, nextFilter, object));
    }

    public void flushMessageReceived() {
        Event event;
        while ((event = this.messageReceivedEventQueue.poll()) != null) {
            event.nextFilter.messageReceived(this.session, event.data);
        }
    }

    public boolean doSNI() {
        return this.sniHandler != null && !this.sniHandler.isDoneHello();
    }

    public java.nio.ByteBuffer handleSNI(java.nio.ByteBuffer byteBuffer) throws SSLException {
        Object object = null;
        try {
            this.sniHandler.handleMessage(byteBuffer);
        }
        catch (Exception exception) {
            throw new SSLException(exception);
        }
        if (this.sniHandler.isDoneHello()) {
            Object object2;
            String string = null;
            SSLSNIServerName sSLSNIServerName = this.sniHandler.getHostName();
            if (sSLSNIServerName != null) {
                try {
                    string = sSLSNIServerName.getAsciiName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string != null && string.length() <= 0) {
                string = null;
            }
            DomainToKeyStoreMapEntry domainToKeyStoreMapEntry = null;
            DomainToKeyStoreMapList domainToKeyStoreMapList = this.vhost.getDomainToKeyStoreMapList();
            if (domainToKeyStoreMapList != null && (object2 = domainToKeyStoreMapList.getMap(this.domainToKeyStoreMapPathStr)) != null) {
                domainToKeyStoreMapEntry = string != null ? object2.findMatch(string) : object2.getLastEntry();
            }
            if (this.parent.isLogConnectionInfo()) {
                WMSLoggerFactory.getLogger(null).info("SSLHandler.connectionInfo: host:" + string + " mapEntry:" + domainToKeyStoreMapEntry);
            }
            if (domainToKeyStoreMapEntry != null && domainToKeyStoreMapEntry.getSSLContext() != null) {
                this.initEngine(domainToKeyStoreMapEntry.getSSLContext());
            } else {
                WMSLoggerFactory.getLogger(null).warn("SSLHandler.messageReceived: Unable to map to SSL Certificate: hostName:" + string + " mapPath:" + this.domainToKeyStoreMapPathStr);
            }
            object2 = java.nio.ByteBuffer.allocate(this.sniHandler.getPosition());
            ((java.nio.ByteBuffer)object2).put(this.sniHandler.getBuffer(), 0, this.sniHandler.getPosition());
            ((java.nio.ByteBuffer)object2).flip();
            object = object2;
        }
        return object;
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, java.nio.ByteBuffer byteBuffer) throws SSLException {
        if (byteBuffer.limit() > this.inNetBuffer.remaining()) {
            this.inNetBuffer = SSLByteBufferSimple.expandBuffer(this.inNetBuffer, this.inNetBuffer.capacity() + byteBuffer.limit() * 2);
            this.appBuffer = SSLByteBufferSimple.expandBuffer(this.appBuffer, this.inNetBuffer.capacity() * 2);
            if (this.debugLogger != null) {
                this.debugLogger.debug("SSLHandler.destroy: expanded inNetBuffer:" + SessionLog.logBuffer(this.inNetBuffer) + " appBuffer:" + SessionLog.logBuffer(this.appBuffer));
            }
        }
        this.inNetBuffer.put(byteBuffer);
        if (!this.handshakeComplete) {
            this.handshake(nextFilter);
        } else {
            this.decrypt(nextFilter);
        }
        if (this.isInboundDone()) {
            byteBuffer.position(byteBuffer.position() - this.inNetBuffer.position());
            this.inNetBuffer.clear();
        }
    }

    public java.nio.ByteBuffer getAppBuffer() {
        return this.appBuffer;
    }

    public java.nio.ByteBuffer getOutNetBuffer() {
        return this.outNetBuffer;
    }

    public void encrypt(java.nio.ByteBuffer[] byteBufferArray, ByteBuffer byteBuffer) throws SSLException {
        int n;
        if (!this.handshakeComplete) {
            throw new IllegalStateException();
        }
        int n2 = this.packetBufferSize;
        if (n2 <= 0) {
            n2 = 32768;
        }
        byteBuffer.clear();
        int n3 = 0;
        for (n = 0; n < byteBufferArray.length; ++n) {
            n3 += byteBufferArray[n].remaining();
        }
        n = n3;
        if (this.debugLogger != null) {
            this.debugLogger.debug("SSLHandler.encrypt: Enter: srcBuffers[" + byteBufferArray.length + "]: totalBytes:" + n3);
        }
        int n4 = 0;
        while (n4 < byteBufferArray.length && n > 0) {
            SSLEngineResult sSLEngineResult;
            int n5 = n / n2 + 1;
            int n6 = n5 * (n2 + 128);
            if (byteBuffer.capacity() - byteBuffer.position() < n6) {
                byteBuffer.capacity(byteBuffer.capacity() * 2);
                if (this.debugLogger != null) {
                    this.debugLogger.debug("SSLHandler.encrypt: expanded outNetBuffer[" + n + "/" + n3 + "]:" + SessionLog.logBuffer(byteBuffer));
                }
            }
            if ((sSLEngineResult = this.sslEngine.wrap(byteBufferArray, n4, byteBufferArray.length - n4, byteBuffer.buf())) == null) break;
            n -= sSLEngineResult.bytesConsumed();
            while (!byteBufferArray[n4].hasRemaining() && ++n4 < byteBufferArray.length) {
            }
            if (this.debugLogger != null) {
                this.debugLogger.debug("SSLHandler.encrypt: Wrap res[" + n + "/" + n3 + "]:" + sSLEngineResult);
            }
            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
                if (sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                this.doTasks();
                continue;
            }
            throw new SSLException("SSLEngine error during encrypt: " + sSLEngineResult.getStatus());
        }
        byteBuffer.flip();
    }

    public boolean closeOutbound() throws SSLException {
        if (this.sslEngine == null || this.sslEngine.isOutboundDone()) {
            return false;
        }
        this.sslEngine.closeOutbound();
        this.outNetBuffer.clear();
        SSLEngineResult sSLEngineResult = this.sslEngine.wrap(this.hsBB, this.outNetBuffer);
        if (sSLEngineResult.getStatus() != SSLEngineResult.Status.CLOSED) {
            throw new SSLException("Improper close state: " + sSLEngineResult);
        }
        this.outNetBuffer.flip();
        return true;
    }

    private void decrypt(IoFilter.NextFilter nextFilter) throws SSLException {
        if (!this.handshakeComplete) {
            throw new IllegalStateException();
        }
        this.unwrap(nextFilter);
    }

    private void checkStatus(SSLEngineResult sSLEngineResult) throws SSLException {
        SSLEngineResult.Status status = sSLEngineResult.getStatus();
        if (status != SSLEngineResult.Status.OK && status != SSLEngineResult.Status.CLOSED && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            throw new SSLException("SSLEngine error during decrypt: " + status + " inNetBuffer: " + this.inNetBuffer + "appBuffer: " + this.appBuffer);
        }
    }

    public void handshake(IoFilter.NextFilter nextFilter) throws SSLException {
        block19: {
            if (this.debugLogger != null) {
                this.debugLogger.debug("SSLHandler.handshake: doHandshake()");
            }
            if (this.sslEngine == null) {
                return;
            }
            while (true) {
                Object object;
                if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                    String string;
                    this.session.setAttribute(SSLFilter.SSL_SESSION, this.sslEngine.getSession());
                    if ((this.debugLogger != null || this.parent.isLogConnectionInfo()) && (object = this.sslEngine.getSession()) != null) {
                        string = "unknown";
                        if (this.ctx != null && this.ctx.getProvider() != null) {
                            string = this.ctx.getProvider().getName();
                        }
                        String string2 = "SSLHandler.handshake: SSLHandler.connectionInfo: protocol:" + object.getProtocol() + " cipher:" + object.getCipherSuite() + " providerName:" + string;
                        WMSLoggerFactory.getLogger(CLASS).info(string2);
                    }
                    this.handshakeComplete = true;
                    object = this.sslEngine.getApplicationProtocol();
                    if (!StringUtils.isEmpty((String)object) && this.sslEngine.getHandshakeApplicationProtocolSelector() != null) {
                        string = (RtmpSessionInfo)this.session.getAttribute("wmsSessionInfo");
                        if (ALPN_SUPPORTED_PROTOCOL_MAP.get(object).equals((byte)52)) {
                            string.setProtocol((int)ALPN_SUPPORTED_PROTOCOL_MAP.get(object).byteValue());
                        }
                    }
                    this.unwrap(nextFilter);
                    if (!this.initialHandshakeComplete && this.session.containsAttribute(SSLFilter.USE_NOTIFICATION)) {
                        this.initialHandshakeComplete = true;
                        this.scheduleMessageReceived(nextFilter, SSLFilter.SESSION_SECURED);
                    }
                    break block19;
                }
                if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    if (this.debugLogger != null) {
                        this.debugLogger.debug("SSLHandler.handshake: handshakeStatus=NEED_TASK");
                    }
                    this.handshakeStatus = this.doTasks();
                    continue;
                }
                if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    if (this.debugLogger != null) {
                        this.debugLogger.debug("SSLHandler.handshake: handshakeStatus=NEED_UNWRAP");
                    }
                    if ((object = this.unwrapHandshake(nextFilter)) != SSLEngineResult.Status.BUFFER_UNDERFLOW && !this.isInboundDone()) continue;
                    break block19;
                }
                if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
                if (this.debugLogger != null) {
                    this.debugLogger.debug("SSLHandler.handshake: handshakeStatus=NEED_WRAP");
                }
                if (this.outNetBuffer.hasRemaining()) {
                    if (this.debugLogger != null) {
                        this.debugLogger.debug("SSLHandler.handshake: Still data in out buffer!");
                    }
                    break block19;
                }
                this.outNetBuffer.clear();
                if (sslSessionDebug) {
                    WMSLoggerFactory.getLogger(SSLHandler.class).info("Starting handshake wrap for client: " + this.getSession().getRemoteAddress() + " SSLHandler instance: " + String.format("0x%08X", this.hashCode()));
                }
                object = this.sslEngine.wrap(this.hsBB, this.outNetBuffer);
                if (sslSessionDebug) {
                    WMSLoggerFactory.getLogger(SSLHandler.class).info("Finished handshake wrap for client: " + this.getSession().getRemoteAddress() + " SSLHandler instance: " + String.format("0x%08X", this.hashCode()));
                }
                if (this.debugLogger != null) {
                    this.debugLogger.debug("SSLHandler.handshake: Wrap res:" + (SSLEngineResult)object);
                }
                this.outNetBuffer.flip();
                this.handshakeStatus = ((SSLEngineResult)object).getHandshakeStatus();
                this.writeNetBuffer(nextFilter);
            }
            throw new IllegalStateException("Invalid Handshaking State" + this.handshakeStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture writeNetBuffer(IoFilter.NextFilter nextFilter) throws SSLException {
        if (!this.getOutNetBuffer().hasRemaining()) {
            return DefaultWriteFuture.newNotWrittenFuture(this.session);
        }
        this.writingEncryptedData = true;
        DefaultWriteFuture defaultWriteFuture = null;
        try {
            if (this.debugLogger != null) {
                this.debugLogger.debug("SSLHandler.writeNetBuffer: write outNetBuffer: " + SessionLog.logBuffer(this.getOutNetBuffer()));
            }
            ByteBuffer byteBuffer = SSLHandler.copy(this.getOutNetBuffer());
            if (this.debugLogger != null) {
                this.debugLogger.debug("SSLHandler.writeNetBuffer: session write: " + SessionLog.logBuffer(byteBuffer));
            }
            defaultWriteFuture = new DefaultWriteFuture(this.session);
            this.parent.filterWrite(nextFilter, this.session, new IoFilter.WriteRequest(byteBuffer, defaultWriteFuture));
            while (this.needToCompleteHandshake()) {
                try {
                    this.handshake(nextFilter);
                }
                catch (SSLException sSLException) {
                    SSLHandshakeException sSLHandshakeException = new SSLHandshakeException("SSL handshake failed.");
                    sSLHandshakeException.initCause(sSLException);
                    throw sSLHandshakeException;
                }
                if (!this.getOutNetBuffer().hasRemaining()) continue;
                if (this.debugLogger != null) {
                    this.debugLogger.debug("SSLHandler.writeNetBuffer: write outNetBuffer2: " + this.getOutNetBuffer());
                }
                ByteBuffer byteBuffer2 = SSLHandler.copy(this.getOutNetBuffer());
                defaultWriteFuture = new DefaultWriteFuture(this.session);
                this.parent.filterWrite(nextFilter, this.session, new IoFilter.WriteRequest(byteBuffer2, defaultWriteFuture));
            }
        }
        finally {
            this.writingEncryptedData = false;
        }
        return defaultWriteFuture;
    }

    private void unwrap(IoFilter.NextFilter nextFilter) throws SSLException {
        if (this.debugLogger != null) {
            this.debugLogger.debug("SSLHandler.unwrap()");
        }
        this.inNetBuffer.flip();
        SSLEngineResult sSLEngineResult = this.unwrap0();
        this.inNetBuffer.compact();
        this.checkStatus(sSLEngineResult);
        this.renegotiateIfNeeded(nextFilter, sSLEngineResult);
    }

    private SSLEngineResult.Status unwrapHandshake(IoFilter.NextFilter nextFilter) throws SSLException {
        if (this.debugLogger != null) {
            this.debugLogger.debug("SSLHandler.unwrapHandshake()");
        }
        this.inNetBuffer.flip();
        SSLEngineResult sSLEngineResult = this.unwrap0();
        this.handshakeStatus = sSLEngineResult.getHandshakeStatus();
        this.checkStatus(sSLEngineResult);
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED && sSLEngineResult.getStatus() == SSLEngineResult.Status.OK && this.inNetBuffer.hasRemaining()) {
            sSLEngineResult = this.unwrap0();
            this.inNetBuffer.compact();
            this.renegotiateIfNeeded(nextFilter, sSLEngineResult);
        } else {
            this.inNetBuffer.compact();
        }
        return sSLEngineResult.getStatus();
    }

    private void renegotiateIfNeeded(IoFilter.NextFilter nextFilter, SSLEngineResult sSLEngineResult) throws SSLException {
        if (sSLEngineResult.getStatus() != SSLEngineResult.Status.CLOSED && sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW && sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (this.debugLogger != null) {
                this.debugLogger.debug("SSLHandler.renegotiateIfNeeded");
            }
            this.handshakeComplete = false;
            this.handshakeStatus = sSLEngineResult.getHandshakeStatus();
            this.handshake(nextFilter);
        }
    }

    private SSLEngineResult unwrap0() throws SSLException {
        SSLEngineResult sSLEngineResult;
        do {
            if (this.debugLogger != null) {
                this.debugLogger.debug("SSLHandler.unwrap0: inNetBuffer:" + this.inNetBuffer.limit() + " appBuffer:" + this.appBuffer.limit());
            }
            sSLEngineResult = this.sslEngine.unwrap(this.inNetBuffer, this.appBuffer);
            if (this.debugLogger == null) continue;
            this.debugLogger.debug("SSLHandler.unwrap0: Unwrap res:" + sSLEngineResult);
        } while (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK && (this.handshakeComplete && sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP));
        return sSLEngineResult;
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        if (this.debugLogger != null) {
            this.debugLogger.debug("SSLHandler.doTasks()");
        }
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            if (this.debugLogger != null) {
                this.debugLogger.debug("SSLHandler.doTasks: " + runnable);
            }
            runnable.run();
        }
        if (this.debugLogger != null) {
            this.debugLogger.debug("SSLHandler.doTasks: " + this.sslEngine.getHandshakeStatus());
        }
        return this.sslEngine.getHandshakeStatus();
    }

    public static ByteBuffer copy(java.nio.ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining(), false);
        byteBuffer2.put(byteBuffer);
        byteBuffer2.flip();
        return byteBuffer2;
    }

    public int getPacketBufferSize() {
        return this.packetBufferSize;
    }

    private static class Event {
        private final EventType type;
        private final IoFilter.NextFilter nextFilter;
        private final Object data;

        Event(EventType eventType, IoFilter.NextFilter nextFilter, Object object) {
            this.type = eventType;
            this.nextFilter = nextFilter;
            this.data = object;
        }

        public Object getData() {
            return this.data;
        }

        public IoFilter.NextFilter getNextFilter() {
            return this.nextFilter;
        }

        public EventType getType() {
            return this.type;
        }
    }

    private static class EventType {
        public static final EventType RECEIVED = new EventType("RECEIVED");
        public static final EventType FILTER_WRITE = new EventType("FILTER_WRITE");
        private final String value;

        private EventType(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }
}

