/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.support;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import org.apache.mina.filter.support.SSLCapabilities;
import org.apache.mina.filter.support.SSLSNIServerName;

public final class SSLExplorer {
    public static final int SNI_HOST_NAME = 0;
    public static final int RECORD_HEADER_SIZE = 5;

    private SSLExplorer() {
    }

    public static final int getRequiredSize(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        if (byteBuffer2.remaining() < 5) {
            throw new BufferUnderflowException();
        }
        byte by = byteBuffer2.get();
        byte by2 = byteBuffer2.get();
        byte by3 = byteBuffer2.get();
        if ((by & 0x80) != 0 && by3 == 1) {
            return 5;
        }
        return ((byteBuffer2.get() & 0xFF) << 8 | byteBuffer2.get() & 0xFF) + 5;
    }

    public static final int getRequiredSize(byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2).asReadOnlyBuffer();
        return SSLExplorer.getRequiredSize(byteBuffer);
    }

    public static final SSLCapabilities explore(ByteBuffer byteBuffer) throws IOException {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        if (byteBuffer2.remaining() < 5) {
            throw new BufferUnderflowException();
        }
        byte by = byteBuffer2.get();
        byte by2 = byteBuffer2.get();
        byte by3 = byteBuffer2.get();
        if ((by & 0x80) != 0 && by3 == 1) {
            return SSLExplorer.exploreV2HelloRecord(byteBuffer2, by, by2, by3);
        }
        if (by == 22) {
            return SSLExplorer.exploreTLSRecord(byteBuffer2, by, by2, by3);
        }
        throw new SSLException("Not handshake record");
    }

    public static final SSLCapabilities explore(byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2).asReadOnlyBuffer();
        return SSLExplorer.explore(byteBuffer);
    }

    private static SSLCapabilities exploreV2HelloRecord(ByteBuffer byteBuffer, byte by, byte by2, byte by3) throws IOException {
        try {
            if (by3 != 1) {
                throw new SSLException("Unsupported or Unrecognized SSL record");
            }
            byte by4 = byteBuffer.get();
            byte by5 = byteBuffer.get();
            return new SSLCapabilitiesImpl(0, 2, by4, by5, Collections.emptyList());
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new SSLProtocolException("Invalid handshake record");
        }
    }

    private static SSLCapabilities exploreTLSRecord(ByteBuffer byteBuffer, byte by, byte by2, byte by3) throws IOException {
        if (by != 22) {
            throw new SSLException("Not handshake record");
        }
        byte by4 = by2;
        byte by5 = by3;
        int n = SSLExplorer.getInt16(byteBuffer);
        if (n > byteBuffer.remaining()) {
            throw new BufferUnderflowException();
        }
        try {
            return SSLExplorer.exploreHandshake(byteBuffer, by4, by5, n);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new SSLProtocolException("Invalid handshake record");
        }
    }

    private static SSLCapabilities exploreHandshake(ByteBuffer byteBuffer, byte by, byte by2, int n) throws IOException {
        byte by3 = byteBuffer.get();
        if (by3 != 1) {
            throw new IllegalStateException("Not initial handshaking");
        }
        int n2 = SSLExplorer.getInt24(byteBuffer);
        if (n2 > n - 4) {
            throw new SSLException("Handshake message spans multiple records");
        }
        byteBuffer = byteBuffer.duplicate();
        byteBuffer.limit(n2 + byteBuffer.position());
        return SSLExplorer.exploreClientHello(byteBuffer, by, by2);
    }

    private static SSLCapabilities exploreClientHello(ByteBuffer byteBuffer, byte by, byte by2) throws IOException {
        List<SSLSNIServerName> list = Collections.emptyList();
        byte by3 = byteBuffer.get();
        byte by4 = byteBuffer.get();
        int n = byteBuffer.position();
        byteBuffer.position(n + 32);
        SSLExplorer.ignoreByteVector8(byteBuffer);
        SSLExplorer.ignoreByteVector16(byteBuffer);
        SSLExplorer.ignoreByteVector8(byteBuffer);
        if (byteBuffer.remaining() > 0) {
            list = SSLExplorer.exploreExtensions(byteBuffer);
        }
        return new SSLCapabilitiesImpl(by, by2, by3, by4, list);
    }

    private static List<SSLSNIServerName> exploreExtensions(ByteBuffer byteBuffer) throws IOException {
        int n;
        for (int i = SSLExplorer.getInt16(byteBuffer); i > 0; i -= n + 4) {
            int n2 = SSLExplorer.getInt16(byteBuffer);
            n = SSLExplorer.getInt16(byteBuffer);
            if (n2 == 0) {
                return SSLExplorer.exploreSNIExt(byteBuffer, n);
            }
            SSLExplorer.ignoreByteVector(byteBuffer, n);
        }
        return Collections.emptyList();
    }

    private static List<SSLSNIServerName> exploreSNIExt(ByteBuffer byteBuffer, int n) throws IOException {
        LinkedHashMap<Integer, SSLSNIServerName> linkedHashMap = new LinkedHashMap<Integer, SSLSNIServerName>();
        int n2 = n;
        if (n >= 2) {
            int n3 = SSLExplorer.getInt16(byteBuffer);
            if (n3 == 0 || n3 + 2 != n) {
                throw new SSLProtocolException("Invalid server name indication extension");
            }
            n2 -= 2;
            while (n2 > 0) {
                int n4 = SSLExplorer.getInt8(byteBuffer);
                int n5 = SSLExplorer.getInt16(byteBuffer);
                if (n5 > n2) {
                    throw new SSLProtocolException("Not enough data to fill declared vector size");
                }
                byte[] byArray = new byte[n5];
                byteBuffer.get(byArray);
                SSLSNIServerName sSLSNIServerName = switch (n4) {
                    case 0 -> {
                        if (byArray.length == 0) {
                            throw new SSLProtocolException("Empty HostName in server name indication");
                        }
                        yield new SSLSNIServerName(byArray);
                    }
                    default -> new UnknownServerName(n4, byArray);
                };
                if (linkedHashMap.put(sSLSNIServerName.getType(), sSLSNIServerName) != null) {
                    throw new SSLProtocolException("Duplicated server name of type " + sSLSNIServerName.getType());
                }
                n2 -= byArray.length + 3;
            }
        } else if (n == 0) {
            throw new SSLProtocolException("Not server name indication extension in client");
        }
        if (n2 != 0) {
            throw new SSLProtocolException("Invalid server name indication extension");
        }
        return Collections.unmodifiableList(new ArrayList(linkedHashMap.values()));
    }

    private static int getInt8(ByteBuffer byteBuffer) {
        return byteBuffer.get();
    }

    private static int getInt16(ByteBuffer byteBuffer) {
        return (byteBuffer.get() & 0xFF) << 8 | byteBuffer.get() & 0xFF;
    }

    private static int getInt24(ByteBuffer byteBuffer) {
        return (byteBuffer.get() & 0xFF) << 16 | (byteBuffer.get() & 0xFF) << 8 | byteBuffer.get() & 0xFF;
    }

    private static void ignoreByteVector8(ByteBuffer byteBuffer) {
        SSLExplorer.ignoreByteVector(byteBuffer, SSLExplorer.getInt8(byteBuffer));
    }

    private static void ignoreByteVector16(ByteBuffer byteBuffer) {
        SSLExplorer.ignoreByteVector(byteBuffer, SSLExplorer.getInt16(byteBuffer));
    }

    private static void ignoreByteVector24(ByteBuffer byteBuffer) {
        SSLExplorer.ignoreByteVector(byteBuffer, SSLExplorer.getInt24(byteBuffer));
    }

    private static void ignoreByteVector(ByteBuffer byteBuffer, int n) {
        if (n != 0) {
            int n2 = byteBuffer.position();
            byteBuffer.position(n2 + n);
        }
    }

    private static final class SSLCapabilitiesImpl
    extends SSLCapabilities {
        private static final Map<Integer, String> versionMap = new HashMap<Integer, String>(5);
        private final String recordVersion;
        private final String helloVersion;
        List<SSLSNIServerName> sniNames;

        SSLCapabilitiesImpl(byte by, byte by2, byte by3, byte by4, List<SSLSNIServerName> list) {
            int n = by << 8 | by2;
            this.recordVersion = versionMap.get(n) != null ? versionMap.get(n) : SSLCapabilitiesImpl.unknownVersion(by, by2);
            n = by3 << 8 | by4;
            this.helloVersion = versionMap.get(n) != null ? versionMap.get(n) : SSLCapabilitiesImpl.unknownVersion(by3, by4);
            this.sniNames = list;
        }

        @Override
        public String getRecordVersion() {
            return this.recordVersion;
        }

        @Override
        public String getHelloVersion() {
            return this.helloVersion;
        }

        @Override
        public List<SSLSNIServerName> getServerNames() {
            if (!this.sniNames.isEmpty()) {
                return Collections.unmodifiableList(this.sniNames);
            }
            return this.sniNames;
        }

        private static String unknownVersion(byte by, byte by2) {
            return "Unknown-" + by + "." + by2;
        }

        static {
            versionMap.put(2, "SSLv2Hello");
            versionMap.put(768, "SSLv3");
            versionMap.put(769, "TLSv1");
            versionMap.put(770, "TLSv1.1");
            versionMap.put(771, "TLSv1.2");
        }
    }

    private static class UnknownServerName
    extends SSLSNIServerName {
        UnknownServerName(int n, byte[] byArray) {
            super(n, byArray);
        }
    }
}

