/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.support;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;

public class SSLByteBufferSimple {
    private static int packetBufferSize = 0;
    private static int appBufferSize = 0;
    private static boolean initiated = false;

    static synchronized void initiate(SSLEngine sSLEngine) {
        if (!initiated) {
            packetBufferSize = sSLEngine.getSession().getPacketBufferSize();
            appBufferSize = packetBufferSize * 2;
            initiated = true;
        }
    }

    private static ByteBuffer createBuffer(int n) {
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = ByteBuffer.allocateDirect(n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.err.println("OutOfMemoryError: No more direct buffers available; trying heap buffer instead");
        }
        return byteBuffer;
    }

    static ByteBuffer getApplicationBuffer() {
        if (!initiated) {
            throw new IllegalStateException("Not initialized");
        }
        return SSLByteBufferSimple.createBuffer(appBufferSize);
    }

    static ByteBuffer getPacketBuffer() {
        if (!initiated) {
            throw new IllegalStateException("Not initialized");
        }
        return SSLByteBufferSimple.createBuffer(packetBufferSize);
    }

    static void release(ByteBuffer byteBuffer) {
    }

    public static ByteBuffer expandBuffer(ByteBuffer byteBuffer, int n) {
        ByteBuffer byteBuffer2 = SSLByteBufferSimple.createBuffer(n);
        byteBuffer.flip();
        byteBuffer2.put(byteBuffer);
        SSLByteBufferSimple.release(byteBuffer);
        return byteBuffer2;
    }
}

