/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.support;

import java.util.concurrent.ConcurrentLinkedDeque;
import javax.net.ssl.SSLEngine;
import org.apache.mina.common.ByteBuffer;

class SSLByteBufferPool {
    private static final int PACKET_BUFFER_INDEX = 0;
    private static final int APPLICATION_BUFFER_INDEX = 1;
    private static boolean initiated = false;
    private static final String DIRECT_MEMORY_PROP = "mina.sslfilter.directbuffer";
    private static boolean useDirectAllocatedBuffers = true;
    private static int packetBufferSize;
    private static int appBufferSize;
    private static int[] bufferStackSizes;
    private static final ConcurrentLinkedDeque<java.nio.ByteBuffer>[] bufferStacks;

    SSLByteBufferPool() {
    }

    static synchronized void initiate(SSLEngine sSLEngine) {
        if (!initiated) {
            String string = System.getProperty(DIRECT_MEMORY_PROP);
            if (string != null) {
                useDirectAllocatedBuffers = Boolean.getBoolean(DIRECT_MEMORY_PROP);
            }
            packetBufferSize = sSLEngine.getSession().getPacketBufferSize();
            appBufferSize = packetBufferSize * 2;
            SSLByteBufferPool.initiateBufferStacks();
            initiated = true;
        }
    }

    static java.nio.ByteBuffer getPacketBuffer() {
        if (!initiated) {
            throw new IllegalStateException("Not initialized");
        }
        return SSLByteBufferPool.allocate(0);
    }

    static java.nio.ByteBuffer getApplicationBuffer() {
        if (!initiated) {
            throw new IllegalStateException("Not initialized");
        }
        return SSLByteBufferPool.allocate(1);
    }

    private static java.nio.ByteBuffer allocate(int n) {
        java.nio.ByteBuffer byteBuffer = bufferStacks[n].pollLast();
        if (byteBuffer == null) {
            byteBuffer = SSLByteBufferPool.createBuffer(bufferStackSizes[n]);
        }
        byteBuffer.clear();
        return byteBuffer;
    }

    public static void release(java.nio.ByteBuffer byteBuffer) {
        ByteBuffer.wrap(byteBuffer).sweep().release();
        int n = SSLByteBufferPool.getBufferStackIndex(byteBuffer.capacity());
        if (n >= 0) {
            bufferStacks[n].addLast(byteBuffer);
        }
    }

    public static java.nio.ByteBuffer expandBuffer(java.nio.ByteBuffer byteBuffer, int n) {
        java.nio.ByteBuffer byteBuffer2 = SSLByteBufferPool.createBuffer(n);
        byteBuffer.flip();
        byteBuffer2.put(byteBuffer);
        SSLByteBufferPool.release(byteBuffer);
        return byteBuffer2;
    }

    private static void initiateBufferStacks() {
        bufferStackSizes = new int[2];
        SSLByteBufferPool.bufferStackSizes[0] = packetBufferSize;
        SSLByteBufferPool.bufferStackSizes[1] = appBufferSize;
    }

    private static int getBufferStackIndex(int n) {
        if (n == packetBufferSize) {
            return 0;
        }
        if (n == appBufferSize) {
            return 1;
        }
        return -1;
    }

    private static java.nio.ByteBuffer createBuffer(int n) {
        if (useDirectAllocatedBuffers) {
            try {
                return java.nio.ByteBuffer.allocateDirect(n);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                useDirectAllocatedBuffers = false;
                System.err.println("OutOfMemoryError: No more direct buffers available; trying heap buffer instead");
            }
        }
        return java.nio.ByteBuffer.allocate(n);
    }

    static {
        bufferStacks = new ConcurrentLinkedDeque[]{new ConcurrentLinkedDeque(), new ConcurrentLinkedDeque()};
    }
}

