/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.serialization;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.StreamCorruptedException;
import org.apache.mina.common.ByteBuffer;

public class ObjectSerializationInputStream
extends InputStream
implements ObjectInput {
    private final DataInputStream in;
    private final ClassLoader classLoader;
    private int maxObjectSize = 0x100000;

    public ObjectSerializationInputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    public ObjectSerializationInputStream(InputStream inputStream, ClassLoader classLoader) {
        if (inputStream == null) {
            throw new NullPointerException("in");
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.in = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        this.classLoader = classLoader;
    }

    public int getMaxObjectSize() {
        return this.maxObjectSize;
    }

    public void setMaxObjectSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxObjectSize: " + n);
        }
        this.maxObjectSize = n;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        int n = this.in.readInt();
        if (n <= 0) {
            throw new StreamCorruptedException("Invalid objectSize: " + n);
        }
        if (n > this.maxObjectSize) {
            throw new StreamCorruptedException("ObjectSize too big: " + n + " (expected: <= " + this.maxObjectSize + ')');
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n + 4, false);
        byteBuffer.putInt(n);
        this.in.readFully(byteBuffer.array(), 4, n);
        byteBuffer.position(0);
        byteBuffer.limit(n);
        Object object = byteBuffer.getObject(this.classLoader);
        byteBuffer.release();
        return object;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.in.readFully(byArray);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.in.readFully(byArray, n, n2);
    }

    @Override
    public int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.in.readShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.in.readUTF();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }
}

