/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.demux;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderException;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.demux.MessageDecoder;
import org.apache.mina.filter.codec.demux.MessageDecoderFactory;
import org.apache.mina.filter.codec.demux.MessageDecoderResult;
import org.apache.mina.filter.codec.demux.MessageEncoder;
import org.apache.mina.filter.codec.demux.MessageEncoderFactory;
import org.apache.mina.util.IdentityHashSet;

public class DemuxingProtocolCodecFactory
implements ProtocolCodecFactory {
    private MessageDecoderFactory[] decoderFactories = new MessageDecoderFactory[0];
    private MessageEncoderFactory[] encoderFactories = new MessageEncoderFactory[0];
    private static final Class[] EMPTY_PARAMS = new Class[0];

    public void register(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("encoderOrDecoderClass");
        }
        try {
            clazz.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("The specifiec class doesn't have a public default constructor.");
        }
        boolean bl = false;
        if (MessageEncoder.class.isAssignableFrom(clazz)) {
            this.register(new DefaultConstructorMessageEncoderFactory(clazz));
            bl = true;
        }
        if (MessageDecoder.class.isAssignableFrom(clazz)) {
            this.register(new DefaultConstructorMessageDecoderFactory(clazz));
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("Unregisterable type: " + clazz);
        }
    }

    public void register(MessageEncoder messageEncoder) {
        this.register(new SingletonMessageEncoderFactory(messageEncoder));
    }

    public void register(MessageEncoderFactory messageEncoderFactory) {
        if (messageEncoderFactory == null) {
            throw new NullPointerException("factory");
        }
        MessageEncoderFactory[] messageEncoderFactoryArray = this.encoderFactories;
        MessageEncoderFactory[] messageEncoderFactoryArray2 = new MessageEncoderFactory[messageEncoderFactoryArray.length + 1];
        System.arraycopy(messageEncoderFactoryArray, 0, messageEncoderFactoryArray2, 0, messageEncoderFactoryArray.length);
        messageEncoderFactoryArray2[messageEncoderFactoryArray.length] = messageEncoderFactory;
        this.encoderFactories = messageEncoderFactoryArray2;
    }

    public void register(MessageDecoder messageDecoder) {
        this.register(new SingletonMessageDecoderFactory(messageDecoder));
    }

    public void register(MessageDecoderFactory messageDecoderFactory) {
        if (messageDecoderFactory == null) {
            throw new NullPointerException("factory");
        }
        MessageDecoderFactory[] messageDecoderFactoryArray = this.decoderFactories;
        MessageDecoderFactory[] messageDecoderFactoryArray2 = new MessageDecoderFactory[messageDecoderFactoryArray.length + 1];
        System.arraycopy(messageDecoderFactoryArray, 0, messageDecoderFactoryArray2, 0, messageDecoderFactoryArray.length);
        messageDecoderFactoryArray2[messageDecoderFactoryArray.length] = messageDecoderFactory;
        this.decoderFactories = messageDecoderFactoryArray2;
    }

    @Override
    public ProtocolEncoder getEncoder() throws Exception {
        return new ProtocolEncoderImpl();
    }

    @Override
    public ProtocolDecoder getDecoder() throws Exception {
        return new ProtocolDecoderImpl();
    }

    protected void disposeCodecResources(IoSession ioSession) {
        ioSession.getTransportType();
    }

    private static class DefaultConstructorMessageEncoderFactory
    implements MessageEncoderFactory {
        private final Class encoderClass;

        private DefaultConstructorMessageEncoderFactory(Class clazz) {
            if (clazz == null) {
                throw new NullPointerException("encoderClass");
            }
            if (!MessageEncoder.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("encoderClass is not assignable to MessageEncoder");
            }
            this.encoderClass = clazz;
        }

        @Override
        public MessageEncoder getEncoder() throws Exception {
            return (MessageEncoder)this.encoderClass.newInstance();
        }
    }

    private static class DefaultConstructorMessageDecoderFactory
    implements MessageDecoderFactory {
        private final Class decoderClass;

        private DefaultConstructorMessageDecoderFactory(Class clazz) {
            if (clazz == null) {
                throw new NullPointerException("decoderClass");
            }
            if (!MessageDecoder.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("decoderClass is not assignable to MessageDecoder");
            }
            this.decoderClass = clazz;
        }

        @Override
        public MessageDecoder getDecoder() throws Exception {
            return (MessageDecoder)this.decoderClass.newInstance();
        }
    }

    private static class SingletonMessageEncoderFactory
    implements MessageEncoderFactory {
        private final MessageEncoder encoder;

        private SingletonMessageEncoderFactory(MessageEncoder messageEncoder) {
            if (messageEncoder == null) {
                throw new NullPointerException("encoder");
            }
            this.encoder = messageEncoder;
        }

        @Override
        public MessageEncoder getEncoder() {
            return this.encoder;
        }
    }

    private static class SingletonMessageDecoderFactory
    implements MessageDecoderFactory {
        private final MessageDecoder decoder;

        private SingletonMessageDecoderFactory(MessageDecoder messageDecoder) {
            if (messageDecoder == null) {
                throw new NullPointerException("decoder");
            }
            this.decoder = messageDecoder;
        }

        @Override
        public MessageDecoder getDecoder() {
            return this.decoder;
        }
    }

    private class ProtocolEncoderImpl
    implements ProtocolEncoder {
        private final Map encoders = new IdentityHashMap();

        private ProtocolEncoderImpl() throws Exception {
            MessageEncoderFactory[] messageEncoderFactoryArray = DemuxingProtocolCodecFactory.this.encoderFactories;
            for (int i = messageEncoderFactoryArray.length - 1; i >= 0; --i) {
                MessageEncoder messageEncoder = messageEncoderFactoryArray[i].getEncoder();
                for (Class clazz : messageEncoder.getMessageTypes()) {
                    this.encoders.put(clazz, messageEncoder);
                }
            }
        }

        @Override
        public void encode(IoSession ioSession, Object object, ProtocolEncoderOutput protocolEncoderOutput) throws Exception {
            Class<?> clazz = object.getClass();
            MessageEncoder messageEncoder = this.findEncoder(clazz);
            if (messageEncoder == null) {
                throw new ProtocolEncoderException("Unexpected message type: " + clazz);
            }
            messageEncoder.encode(ioSession, object, protocolEncoderOutput);
        }

        private MessageEncoder findEncoder(Class clazz) {
            MessageEncoder messageEncoder = (MessageEncoder)this.encoders.get(clazz);
            if (messageEncoder == null) {
                messageEncoder = this.findEncoder(clazz, new IdentityHashSet());
            }
            return messageEncoder;
        }

        private MessageEncoder findEncoder(Class clazz, Set set) {
            if (set.contains(clazz)) {
                return null;
            }
            set.add(clazz);
            MessageEncoder messageEncoder = (MessageEncoder)this.encoders.get(clazz);
            if (messageEncoder == null) {
                messageEncoder = this.findEncoder(clazz, set);
                if (messageEncoder != null) {
                    return messageEncoder;
                }
                Class<?>[] classArray = clazz.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    messageEncoder = this.findEncoder(classArray[i], set);
                    if (messageEncoder == null) continue;
                    return messageEncoder;
                }
                return null;
            }
            return messageEncoder;
        }

        @Override
        public void dispose(IoSession ioSession) throws Exception {
            DemuxingProtocolCodecFactory.this.disposeCodecResources(ioSession);
        }
    }

    private class ProtocolDecoderImpl
    extends CumulativeProtocolDecoder {
        private final MessageDecoder[] decoders;
        private MessageDecoder currentDecoder;

        protected ProtocolDecoderImpl() throws Exception {
            MessageDecoderFactory[] messageDecoderFactoryArray = DemuxingProtocolCodecFactory.this.decoderFactories;
            this.decoders = new MessageDecoder[messageDecoderFactoryArray.length];
            for (int i = messageDecoderFactoryArray.length - 1; i >= 0; --i) {
                this.decoders[i] = messageDecoderFactoryArray[i].getDecoder();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean doDecode(IoSession ioSession, ByteBuffer byteBuffer, ProtocolDecoderOutput protocolDecoderOutput) throws Exception {
            Object object;
            if (this.currentDecoder == null) {
                object = this.decoders;
                int n = 0;
                for (int i = ((MessageDecoder[])object).length - 1; i >= 0; --i) {
                    MessageDecoderResult messageDecoderResult;
                    MessageDecoder messageDecoder = object[i];
                    int n2 = byteBuffer.limit();
                    int n3 = byteBuffer.position();
                    try {
                        messageDecoderResult = messageDecoder.decodable(ioSession, byteBuffer);
                    }
                    finally {
                        byteBuffer.position(n3);
                        byteBuffer.limit(n2);
                    }
                    if (messageDecoderResult == MessageDecoder.OK) {
                        this.currentDecoder = messageDecoder;
                        break;
                    }
                    if (messageDecoderResult == MessageDecoder.NOT_OK) {
                        ++n;
                        continue;
                    }
                    if (messageDecoderResult == MessageDecoder.NEED_DATA) continue;
                    throw new IllegalStateException("Unexpected decode result (see your decodable()): " + messageDecoderResult);
                }
                if (n == ((MessageDecoder[])object).length) {
                    String string = byteBuffer.getHexDump();
                    byteBuffer.position(byteBuffer.limit());
                    throw new ProtocolDecoderException("No appropriate message decoder: " + string);
                }
                if (this.currentDecoder == null) {
                    return false;
                }
            }
            if ((object = this.currentDecoder.decode(ioSession, byteBuffer, protocolDecoderOutput)) == MessageDecoder.OK) {
                this.currentDecoder = null;
                return true;
            }
            if (object == MessageDecoder.NEED_DATA) {
                return false;
            }
            if (object == MessageDecoder.NOT_OK) {
                throw new ProtocolDecoderException("Message decoder returned NOT_OK.");
            }
            throw new IllegalStateException("Unexpected decode result (see your decode()): " + (MessageDecoderResult)object);
        }

        @Override
        public void finishDecode(IoSession ioSession, ProtocolDecoderOutput protocolDecoderOutput) throws Exception {
            if (this.currentDecoder == null) {
                return;
            }
            this.currentDecoder.finishDecode(ioSession, protocolDecoderOutput);
        }

        @Override
        public void dispose(IoSession ioSession) throws Exception {
            super.dispose(ioSession);
        }
    }
}

