/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter;

import java.io.IOException;
import java.io.InputStream;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.util.Queue;

public class StreamWriteFilter
extends IoFilterAdapter {
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 4096;
    public static final String CURRENT_STREAM = StreamWriteFilter.class.getName() + ".stream";
    protected static final String WRITE_REQUEST_QUEUE = StreamWriteFilter.class.getName() + ".queue";
    protected static final String INITIAL_WRITE_FUTURE = StreamWriteFilter.class.getName() + ".future";
    private int writeBufferSize = 4096;

    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession ioSession, IoFilter.WriteRequest writeRequest) throws Exception {
        if (ioSession.getAttribute(CURRENT_STREAM) != null) {
            Queue queue = (Queue)ioSession.getAttribute(WRITE_REQUEST_QUEUE);
            if (queue == null) {
                queue = new Queue();
                ioSession.setAttribute(WRITE_REQUEST_QUEUE, queue);
            }
            queue.push(writeRequest);
            return;
        }
        Object object = writeRequest.getMessage();
        if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            ByteBuffer byteBuffer = this.getNextByteBuffer(inputStream);
            if (byteBuffer == null) {
                writeRequest.getFuture().setWritten(true);
                nextFilter.messageSent(ioSession, object);
            } else {
                ioSession.setAttribute(CURRENT_STREAM, inputStream);
                ioSession.setAttribute(INITIAL_WRITE_FUTURE, writeRequest.getFuture());
                nextFilter.filterWrite(ioSession, new IoFilter.WriteRequest(byteBuffer));
            }
        } else {
            nextFilter.filterWrite(ioSession, writeRequest);
        }
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws Exception {
        InputStream inputStream = (InputStream)ioSession.getAttribute(CURRENT_STREAM);
        if (inputStream == null) {
            nextFilter.messageSent(ioSession, object);
        } else {
            ByteBuffer byteBuffer = this.getNextByteBuffer(inputStream);
            if (byteBuffer == null) {
                ioSession.removeAttribute(CURRENT_STREAM);
                WriteFuture writeFuture = (WriteFuture)ioSession.removeAttribute(INITIAL_WRITE_FUTURE);
                Queue queue = (Queue)ioSession.removeAttribute(WRITE_REQUEST_QUEUE);
                if (queue != null) {
                    IoFilter.WriteRequest writeRequest = (IoFilter.WriteRequest)queue.pop();
                    while (writeRequest != null) {
                        this.filterWrite(nextFilter, ioSession, writeRequest);
                        writeRequest = (IoFilter.WriteRequest)queue.pop();
                    }
                }
                writeFuture.setWritten(true);
                nextFilter.messageSent(ioSession, inputStream);
            } else {
                nextFilter.filterWrite(ioSession, new IoFilter.WriteRequest(byteBuffer));
            }
        }
    }

    private ByteBuffer getNextByteBuffer(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[this.writeBufferSize];
        int n2 = 0;
        for (n = 0; n < byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) != -1; n += n2) {
        }
        if (n2 == -1 && n == 0) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n);
        return byteBuffer;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("writeBufferSize must be at least 1");
        }
        this.writeBufferSize = n;
    }
}

