/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter;

import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.vhost.IVHost;
import java.util.Iterator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferProxy;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.DefaultWriteFuture;
import org.apache.mina.filter.support.SSLHandler;
import org.apache.mina.transport.socket.nio.FastMinaMessage;
import org.apache.mina.util.SessionLog;

public class SSLFilter
extends IoFilterAdapter {
    private static final String CLASSNAME = "SSLFilter";
    private static final Class<SSLFilter> CLASS = SSLFilter.class;
    public static final String SSL_SESSION = SSLFilter.class.getName() + ".SSLSession";
    public static final String DISABLE_ENCRYPTION_ONCE = SSLFilter.class.getName() + ".DisableEncryptionOnce";
    public static final String USE_NOTIFICATION = SSLFilter.class.getName() + ".UseNotification";
    public static final SSLFilterMessage SESSION_SECURED = new SSLFilterMessage("SESSION_SECURED");
    public static final SSLFilterMessage SESSION_UNSECURED = new SSLFilterMessage("SESSION_UNSECURED");
    private static final String NEXT_FILTER = SSLFilter.class.getName() + ".NextFilter";
    private static final String SSL_HANDLER = SSLFilter.class.getName() + ".SSLHandler";
    private SSLContext sslContext;
    private boolean client;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;
    private boolean logConnectionInfo = false;
    private String domainToKeyStoreMapPathStr = null;
    private boolean allowHttp2 = false;
    private IVHost vhost = null;
    private WMSLogger debugLogger = null;

    public SSLFilter(SSLContext sSLContext) {
        this.initLogging();
        if (sSLContext == null) {
            throw new NullPointerException("sslContext");
        }
        this.sslContext = sSLContext;
    }

    public SSLFilter(IVHost iVHost, String string) {
        this.initLogging();
        this.vhost = iVHost;
        this.domainToKeyStoreMapPathStr = string;
    }

    private void initLogging() {
        this.debugLogger = WMSLoggerFactory.getLogger(CLASS);
        if (this.debugLogger == null || !this.debugLogger.isDebugEnabled()) {
            this.debugLogger = null;
        }
    }

    public SSLSession getSSLSession(IoSession ioSession) {
        return (SSLSession)ioSession.getAttribute(SSL_SESSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startSSL(IoSession ioSession) throws SSLException {
        SSLHandler sSLHandler = this.getSSLSessionHandler(ioSession);
        boolean bl = false;
        try {
            SSLHandler sSLHandler2 = sSLHandler;
            synchronized (sSLHandler2) {
                if (sSLHandler.isOutboundDone()) {
                    IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)ioSession.getAttribute(NEXT_FILTER);
                    sSLHandler.destroy();
                    sSLHandler.init();
                    sSLHandler.handshake(nextFilter);
                    bl = true;
                } else {
                    bl = false;
                }
                sSLHandler.flushFilterWrite();
            }
            sSLHandler.flushMessageReceived();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error("SSLFilter.startSSL: ", (Throwable)exception);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSSLStarted(IoSession ioSession) {
        SSLHandler sSLHandler = this.getSSLSessionHandler0(ioSession);
        if (sSLHandler == null) {
            return false;
        }
        SSLHandler sSLHandler2 = sSLHandler;
        synchronized (sSLHandler2) {
            return !sSLHandler.isOutboundDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHandshakeComplete(IoSession ioSession) {
        SSLHandler sSLHandler = this.getSSLSessionHandler0(ioSession);
        if (sSLHandler == null) {
            return false;
        }
        SSLHandler sSLHandler2 = sSLHandler;
        synchronized (sSLHandler2) {
            return sSLHandler.isHandshakeComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture stopSSL(IoSession ioSession) throws SSLException {
        SSLHandler sSLHandler = this.getSSLSessionHandler(ioSession);
        IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)ioSession.getAttribute(NEXT_FILTER);
        WriteFuture writeFuture = null;
        try {
            SSLHandler sSLHandler2 = sSLHandler;
            synchronized (sSLHandler2) {
                writeFuture = this.initiateClosure(nextFilter, ioSession);
                sSLHandler.flushFilterWrite();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error("SSLFilter.stopSSL: ", (Throwable)exception);
        }
        return writeFuture;
    }

    public boolean isUseClientMode() {
        return this.client;
    }

    public void setUseClientMode(boolean bl) {
        this.client = bl;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean bl) {
        this.wantClientAuth = bl;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = stringArray;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.enabledProtocols = stringArray;
    }

    @Override
    public void onPreAdd(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws SSLException {
        if (ioFilterChain.contains(SSLFilter.class)) {
            throw new IllegalStateException("A filter chain cannot contain more than one SSLFilter.");
        }
        IoSession ioSession = ioFilterChain.getSession();
        ioSession.setAttribute(NEXT_FILTER, nextFilter);
        SSLHandler sSLHandler = new SSLHandler(this, this.sslContext, ioSession, this.vhost, this.domainToKeyStoreMapPathStr);
        ioSession.setAttribute(SSL_HANDLER, sSLHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPostAdd(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws SSLException {
        SSLHandler sSLHandler;
        SSLHandler sSLHandler2 = sSLHandler = this.getSSLSessionHandler(ioFilterChain.getSession());
        synchronized (sSLHandler2) {
            sSLHandler.handshake(nextFilter);
            sSLHandler.flushFilterWrite();
        }
        sSLHandler.flushMessageReceived();
    }

    @Override
    public void onPreRemove(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws SSLException {
        IoSession ioSession = ioFilterChain.getSession();
        this.stopSSL(ioSession);
        ioSession.removeAttribute(NEXT_FILTER);
        ioSession.removeAttribute(SSL_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession ioSession) throws SSLException {
        SSLHandler sSLHandler = this.getSSLSessionHandler(ioSession);
        try {
            SSLHandler sSLHandler2 = sSLHandler;
            synchronized (sSLHandler2) {
                if (this.isSSLStarted(ioSession) && this.debugLogger != null) {
                    this.debugLogger.debug("SSLFilter.sessionClosed: Closed: " + this.getSSLSessionHandler(ioSession));
                }
                sSLHandler.destroy();
            }
        }
        finally {
            nextFilter.sessionClosed(ioSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws SSLException {
        SSLHandler sSLHandler;
        SSLHandler sSLHandler2 = sSLHandler = this.getSSLSessionHandler(ioSession);
        synchronized (sSLHandler2) {
            ByteBuffer byteBuffer;
            if (sSLHandler.doSNI()) {
                byteBuffer = (ByteBuffer)object;
                java.nio.ByteBuffer byteBuffer2 = null;
                try {
                    if (byteBuffer != null) {
                        byteBuffer2 = sSLHandler.handleSNI(byteBuffer.buf());
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(CLASS).error("SSLFilter.messageReceived[handleSNI]: ", (Throwable)exception);
                }
                if (byteBuffer2 == null) {
                    return;
                }
                object = ByteBuffer.wrap(byteBuffer2);
            }
            if (!this.isSSLStarted(ioSession) && sSLHandler.isInboundDone()) {
                sSLHandler.scheduleMessageReceived(nextFilter, object);
            } else {
                byteBuffer = (ByteBuffer)object;
                if (this.debugLogger != null) {
                    this.debugLogger.debug("SSLFilter.messageReceived: Data Read: " + sSLHandler + " (" + SessionLog.logBuffer(byteBuffer) + ')');
                }
                try {
                    sSLHandler.messageReceived(nextFilter, byteBuffer.buf());
                    this.handleSSLData(nextFilter, sSLHandler);
                    if (sSLHandler.isInboundDone()) {
                        if (sSLHandler.isOutboundDone()) {
                            if (this.debugLogger != null) {
                                this.debugLogger.debug("SSLFilter.messageReceived: SSL Session closed.");
                            }
                            sSLHandler.destroy();
                        } else {
                            this.initiateClosure(nextFilter, ioSession);
                        }
                        if (byteBuffer.hasRemaining()) {
                            sSLHandler.scheduleMessageReceived(nextFilter, byteBuffer);
                        }
                    }
                }
                catch (SSLException sSLException) {
                    SSLHandshakeException sSLHandshakeException;
                    if (!sSLHandler.isHandshakeComplete()) {
                        SSLHandshakeException sSLHandshakeException2 = new SSLHandshakeException("SSL handshake failed.");
                        sSLHandshakeException2.initCause(sSLException);
                        sSLHandshakeException = sSLHandshakeException2;
                    }
                    throw sSLHandshakeException;
                }
            }
        }
        sSLHandler.flushMessageReceived();
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) {
        if (object instanceof EncryptedBuffer) {
            EncryptedBuffer encryptedBuffer = (EncryptedBuffer)object;
            encryptedBuffer.release();
            nextFilter.messageSent(ioSession, encryptedBuffer.originalBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession ioSession, IoFilter.WriteRequest writeRequest) throws SSLException {
        SSLHandler sSLHandler;
        boolean bl = true;
        SSLHandler sSLHandler2 = sSLHandler = this.getSSLSessionHandler(ioSession);
        synchronized (sSLHandler2) {
            if (!this.isSSLStarted(ioSession)) {
                sSLHandler.scheduleFilterWrite(nextFilter, writeRequest);
            } else if (ioSession.containsAttribute(DISABLE_ENCRYPTION_ONCE)) {
                ioSession.removeAttribute(DISABLE_ENCRYPTION_ONCE);
                sSLHandler.scheduleFilterWrite(nextFilter, writeRequest);
            } else {
                ByteBuffer byteBuffer = (ByteBuffer)writeRequest.getMessage();
                if (this.debugLogger != null) {
                    this.debugLogger.debug("SSLFilter.filterWrite: Filtered Write: " + sSLHandler);
                }
                if (sSLHandler.isWritingEncryptedData()) {
                    if (this.debugLogger != null) {
                        this.debugLogger.debug("SSLFilter.filterWrite: already encrypted: " + SessionLog.logBuffer(byteBuffer));
                    }
                    sSLHandler.scheduleFilterWrite(nextFilter, writeRequest);
                } else if (sSLHandler.isHandshakeComplete()) {
                    ByteBuffer byteBuffer2;
                    Object object;
                    FastMinaMessage fastMinaMessage;
                    int n;
                    if (this.debugLogger != null) {
                        this.debugLogger.debug("SSLFilter.filterWrite: encrypt: " + SessionLog.logBuffer(byteBuffer));
                    }
                    if ((n = sSLHandler.getPacketBufferSize()) <= 0) {
                        n = 32768;
                    }
                    int n2 = (fastMinaMessage = (FastMinaMessage)byteBuffer.getExtra()) != null ? fastMinaMessage.getSize() : byteBuffer.remaining();
                    int n3 = n2 / n + 2;
                    int n4 = n3 * (n + 128);
                    ByteBuffer byteBuffer3 = ByteBuffer.allocate(n4, false);
                    java.nio.ByteBuffer[] byteBufferArray = null;
                    if (fastMinaMessage != null) {
                        object = fastMinaMessage.getBufferList();
                        byteBufferArray = new java.nio.ByteBuffer[object.size()];
                        int n5 = 0;
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            byteBuffer2 = (ByteBuffer)iterator.next();
                            byteBufferArray[n5++] = byteBuffer2.buf();
                        }
                    } else {
                        byteBufferArray = new java.nio.ByteBuffer[]{byteBuffer.buf()};
                    }
                    try {
                        sSLHandler.encrypt(byteBufferArray, byteBuffer3);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(CLASS).error("SSLFilter.filterWrite: ", (Throwable)exception);
                    }
                    object = new EncryptedBuffer(byteBuffer3, byteBuffer);
                    if (this.debugLogger != null) {
                        this.debugLogger.debug("SSLFilter.filterWrite: encrypted buf: " + SessionLog.logBuffer((ByteBuffer)object));
                    }
                    long l = -1L;
                    byteBuffer2 = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
                    if (byteBuffer2 != null && byteBuffer2.getProtocol() == 1) {
                        l = ioSession.getAndIncrementSSLWriteSequence();
                    }
                    sSLHandler.scheduleFilterWrite(nextFilter, new IoFilter.WriteRequest(object, writeRequest.getFuture(), l));
                } else {
                    if (!ioSession.isConnected()) {
                        if (this.debugLogger != null) {
                            this.debugLogger.debug("SSLFilter.filterWrite: Write request on closed session.");
                        }
                    } else {
                        if (this.debugLogger != null) {
                            this.debugLogger.debug("SSLFilter.filterWrite: Handshaking is not complete yet. Buffering write request.");
                        }
                        sSLHandler.schedulePreHandshakeWriteRequest(nextFilter, writeRequest);
                    }
                    bl = false;
                }
            }
        }
        if (bl) {
            sSLHandler.flushFilterWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filterClose(final IoFilter.NextFilter nextFilter, final IoSession ioSession) throws SSLException {
        SSLHandler sSLHandler = this.getSSLSessionHandler0(ioSession);
        if (sSLHandler == null) {
            nextFilter.filterClose(ioSession);
            return;
        }
        WriteFuture writeFuture = null;
        try {
            SSLHandler sSLHandler2 = sSLHandler;
            synchronized (sSLHandler2) {
                if (this.isSSLStarted(ioSession)) {
                    writeFuture = this.initiateClosure(nextFilter, ioSession);
                    writeFuture.addListener(new IoFutureListener(){

                        @Override
                        public void operationComplete(IoFuture ioFuture) {
                            nextFilter.filterClose(ioSession);
                        }
                    });
                }
                sSLHandler.flushFilterWrite();
            }
        }
        finally {
            if (writeFuture == null) {
                nextFilter.filterClose(ioSession);
            }
        }
    }

    private WriteFuture initiateClosure(IoFilter.NextFilter nextFilter, IoSession ioSession) throws SSLException {
        SSLHandler sSLHandler = this.getSSLSessionHandler(ioSession);
        if (!sSLHandler.closeOutbound()) {
            return DefaultWriteFuture.newNotWrittenFuture(ioSession);
        }
        WriteFuture writeFuture = sSLHandler.writeNetBuffer(nextFilter);
        if (sSLHandler.isInboundDone()) {
            sSLHandler.destroy();
        }
        if (ioSession.containsAttribute(USE_NOTIFICATION)) {
            sSLHandler.scheduleMessageReceived(nextFilter, SESSION_UNSECURED);
        }
        return writeFuture;
    }

    private void handleSSLData(IoFilter.NextFilter nextFilter, SSLHandler sSLHandler) throws SSLException {
        if (sSLHandler.isHandshakeComplete()) {
            sSLHandler.flushPreHandshakeEvents();
        }
        sSLHandler.writeNetBuffer(nextFilter);
        this.handleAppDataRead(nextFilter, sSLHandler);
    }

    private void handleAppDataRead(IoFilter.NextFilter nextFilter, SSLHandler sSLHandler) {
        IoSession ioSession = sSLHandler.getSession();
        sSLHandler.getAppBuffer().flip();
        if (!sSLHandler.getAppBuffer().hasRemaining()) {
            sSLHandler.getAppBuffer().clear();
            return;
        }
        if (this.debugLogger != null) {
            this.debugLogger.debug("SSLFilter.handleAppDataRead: appBuffer: " + SessionLog.logBuffer(sSLHandler.getAppBuffer()));
        }
        ByteBuffer byteBuffer = SSLHandler.copy(sSLHandler.getAppBuffer());
        sSLHandler.getAppBuffer().clear();
        if (this.debugLogger != null) {
            this.debugLogger.debug("SSLFilter.handleAppDataRead: app data read: " + SessionLog.logBuffer(byteBuffer));
        }
        sSLHandler.scheduleMessageReceived(nextFilter, byteBuffer);
    }

    private SSLHandler getSSLSessionHandler(IoSession ioSession) {
        SSLHandler sSLHandler = this.getSSLSessionHandler0(ioSession);
        if (sSLHandler == null) {
            throw new IllegalStateException();
        }
        if (sSLHandler.getParent() != this) {
            throw new IllegalArgumentException("Not managed by this filter.");
        }
        return sSLHandler;
    }

    private SSLHandler getSSLSessionHandler0(IoSession ioSession) {
        return (SSLHandler)ioSession.getAttribute(SSL_HANDLER);
    }

    public boolean isLogConnectionInfo() {
        return this.logConnectionInfo;
    }

    public void setLogConnectionInfo(boolean bl) {
        this.logConnectionInfo = bl;
    }

    public boolean doesAllowHttp2() {
        return this.allowHttp2;
    }

    public void allowHttp2() {
        this.allowHttp2 = true;
    }

    private static class EncryptedBuffer
    extends ByteBufferProxy {
        private final ByteBuffer originalBuffer;

        private EncryptedBuffer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            super(byteBuffer);
            this.originalBuffer = byteBuffer2;
        }
    }

    public static class SSLFilterMessage {
        private final String name;

        private SSLFilterMessage(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

