/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter;

import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.SessionLog;

public class LoggingFilter
extends IoFilterAdapter {
    public static final String PREFIX = SessionLog.PREFIX;
    public static final String LOGGER = SessionLog.LOGGER;

    @Override
    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession ioSession) {
        nextFilter.sessionCreated(ioSession);
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession ioSession) {
        SessionLog.info(ioSession, "OPENED");
        nextFilter.sessionOpened(ioSession);
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession ioSession) {
        SessionLog.info(ioSession, "CLOSED");
        nextFilter.sessionClosed(ioSession);
    }

    @Override
    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession ioSession, IdleStatus idleStatus) {
        if (SessionLog.isInfoEnabled(ioSession)) {
            SessionLog.info(ioSession, "IDLE: " + idleStatus);
        }
        nextFilter.sessionIdle(ioSession, idleStatus);
    }

    @Override
    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession ioSession, Throwable throwable) {
        if (SessionLog.isInfoEnabled(ioSession)) {
            SessionLog.info(ioSession, "EXCEPTION:", throwable);
        }
        nextFilter.exceptionCaught(ioSession, throwable);
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) {
        if (SessionLog.isInfoEnabled(ioSession)) {
            SessionLog.info(ioSession, "RECEIVED: " + object);
        }
        nextFilter.messageReceived(ioSession, object);
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) {
        if (SessionLog.isInfoEnabled(ioSession)) {
            SessionLog.info(ioSession, "SENT: " + object);
        }
        nextFilter.messageSent(ioSession, object);
    }

    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession ioSession, IoFilter.WriteRequest writeRequest) {
        if (SessionLog.isInfoEnabled(ioSession)) {
            SessionLog.info(ioSession, "WRITE: " + writeRequest);
        }
        nextFilter.filterWrite(ioSession, writeRequest);
    }

    @Override
    public void filterClose(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
        SessionLog.info(ioSession, "CLOSE");
        nextFilter.filterClose(ioSession);
    }
}

