/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.TrafficMask;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.DefaultCloseFuture;
import org.apache.mina.common.support.DefaultWriteFuture;
import org.apache.mina.common.support.IWriteListener;
import org.apache.mina.http2.api.Http2Connection;

public abstract class BaseIoSession
implements IoSession {
    private final Map attributes = new HashMap();
    private final long creationTime;
    private final CloseFuture closeFuture = new DefaultCloseFuture(this);
    private boolean closing;
    private long idleTimeForRead;
    private long idleTimeForWrite;
    private long idleTimeForBoth;
    private int writeTimeout;
    private TrafficMask trafficMask = TrafficMask.ALL;
    private long readBytes;
    private long writtenBytes;
    private long writtenWriteRequests;
    private long readMessages;
    private long writtenMessages;
    private long lastReadTime;
    private long lastWriteTime;
    private int idleCountForBoth;
    private int idleCountForRead;
    private int idleCountForWrite;
    private long lastIdleTimeForBoth;
    private long lastIdleTimeForRead;
    private long lastIdleTimeForWrite;
    private List writeListeners = new ArrayList();
    private int inQueue = 0;
    private Object inQueueLock = new Object();
    private AtomicLong writeSequence = new AtomicLong();
    private AtomicLong sslWriteSequence = new AtomicLong();
    private AtomicLong messageBytesWaiting = new AtomicLong();
    private final AtomicBoolean scheduledForFlush = new AtomicBoolean();

    protected BaseIoSession() {
        this.lastIdleTimeForRead = this.lastIdleTimeForWrite = System.currentTimeMillis();
        this.lastIdleTimeForBoth = this.lastIdleTimeForWrite;
        this.lastWriteTime = this.lastIdleTimeForWrite;
        this.lastReadTime = this.lastIdleTimeForWrite;
        this.creationTime = this.lastIdleTimeForWrite;
    }

    @Override
    public boolean isScheduledForFlush() {
        return this.scheduledForFlush.get();
    }

    @Override
    public boolean setScheduledForFlush(boolean bl) {
        if (bl) {
            return this.scheduledForFlush.compareAndSet(false, true);
        }
        this.scheduledForFlush.set(false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWriteListeners() {
        List list = this.writeListeners;
        synchronized (list) {
            this.writeListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWriteListener(IWriteListener iWriteListener) {
        List list = this.writeListeners;
        synchronized (list) {
            if (!this.writeListeners.contains(iWriteListener)) {
                this.writeListeners.add(iWriteListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsWriteListener(IWriteListener iWriteListener) {
        List list = this.writeListeners;
        synchronized (list) {
            return this.writeListeners.contains(iWriteListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWriteListener(IWriteListener iWriteListener) {
        List list = this.writeListeners;
        synchronized (list) {
            this.writeListeners.remove(iWriteListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyQueWriteRequest(IoFilter.WriteRequest writeRequest) {
        List list = this.writeListeners;
        synchronized (list) {
            for (IWriteListener iWriteListener : this.writeListeners) {
                iWriteListener.onQueWriteRequest(writeRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWriteWriteRequest(IoFilter.WriteRequest writeRequest, long l) {
        List list = this.writeListeners;
        synchronized (list) {
            for (IWriteListener iWriteListener : this.writeListeners) {
                iWriteListener.onWriteWriteRequest(writeRequest, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCompleteWriteRequest(IoFilter.WriteRequest writeRequest) {
        List list = this.writeListeners;
        synchronized (list) {
            for (IWriteListener iWriteListener : this.writeListeners) {
                iWriteListener.onCompleteWriteRequest(writeRequest);
            }
        }
    }

    @Override
    public boolean isConnected() {
        return !this.closeFuture.isClosed();
    }

    @Override
    public synchronized boolean isClosing() {
        return this.closing || this.closeFuture.isClosed();
    }

    @Override
    public CloseFuture getCloseFuture() {
        return this.closeFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseFuture close() {
        BaseIoSession baseIoSession = this;
        synchronized (baseIoSession) {
            if (this.isClosing()) {
                return this.closeFuture;
            }
            Http2Connection http2Connection = (Http2Connection)this.getAttribute("connection");
            if (http2Connection != null) {
                http2Connection.close();
            }
            this.closing = true;
        }
        this.close0();
        return this.closeFuture;
    }

    protected void close0() {
        this.closeFuture.setClosed();
    }

    @Override
    public WriteFuture write(Object object) {
        return this.write(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture write(Object object, SocketAddress socketAddress) {
        Object object2 = this;
        synchronized (object2) {
            if (this.isClosing() || !this.isConnected()) {
                return DefaultWriteFuture.newNotWrittenFuture(this);
            }
        }
        object2 = new DefaultWriteFuture(this);
        IoFilter.WriteRequest writeRequest = new IoFilter.WriteRequest(object, (WriteFuture)object2, socketAddress, this.writeSequence.getAndIncrement());
        this.notifyQueWriteRequest(writeRequest);
        this.write0(writeRequest);
        return object2;
    }

    protected void write0(IoFilter.WriteRequest writeRequest) {
        writeRequest.getFuture().setWritten(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttachment() {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.get("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setAttachment(Object object) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.put("", object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String string) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setAttribute(String string, Object object) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.put(string, object);
        }
    }

    @Override
    public Object setAttribute(String string) {
        return this.setAttribute(string, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeAttribute(String string) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.remove(string);
        }
    }

    @Override
    public boolean containsAttribute(String string) {
        return this.getAttribute(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getAttributeKeys() {
        Map map = this.attributes;
        synchronized (map) {
            return new HashSet(this.attributes.keySet());
        }
    }

    @Override
    public int getIdleTime(IdleStatus idleStatus) {
        if (idleStatus == IdleStatus.BOTH_IDLE) {
            return (int)this.idleTimeForBoth / 1000;
        }
        if (idleStatus == IdleStatus.READER_IDLE) {
            return (int)this.idleTimeForRead / 1000;
        }
        if (idleStatus == IdleStatus.WRITER_IDLE) {
            return (int)this.idleTimeForWrite / 1000;
        }
        throw new IllegalArgumentException("Unknown idle status: " + idleStatus);
    }

    @Override
    public long getIdleTimeInMillis(IdleStatus idleStatus) {
        if (idleStatus == IdleStatus.BOTH_IDLE) {
            return this.idleTimeForBoth;
        }
        if (idleStatus == IdleStatus.READER_IDLE) {
            return this.idleTimeForRead;
        }
        if (idleStatus == IdleStatus.WRITER_IDLE) {
            return this.idleTimeForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + idleStatus);
    }

    @Override
    public void setIdleTimeInMillis(IdleStatus idleStatus, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Illegal idle time: " + l);
        }
        if (idleStatus == IdleStatus.BOTH_IDLE) {
            this.idleTimeForBoth = l;
        } else if (idleStatus == IdleStatus.READER_IDLE) {
            this.idleTimeForRead = l;
        } else if (idleStatus == IdleStatus.WRITER_IDLE) {
            this.idleTimeForWrite = l;
        } else {
            throw new IllegalArgumentException("Unknown idle status: " + idleStatus);
        }
    }

    @Override
    public void setIdleTime(IdleStatus idleStatus, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal idle time: " + n);
        }
        if (idleStatus == IdleStatus.BOTH_IDLE) {
            this.idleTimeForBoth = n * 1000;
        } else if (idleStatus == IdleStatus.READER_IDLE) {
            this.idleTimeForRead = n * 1000;
        } else if (idleStatus == IdleStatus.WRITER_IDLE) {
            this.idleTimeForWrite = n * 1000;
        } else {
            throw new IllegalArgumentException("Unknown idle status: " + idleStatus);
        }
    }

    @Override
    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    @Override
    public long getWriteTimeoutInMillis() {
        return (long)this.writeTimeout * 1000L;
    }

    @Override
    public void setWriteTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal write timeout: " + n);
        }
        this.writeTimeout = n;
    }

    @Override
    public TrafficMask getTrafficMask() {
        return this.trafficMask;
    }

    @Override
    public void setTrafficMask(TrafficMask trafficMask) {
        if (trafficMask == null) {
            throw new NullPointerException("trafficMask");
        }
        if (this.trafficMask == trafficMask) {
            return;
        }
        this.trafficMask = trafficMask;
        this.updateTrafficMask();
    }

    @Override
    public void suspendRead() {
        this.setTrafficMask(this.getTrafficMask().and(TrafficMask.READ.not()));
    }

    @Override
    public void suspendWrite() {
        this.setTrafficMask(this.getTrafficMask().and(TrafficMask.WRITE.not()));
    }

    @Override
    public void resumeRead() {
        this.setTrafficMask(this.getTrafficMask().or(TrafficMask.READ));
    }

    @Override
    public void resumeWrite() {
        this.setTrafficMask(this.getTrafficMask().or(TrafficMask.WRITE));
    }

    protected abstract void updateTrafficMask();

    @Override
    public long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    @Override
    public long getWrittenWriteRequests() {
        return this.writtenWriteRequests;
    }

    @Override
    public long getReadMessages() {
        return this.readMessages;
    }

    @Override
    public long getWrittenMessages() {
        return this.writtenMessages;
    }

    public void increaseReadBytes(int n) {
        this.readBytes += (long)n;
        this.lastReadTime = System.currentTimeMillis();
        this.idleCountForBoth = 0;
        this.idleCountForRead = 0;
    }

    public void increaseWrittenBytes(int n) {
        this.writtenBytes += (long)n;
        this.lastWriteTime = System.currentTimeMillis();
        this.idleCountForBoth = 0;
        this.idleCountForWrite = 0;
    }

    public void increaseWrittenWriteRequests() {
        ++this.writtenWriteRequests;
    }

    public void increaseReadMessages() {
        ++this.readMessages;
    }

    public void increaseWrittenMessages() {
        ++this.writtenMessages;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastIoTime() {
        return Math.max(this.lastReadTime, this.lastWriteTime);
    }

    @Override
    public long getLastReadTime() {
        return this.lastReadTime;
    }

    @Override
    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    @Override
    public boolean isIdle(IdleStatus idleStatus) {
        if (idleStatus == IdleStatus.BOTH_IDLE) {
            return this.idleCountForBoth > 0;
        }
        if (idleStatus == IdleStatus.READER_IDLE) {
            return this.idleCountForRead > 0;
        }
        if (idleStatus == IdleStatus.WRITER_IDLE) {
            return this.idleCountForWrite > 0;
        }
        throw new IllegalArgumentException("Unknown idle status: " + idleStatus);
    }

    @Override
    public int getIdleCount(IdleStatus idleStatus) {
        if (idleStatus == IdleStatus.BOTH_IDLE) {
            return this.idleCountForBoth;
        }
        if (idleStatus == IdleStatus.READER_IDLE) {
            return this.idleCountForRead;
        }
        if (idleStatus == IdleStatus.WRITER_IDLE) {
            return this.idleCountForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + idleStatus);
    }

    @Override
    public long getLastIdleTime(IdleStatus idleStatus) {
        if (idleStatus == IdleStatus.BOTH_IDLE) {
            return this.lastIdleTimeForBoth;
        }
        if (idleStatus == IdleStatus.READER_IDLE) {
            return this.lastIdleTimeForRead;
        }
        if (idleStatus == IdleStatus.WRITER_IDLE) {
            return this.lastIdleTimeForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + idleStatus);
    }

    public void increaseIdleCount(IdleStatus idleStatus) {
        if (idleStatus == IdleStatus.BOTH_IDLE) {
            ++this.idleCountForBoth;
            this.lastIdleTimeForBoth = System.currentTimeMillis();
        } else if (idleStatus == IdleStatus.READER_IDLE) {
            ++this.idleCountForRead;
            this.lastIdleTimeForRead = System.currentTimeMillis();
        } else if (idleStatus == IdleStatus.WRITER_IDLE) {
            ++this.idleCountForWrite;
            this.lastIdleTimeForWrite = System.currentTimeMillis();
        } else {
            throw new IllegalArgumentException("Unknown idle status: " + idleStatus);
        }
    }

    public String toString() {
        return "(" + this.getTransportType() + ", R: " + this.getRemoteAddress() + ", L: " + this.getLocalAddress() + ", S: " + this.getServiceAddress() + ')';
    }

    @Override
    public long incrementMessageBytesWaiting(long l) {
        long l2 = this.messageBytesWaiting.addAndGet(l);
        return l2;
    }

    @Override
    public long decrementMessageBytesWaiting(long l) {
        long l2 = this.messageBytesWaiting.addAndGet(-l);
        return l2;
    }

    @Override
    public long getMessageBytesWaiting() {
        long l = this.messageBytesWaiting.get();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pushInQueue() {
        Object object = this.inQueueLock;
        synchronized (object) {
            return this.inQueue++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int popInQueue() {
        Object object = this.inQueueLock;
        synchronized (object) {
            return --this.inQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInQueue() {
        Object object = this.inQueueLock;
        synchronized (object) {
            return this.inQueue;
        }
    }

    @Override
    public long getAndIncrementSSLWriteSequence() {
        return this.sslWriteSequence.getAndIncrement();
    }
}

