/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.net.SocketAddress;
import java.util.Set;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceListener;
import org.apache.mina.common.support.IoServiceListenerSupport;

public abstract class BaseIoService
implements IoService {
    private IoFilterChainBuilder filterChainBuilder = new DefaultIoFilterChainBuilder();
    private final IoServiceListenerSupport listeners = new IoServiceListenerSupport();

    protected BaseIoService() {
    }

    @Override
    public IoFilterChainBuilder getFilterChainBuilder() {
        return this.filterChainBuilder;
    }

    @Override
    public void setFilterChainBuilder(IoFilterChainBuilder ioFilterChainBuilder) {
        if (ioFilterChainBuilder == null) {
            ioFilterChainBuilder = new DefaultIoFilterChainBuilder();
        }
        this.filterChainBuilder = ioFilterChainBuilder;
    }

    @Override
    public DefaultIoFilterChainBuilder getFilterChain() {
        if (this.filterChainBuilder instanceof DefaultIoFilterChainBuilder) {
            return (DefaultIoFilterChainBuilder)this.filterChainBuilder;
        }
        throw new IllegalStateException("Current filter chain builder is not a DefaultIoFilterChainBuilder.");
    }

    @Override
    public void addListener(IoServiceListener ioServiceListener) {
        this.getListeners().add(ioServiceListener);
    }

    @Override
    public void removeListener(IoServiceListener ioServiceListener) {
        this.getListeners().remove(ioServiceListener);
    }

    @Override
    public Set getManagedServiceAddresses() {
        return this.getListeners().getManagedServiceAddresses();
    }

    @Override
    public Set getManagedSessions(SocketAddress socketAddress) {
        return this.getListeners().getManagedSessions(socketAddress);
    }

    @Override
    public boolean isManaged(SocketAddress socketAddress) {
        return this.getListeners().isManaged(socketAddress);
    }

    protected IoServiceListenerSupport getListeners() {
        return this.listeners;
    }
}

