/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFilterLifeCycleException;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.ByteBufferUtil;
import org.apache.mina.util.SessionLog;

public abstract class AbstractIoFilterChain
implements IoFilterChain {
    private final IoSession session;
    private final Map name2entry = new HashMap();
    private final EntryImpl head;
    private final EntryImpl tail;
    long lastSendTime = -1L;

    protected AbstractIoFilterChain(IoSession ioSession) {
        if (ioSession == null) {
            throw new NullPointerException("session");
        }
        this.session = ioSession;
        this.head = new EntryImpl(null, null, "head", this.createHeadFilter());
        this.head.nextEntry = this.tail = new EntryImpl(this.head, null, "tail", this.createTailFilter());
    }

    protected IoFilter createHeadFilter() {
        return new IoFilterAdapter(){

            @Override
            public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession ioSession) {
                nextFilter.sessionCreated(ioSession);
            }

            @Override
            public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession ioSession) {
                nextFilter.sessionOpened(ioSession);
            }

            @Override
            public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession ioSession) {
                nextFilter.sessionClosed(ioSession);
            }

            @Override
            public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession ioSession, IdleStatus idleStatus) {
                nextFilter.sessionIdle(ioSession, idleStatus);
            }

            @Override
            public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession ioSession, Throwable throwable) {
                nextFilter.exceptionCaught(ioSession, throwable);
            }

            @Override
            public void messageReceived(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) {
                nextFilter.messageReceived(ioSession, object);
            }

            @Override
            public void messageSent(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) {
                nextFilter.messageSent(ioSession, object);
            }

            @Override
            public void filterWrite(IoFilter.NextFilter nextFilter, IoSession ioSession, IoFilter.WriteRequest writeRequest) throws Exception {
                if (!ioSession.getTransportType().getEnvelopeType().isAssignableFrom(writeRequest.getMessage().getClass())) {
                    throw new IllegalStateException("Write requests must be transformed to " + ioSession.getTransportType().getEnvelopeType() + ": " + writeRequest);
                }
                AbstractIoFilterChain.this.doWrite(ioSession, writeRequest);
            }

            @Override
            public void filterClose(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
                AbstractIoFilterChain.this.doClose(ioSession);
            }
        };
    }

    protected IoFilter createTailFilter() {
        return new IoFilterAdapter(){

            @Override
            public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
                ioSession.getHandler().sessionCreated(ioSession);
            }

            @Override
            public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
                ioSession.getHandler().sessionOpened(ioSession);
            }

            @Override
            public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
                try {
                    ioSession.getHandler().sessionClosed(ioSession);
                }
                finally {
                    ioSession.getFilterChain().clear();
                }
            }

            @Override
            public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession ioSession, IdleStatus idleStatus) throws Exception {
                ioSession.getHandler().sessionIdle(ioSession, idleStatus);
            }

            @Override
            public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession ioSession, Throwable throwable) throws Exception {
                ioSession.getHandler().exceptionCaught(ioSession, throwable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void messageReceived(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws Exception {
                try {
                    ioSession.getHandler().messageReceived(ioSession, object);
                }
                finally {
                    ByteBufferUtil.releaseIfPossible(object);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void messageSent(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws Exception {
                try {
                    ioSession.getHandler().messageSent(ioSession, object);
                }
                finally {
                    ByteBufferUtil.releaseIfPossible(object);
                }
            }

            @Override
            public void filterWrite(IoFilter.NextFilter nextFilter, IoSession ioSession, IoFilter.WriteRequest writeRequest) throws Exception {
                nextFilter.filterWrite(ioSession, writeRequest);
            }

            @Override
            public void filterClose(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
                nextFilter.filterClose(ioSession);
            }
        };
    }

    @Override
    public IoSession getSession() {
        return this.session;
    }

    @Override
    public IoFilterChain.Entry getEntry(String string) {
        IoFilterChain.Entry entry = (IoFilterChain.Entry)this.name2entry.get(string);
        if (entry == null) {
            return null;
        }
        return entry;
    }

    @Override
    public IoFilter get(String string) {
        IoFilterChain.Entry entry = this.getEntry(string);
        if (entry == null) {
            return null;
        }
        return entry.getFilter();
    }

    @Override
    public IoFilter.NextFilter getNextFilter(String string) {
        IoFilterChain.Entry entry = this.getEntry(string);
        if (entry == null) {
            return null;
        }
        return entry.getNextFilter();
    }

    @Override
    public synchronized void addFirst(String string, IoFilter ioFilter) {
        this.checkAddable(string);
        this.register(this.head, string, ioFilter);
    }

    @Override
    public synchronized void addLast(String string, IoFilter ioFilter) {
        this.checkAddable(string);
        this.register(this.tail.prevEntry, string, ioFilter);
    }

    @Override
    public synchronized void addBefore(String string, String string2, IoFilter ioFilter) {
        EntryImpl entryImpl = this.checkOldName(string);
        this.checkAddable(string2);
        this.register(entryImpl.prevEntry, string2, ioFilter);
    }

    @Override
    public synchronized void addAfter(String string, String string2, IoFilter ioFilter) {
        EntryImpl entryImpl = this.checkOldName(string);
        this.checkAddable(string2);
        this.register(entryImpl, string2, ioFilter);
    }

    @Override
    public synchronized IoFilter remove(String string) {
        EntryImpl entryImpl = this.checkOldName(string);
        this.deregister(entryImpl);
        return entryImpl.getFilter();
    }

    @Override
    public synchronized void clear() throws Exception {
        Iterator iterator = new ArrayList(this.name2entry.keySet()).iterator();
        while (iterator.hasNext()) {
            this.remove((String)iterator.next());
        }
    }

    private void register(EntryImpl entryImpl, String string, IoFilter ioFilter) {
        EntryImpl entryImpl2 = new EntryImpl(entryImpl, entryImpl.nextEntry, string, ioFilter);
        try {
            ioFilter.onPreAdd(this, string, entryImpl2.getNextFilter());
        }
        catch (Exception exception) {
            throw new IoFilterLifeCycleException("onPreAdd(): " + string + ':' + ioFilter + " in " + this.getSession(), exception);
        }
        entryImpl.nextEntry.prevEntry = entryImpl2;
        entryImpl.nextEntry = entryImpl2;
        this.name2entry.put(string, entryImpl2);
        try {
            ioFilter.onPostAdd(this, string, entryImpl2.getNextFilter());
        }
        catch (Exception exception) {
            this.deregister0(entryImpl2);
            throw new IoFilterLifeCycleException("onPostAdd(): " + string + ':' + ioFilter + " in " + this.getSession(), exception);
        }
    }

    private void deregister(EntryImpl entryImpl) {
        IoFilter ioFilter = entryImpl.getFilter();
        try {
            ioFilter.onPreRemove(this, entryImpl.getName(), entryImpl.getNextFilter());
        }
        catch (Exception exception) {
            throw new IoFilterLifeCycleException("onPreRemove(): " + entryImpl.getName() + ':' + ioFilter + " in " + this.getSession(), exception);
        }
        this.deregister0(entryImpl);
        try {
            ioFilter.onPostRemove(this, entryImpl.getName(), entryImpl.getNextFilter());
        }
        catch (Exception exception) {
            throw new IoFilterLifeCycleException("onPostRemove(): " + entryImpl.getName() + ':' + ioFilter + " in " + this.getSession(), exception);
        }
    }

    private void deregister0(EntryImpl entryImpl) {
        EntryImpl entryImpl2;
        EntryImpl entryImpl3 = entryImpl.prevEntry;
        entryImpl3.nextEntry = entryImpl2 = entryImpl.nextEntry;
        entryImpl2.prevEntry = entryImpl3;
        this.name2entry.remove(entryImpl.name);
    }

    private EntryImpl checkOldName(String string) {
        EntryImpl entryImpl = (EntryImpl)this.name2entry.get(string);
        if (entryImpl == null) {
            throw new IllegalArgumentException("Unknown filter name:" + string);
        }
        return entryImpl;
    }

    private void checkAddable(String string) {
        if (this.name2entry.containsKey(string)) {
            throw new IllegalArgumentException("Other filter is using the same name '" + string + "'");
        }
    }

    @Override
    public void fireSessionCreated(IoSession ioSession) {
        EntryImpl entryImpl = this.head;
        this.callNextSessionCreated(entryImpl, ioSession);
    }

    private void callNextSessionCreated(IoFilterChain.Entry entry, IoSession ioSession) {
        try {
            entry.getFilter().sessionCreated(entry.getNextFilter(), ioSession);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(ioSession, throwable);
        }
    }

    @Override
    public void fireSessionOpened(IoSession ioSession) {
        EntryImpl entryImpl = this.head;
        this.callNextSessionOpened(entryImpl, ioSession);
    }

    private void callNextSessionOpened(IoFilterChain.Entry entry, IoSession ioSession) {
        try {
            entry.getFilter().sessionOpened(entry.getNextFilter(), ioSession);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(ioSession, throwable);
        }
    }

    @Override
    public void fireSessionClosed(IoSession ioSession) {
        try {
            ioSession.getCloseFuture().setClosed();
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(ioSession, throwable);
        }
        EntryImpl entryImpl = this.head;
        this.callNextSessionClosed(entryImpl, ioSession);
    }

    private void callNextSessionClosed(IoFilterChain.Entry entry, IoSession ioSession) {
        try {
            entry.getFilter().sessionClosed(entry.getNextFilter(), ioSession);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(ioSession, throwable);
        }
    }

    @Override
    public void fireSessionIdle(IoSession ioSession, IdleStatus idleStatus) {
        EntryImpl entryImpl = this.head;
        this.callNextSessionIdle(entryImpl, ioSession, idleStatus);
    }

    private void callNextSessionIdle(IoFilterChain.Entry entry, IoSession ioSession, IdleStatus idleStatus) {
        try {
            entry.getFilter().sessionIdle(entry.getNextFilter(), ioSession, idleStatus);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(ioSession, throwable);
        }
    }

    @Override
    public void fireMessageReceived(IoSession ioSession, Object object) {
        EntryImpl entryImpl = this.head;
        this.callNextMessageReceived(entryImpl, ioSession, object);
    }

    private void callNextMessageReceived(IoFilterChain.Entry entry, IoSession ioSession, Object object) {
        try {
            entry.getFilter().messageReceived(entry.getNextFilter(), ioSession, object);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(ioSession, throwable);
        }
    }

    @Override
    public void fireMessageSent(IoSession ioSession, IoFilter.WriteRequest writeRequest) {
        try {
            writeRequest.getFuture().setWritten(true);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(ioSession, throwable);
        }
        EntryImpl entryImpl = this.head;
        this.callNextMessageSent(entryImpl, ioSession, writeRequest.getMessage());
    }

    private void callNextMessageSent(IoFilterChain.Entry entry, IoSession ioSession, Object object) {
        try {
            entry.getFilter().messageSent(entry.getNextFilter(), ioSession, object);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(ioSession, throwable);
        }
    }

    @Override
    public void fireExceptionCaught(IoSession ioSession, Throwable throwable) {
        EntryImpl entryImpl = this.head;
        this.callNextExceptionCaught(entryImpl, ioSession, throwable);
    }

    private void callNextExceptionCaught(IoFilterChain.Entry entry, IoSession ioSession, Throwable throwable) {
        try {
            entry.getFilter().exceptionCaught(entry.getNextFilter(), ioSession, throwable);
        }
        catch (Throwable throwable2) {
            SessionLog.warn(ioSession, "Unexpected exception from exceptionCaught handler.", throwable2);
        }
    }

    @Override
    public void fireFilterWrite(IoSession ioSession, IoFilter.WriteRequest writeRequest) {
        EntryImpl entryImpl = this.tail;
        this.callPreviousFilterWrite(entryImpl, ioSession, writeRequest);
    }

    private void callPreviousFilterWrite(IoFilterChain.Entry entry, IoSession ioSession, IoFilter.WriteRequest writeRequest) {
        try {
            entry.getFilter().filterWrite(entry.getNextFilter(), ioSession, writeRequest);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(ioSession, throwable);
        }
    }

    @Override
    public void fireFilterClose(IoSession ioSession) {
        EntryImpl entryImpl = this.tail;
        this.callPreviousFilterClose(entryImpl, ioSession);
    }

    private void callPreviousFilterClose(IoFilterChain.Entry entry, IoSession ioSession) {
        try {
            entry.getFilter().filterClose(entry.getNextFilter(), ioSession);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(ioSession, throwable);
        }
    }

    @Override
    public List getAll() {
        ArrayList<EntryImpl> arrayList = new ArrayList<EntryImpl>();
        EntryImpl entryImpl = this.head.nextEntry;
        while (entryImpl != this.tail) {
            arrayList.add(entryImpl);
            entryImpl = entryImpl.nextEntry;
        }
        return arrayList;
    }

    @Override
    public List getAllReversed() {
        ArrayList<EntryImpl> arrayList = new ArrayList<EntryImpl>();
        EntryImpl entryImpl = this.tail.prevEntry;
        while (entryImpl != this.head) {
            arrayList.add(entryImpl);
            entryImpl = entryImpl.prevEntry;
        }
        return arrayList;
    }

    @Override
    public boolean contains(String string) {
        return this.getEntry(string) != null;
    }

    @Override
    public boolean contains(IoFilter ioFilter) {
        EntryImpl entryImpl = this.head.nextEntry;
        while (entryImpl != this.tail) {
            if (entryImpl.getFilter() == ioFilter) {
                return true;
            }
            entryImpl = entryImpl.nextEntry;
        }
        return false;
    }

    @Override
    public boolean contains(Class clazz) {
        EntryImpl entryImpl = this.head.nextEntry;
        while (entryImpl != this.tail) {
            if (clazz.isAssignableFrom(entryImpl.getFilter().getClass())) {
                return true;
            }
            entryImpl = entryImpl.nextEntry;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        boolean bl = true;
        EntryImpl entryImpl = this.head.nextEntry;
        while (entryImpl != this.tail) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append('(');
            stringBuffer.append(entryImpl.getName());
            stringBuffer.append(':');
            stringBuffer.append(entryImpl.getFilter());
            stringBuffer.append(')');
            entryImpl = entryImpl.nextEntry;
        }
        if (bl) {
            stringBuffer.append("empty");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    protected abstract void doWrite(IoSession var1, IoFilter.WriteRequest var2) throws Exception;

    protected abstract void doClose(IoSession var1) throws Exception;

    private class EntryImpl
    implements IoFilterChain.Entry {
        private EntryImpl prevEntry;
        private EntryImpl nextEntry;
        private final String name;
        private final IoFilter filter;
        private final IoFilter.NextFilter nextFilter;

        private EntryImpl(EntryImpl entryImpl, EntryImpl entryImpl2, String string, IoFilter ioFilter) {
            if (ioFilter == null) {
                throw new NullPointerException("filter");
            }
            if (string == null) {
                throw new NullPointerException("name");
            }
            this.prevEntry = entryImpl;
            this.nextEntry = entryImpl2;
            this.name = string;
            this.filter = ioFilter;
            this.nextFilter = new IoFilter.NextFilter(){

                @Override
                public void sessionCreated(IoSession ioSession) {
                    EntryImpl entryImpl = EntryImpl.this.nextEntry;
                    AbstractIoFilterChain.this.callNextSessionCreated(entryImpl, ioSession);
                }

                @Override
                public void sessionOpened(IoSession ioSession) {
                    EntryImpl entryImpl = EntryImpl.this.nextEntry;
                    AbstractIoFilterChain.this.callNextSessionOpened(entryImpl, ioSession);
                }

                @Override
                public void sessionClosed(IoSession ioSession) {
                    EntryImpl entryImpl = EntryImpl.this.nextEntry;
                    AbstractIoFilterChain.this.callNextSessionClosed(entryImpl, ioSession);
                }

                @Override
                public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) {
                    EntryImpl entryImpl = EntryImpl.this.nextEntry;
                    AbstractIoFilterChain.this.callNextSessionIdle(entryImpl, ioSession, idleStatus);
                }

                @Override
                public void exceptionCaught(IoSession ioSession, Throwable throwable) {
                    EntryImpl entryImpl = EntryImpl.this.nextEntry;
                    AbstractIoFilterChain.this.callNextExceptionCaught(entryImpl, ioSession, throwable);
                }

                @Override
                public void messageReceived(IoSession ioSession, Object object) {
                    EntryImpl entryImpl = EntryImpl.this.nextEntry;
                    AbstractIoFilterChain.this.callNextMessageReceived(entryImpl, ioSession, object);
                }

                @Override
                public void messageSent(IoSession ioSession, Object object) {
                    EntryImpl entryImpl = EntryImpl.this.nextEntry;
                    AbstractIoFilterChain.this.callNextMessageSent(entryImpl, ioSession, object);
                }

                @Override
                public void filterWrite(IoSession ioSession, IoFilter.WriteRequest writeRequest) {
                    EntryImpl entryImpl = EntryImpl.this.prevEntry;
                    AbstractIoFilterChain.this.callPreviousFilterWrite(entryImpl, ioSession, writeRequest);
                }

                @Override
                public void filterClose(IoSession ioSession) {
                    EntryImpl entryImpl = EntryImpl.this.prevEntry;
                    AbstractIoFilterChain.this.callPreviousFilterClose(entryImpl, ioSession);
                }
            };
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IoFilter getFilter() {
            return this.filter;
        }

        @Override
        public IoFilter.NextFilter getNextFilter() {
            return this.nextFilter;
        }

        public String toString() {
            return "(" + this.getName() + ':' + this.filter + ')';
        }
    }
}

