/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFilterChainBuilder;

public class DefaultIoFilterChainBuilder
implements IoFilterChainBuilder,
Cloneable {
    private List entries = new ArrayList();
    private final Map entriesByName = new HashMap();

    public synchronized IoFilterChain.Entry getEntry(String string) {
        return (IoFilterChain.Entry)this.entriesByName.get(string);
    }

    public synchronized IoFilter get(String string) {
        IoFilterChain.Entry entry = this.getEntry(string);
        if (entry == null) {
            return null;
        }
        return entry.getFilter();
    }

    public List getAll() {
        return new ArrayList(this.entries);
    }

    public List getAllReversed() {
        List list = this.getAll();
        Collections.reverse(list);
        return list;
    }

    public boolean contains(String string) {
        return this.getEntry(string) != null;
    }

    public boolean contains(IoFilter ioFilter) {
        for (IoFilterChain.Entry entry : this.entries) {
            if (entry.getFilter() != ioFilter) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Class clazz) {
        for (IoFilterChain.Entry entry : this.entries) {
            if (!clazz.isAssignableFrom(entry.getFilter().getClass())) continue;
            return true;
        }
        return false;
    }

    public synchronized void addFirst(String string, IoFilter ioFilter) {
        this.register(0, new EntryImpl(string, ioFilter));
    }

    public synchronized void addLast(String string, IoFilter ioFilter) {
        this.register(this.entries.size(), new EntryImpl(string, ioFilter));
    }

    public synchronized void addBefore(String string, String string2, IoFilter ioFilter) {
        this.checkBaseName(string);
        ListIterator listIterator = this.entries.listIterator();
        while (listIterator.hasNext()) {
            IoFilterChain.Entry entry = (IoFilterChain.Entry)listIterator.next();
            if (!entry.getName().equals(string)) continue;
            this.register(listIterator.previousIndex(), new EntryImpl(string2, ioFilter));
            break;
        }
    }

    public synchronized void addAfter(String string, String string2, IoFilter ioFilter) {
        this.checkBaseName(string);
        ArrayList arrayList = new ArrayList(this.entries);
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            IoFilterChain.Entry entry = (IoFilterChain.Entry)listIterator.next();
            if (!entry.getName().equals(string)) continue;
            this.register(listIterator.nextIndex(), new EntryImpl(string2, ioFilter));
            break;
        }
    }

    public synchronized IoFilter remove(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        ListIterator listIterator = this.entries.listIterator();
        while (listIterator.hasNext()) {
            IoFilterChain.Entry entry = (IoFilterChain.Entry)listIterator.next();
            if (!entry.getName().equals(string)) continue;
            this.deregister(listIterator.previousIndex(), entry);
            return entry.getFilter();
        }
        throw new IllegalArgumentException("Unknown filter name: " + string);
    }

    public synchronized void clear() throws Exception {
        this.entries = new ArrayList();
        this.entriesByName.clear();
    }

    @Override
    public void buildFilterChain(IoFilterChain ioFilterChain) throws Exception {
        for (IoFilterChain.Entry entry : this.entries) {
            ioFilterChain.addLast(entry.getName(), entry.getFilter());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        boolean bl = true;
        for (IoFilterChain.Entry entry : this.entries) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append('(');
            stringBuffer.append(entry.getName());
            stringBuffer.append(':');
            stringBuffer.append(entry.getFilter());
            stringBuffer.append(')');
        }
        if (bl) {
            stringBuffer.append("empty");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public Object clone() {
        DefaultIoFilterChainBuilder defaultIoFilterChainBuilder = new DefaultIoFilterChainBuilder();
        for (IoFilterChain.Entry entry : this.entries) {
            defaultIoFilterChainBuilder.addLast(entry.getName(), entry.getFilter());
        }
        return defaultIoFilterChainBuilder;
    }

    private void checkBaseName(String string) {
        if (string == null) {
            throw new NullPointerException("baseName");
        }
        if (!this.entriesByName.containsKey(string)) {
            throw new IllegalArgumentException("Unknown filter name: " + string);
        }
    }

    private void register(int n, IoFilterChain.Entry entry) {
        if (this.entriesByName.containsKey(entry.getName())) {
            throw new IllegalArgumentException("Other filter is using the same name: " + entry.getName());
        }
        ArrayList<IoFilterChain.Entry> arrayList = new ArrayList<IoFilterChain.Entry>(this.entries);
        arrayList.add(n, entry);
        this.entries = arrayList;
        this.entriesByName.put(entry.getName(), entry);
    }

    private void deregister(int n, IoFilterChain.Entry entry) {
        ArrayList arrayList = new ArrayList(this.entries);
        arrayList.remove(n);
        this.entries = arrayList;
        this.entriesByName.remove(entry.getName());
    }

    private static class EntryImpl
    implements IoFilterChain.Entry {
        private final String name;
        private final IoFilter filter;

        private EntryImpl(String string, IoFilter ioFilter) {
            if (string == null) {
                throw new NullPointerException("name");
            }
            if (ioFilter == null) {
                throw new NullPointerException("filter");
            }
            this.name = string;
            this.filter = ioFilter;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IoFilter getFilter() {
            return this.filter;
        }

        @Override
        public IoFilter.NextFilter getNextFilter() {
            throw new IllegalStateException();
        }

        public String toString() {
            return "(" + this.getName() + ':' + this.filter + ')';
        }
    }
}

