/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.WMSTimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WMSFIFOWaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WMSUtils;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WMSWaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSCondVar;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSCondition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSFIFOCondVar;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;

public class WMSReentrantLock
implements WMSLock,
Serializable,
WMSCondVar.ExclusiveLock {
    private static final long serialVersionUID = 7373984872572414699L;
    private final Sync sync;

    public WMSReentrantLock() {
        this.sync = new NonfairSync();
    }

    public WMSReentrantLock(boolean bl) {
        this.sync = bl ? new FairSync() : new NonfairSync();
    }

    @Override
    public void lock() {
        this.sync.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.sync.lockInterruptibly();
    }

    @Override
    public boolean tryLock() {
        return this.sync.tryLock();
    }

    @Override
    public boolean tryLock(long l, WMSTimeUnit wMSTimeUnit) throws InterruptedException {
        return this.sync.tryLock(wMSTimeUnit.toNanos(l));
    }

    @Override
    public void unlock() {
        this.sync.unlock();
    }

    @Override
    public WMSCondition newCondition() {
        return this.isFair() ? new WMSFIFOCondVar(this) : new WMSCondVar(this);
    }

    @Override
    public int getHoldCount() {
        return this.sync.getHoldCount();
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return this.sync.isHeldByCurrentThread();
    }

    public boolean isLocked() {
        return this.sync.isLocked();
    }

    public final boolean isFair() {
        return this.sync.isFair();
    }

    protected Thread getOwner() {
        return this.sync.getOwner();
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        return this.sync.isQueued(thread);
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public boolean hasWaiters(WMSCondition wMSCondition) {
        return this.asCondVar(wMSCondition).hasWaiters();
    }

    public int getWaitQueueLength(WMSCondition wMSCondition) {
        return this.asCondVar(wMSCondition).getWaitQueueLength();
    }

    protected Collection getWaitingThreads(WMSCondition wMSCondition) {
        return this.asCondVar(wMSCondition).getWaitingThreads();
    }

    public String toString() {
        Thread thread = this.getOwner();
        return super.toString() + (String)(thread == null ? "[Unlocked]" : "[Locked by thread " + thread.getName() + "]");
    }

    private WMSCondVar asCondVar(WMSCondition wMSCondition) {
        if (wMSCondition == null) {
            throw new NullPointerException();
        }
        if (!(wMSCondition instanceof WMSCondVar)) {
            throw new IllegalArgumentException("not owner");
        }
        WMSCondVar wMSCondVar = (WMSCondVar)wMSCondition;
        if (wMSCondVar.lock != this) {
            throw new IllegalArgumentException("not owner");
        }
        return wMSCondVar;
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = 7316153563782823691L;

        NonfairSync() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lock() {
            Thread thread = Thread.currentThread();
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return;
                }
                boolean bl = Thread.interrupted();
                try {
                    do {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                    } while (this.owner_ != null);
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return;
                }
                finally {
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread thread = Thread.currentThread();
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return;
                }
                try {
                    do {
                        this.wait();
                    } while (this.owner_ != null);
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return;
                }
                catch (InterruptedException interruptedException) {
                    if (this.owner_ == null) {
                        this.notify();
                    }
                    throw interruptedException;
                }
            }
        }

        @Override
        public boolean tryLock(long l) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread thread = Thread.currentThread();
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return true;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return true;
                }
                if (l <= 0L) {
                    return false;
                }
                long l2 = WMSUtils.nanoTime() + l;
                try {
                    do {
                        WMSTimeUnit.NANOSECONDS.timedWait(this, l);
                        if (thread == this.owner_) {
                            this.incHolds();
                            return true;
                        }
                        if (this.owner_ != null) continue;
                        this.owner_ = thread;
                        this.holds_ = 1;
                        return true;
                    } while ((l = l2 - WMSUtils.nanoTime()) > 0L);
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    if (this.owner_ == null) {
                        this.notify();
                    }
                    throw interruptedException;
                }
            }
        }

        @Override
        public synchronized void unlock() {
            if (Thread.currentThread() != this.owner_) {
                throw new IllegalMonitorStateException("Not owner");
            }
            if (--this.holds_ == 0) {
                this.owner_ = null;
                this.notify();
            }
        }

        @Override
        public final boolean isFair() {
            return false;
        }
    }

    static abstract class Sync
    implements Serializable {
        private static final long serialVersionUID = -5179523762034025860L;
        protected transient Thread owner_ = null;
        protected transient int holds_ = 0;

        protected Sync() {
        }

        public abstract void lock();

        public abstract void lockInterruptibly() throws InterruptedException;

        final void incHolds() {
            int n;
            if ((n = ++this.holds_) < 0) {
                throw new Error("Maximum lock count exceeded");
            }
            this.holds_ = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock() {
            Thread thread = Thread.currentThread();
            Sync sync = this;
            synchronized (sync) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return true;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return true;
                }
            }
            return false;
        }

        public abstract boolean tryLock(long var1) throws InterruptedException;

        public abstract void unlock();

        public synchronized int getHoldCount() {
            return this.isHeldByCurrentThread() ? this.holds_ : 0;
        }

        public synchronized boolean isHeldByCurrentThread() {
            return this.holds_ > 0 && Thread.currentThread() == this.owner_;
        }

        public synchronized boolean isLocked() {
            return this.owner_ != null;
        }

        public abstract boolean isFair();

        protected synchronized Thread getOwner() {
            return this.owner_;
        }

        public boolean hasQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public int getQueueLength() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public Collection getQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public boolean isQueued(Thread thread) {
            throw new UnsupportedOperationException("Use FAIR version");
        }
    }

    static final class FairSync
    extends Sync
    implements WMSWaitQueue.QueuedSync {
        private static final long serialVersionUID = -3000897897090466540L;
        private transient WMSWaitQueue wq_ = new WMSFIFOWaitQueue();

        FairSync() {
        }

        @Override
        public synchronized boolean recheck(WMSWaitQueue.WaitNode waitNode) {
            Thread thread = Thread.currentThread();
            if (this.owner_ == null) {
                this.owner_ = thread;
                this.holds_ = 1;
                return true;
            }
            if (thread == this.owner_) {
                this.incHolds();
                return true;
            }
            this.wq_.insert(waitNode);
            return false;
        }

        @Override
        public synchronized void takeOver(WMSWaitQueue.WaitNode waitNode) {
            this.owner_ = waitNode.getOwner();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lock() {
            Thread thread = Thread.currentThread();
            Object object = this;
            synchronized (object) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return;
                }
            }
            object = new WMSWaitQueue.WaitNode();
            ((WMSWaitQueue.WaitNode)object).doWaitUninterruptibly(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lockInterruptibly() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread thread = Thread.currentThread();
            Object object = this;
            synchronized (object) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return;
                }
            }
            object = new WMSWaitQueue.WaitNode();
            ((WMSWaitQueue.WaitNode)object).doWait(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryLock(long l) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread thread = Thread.currentThread();
            Object object = this;
            synchronized (object) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return true;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return true;
                }
            }
            object = new WMSWaitQueue.WaitNode();
            return ((WMSWaitQueue.WaitNode)object).doTimedWait(this, l);
        }

        protected synchronized WMSWaitQueue.WaitNode getSignallee(Thread thread) {
            if (thread != this.owner_) {
                throw new IllegalMonitorStateException("Not owner");
            }
            if (this.holds_ >= 2) {
                --this.holds_;
                return null;
            }
            WMSWaitQueue.WaitNode waitNode = this.wq_.extract();
            if (waitNode == null) {
                this.owner_ = null;
                this.holds_ = 0;
            }
            return waitNode;
        }

        @Override
        public void unlock() {
            WMSWaitQueue.WaitNode waitNode;
            Thread thread = Thread.currentThread();
            do {
                if ((waitNode = this.getSignallee(thread)) != null) continue;
                return;
            } while (!waitNode.signal(this));
        }

        @Override
        public final boolean isFair() {
            return true;
        }

        @Override
        public synchronized boolean hasQueuedThreads() {
            return this.wq_.hasNodes();
        }

        @Override
        public synchronized int getQueueLength() {
            return this.wq_.getLength();
        }

        @Override
        public synchronized Collection getQueuedThreads() {
            return this.wq_.getWaitingThreads();
        }

        @Override
        public synchronized boolean isQueued(Thread thread) {
            return this.wq_.isWaiting(thread);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            FairSync fairSync = this;
            synchronized (fairSync) {
                this.wq_ = new WMSFIFOWaitQueue();
            }
        }
    }
}

