/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class IntrospectionUtils {
    static final Class[] NO_PARAMS = new Class[0];
    static final Class[] STRING_OBJ_PARAM = new Class[]{String.class, Object.class};
    static final Class[] STRING_PARAM = new Class[]{String.class};
    public static String PATH_SEPARATOR = System.getProperty("path.separator");
    static Hashtable objectMethods = new Hashtable();
    static Object[] emptyArray = new Object[0];
    static final int dbg = 0;

    public static void execute(Object object, String string) throws Exception {
        Method method = null;
        Class<?> clazz = object.getClass();
        method = IntrospectionUtils.findMethod(clazz, string, NO_PARAMS);
        if (method == null) {
            throw new RuntimeException("No method " + string + " in " + object.getClass());
        }
        method.invoke(object, (Object[])null);
    }

    public static void setAttribute(Object object, String string, Object object2) throws Exception {
        if (object instanceof AttributeHolder) {
            ((AttributeHolder)object).setAttribute(string, object2);
            return;
        }
        Method method = null;
        Class<?> clazz = object.getClass();
        method = IntrospectionUtils.findMethod(clazz, "setAttribute", STRING_OBJ_PARAM);
        if (method == null) {
            System.out.println("No setAttribute in " + object.getClass());
            return;
        }
        method.invoke(object, string, object2);
    }

    public static Object getAttribute(Object object, String string) throws Exception {
        Method method = null;
        Class<?> clazz = object.getClass();
        method = IntrospectionUtils.findMethod(clazz, "getAttribute", STRING_PARAM);
        if (method == null) {
            System.out.println("No getAttribute in " + object.getClass());
            return null;
        }
        return method.invoke(object, string);
    }

    public static ClassLoader getURLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName("java.net.URLClassLoader");
            Class[] classArray = new Class[]{uRLArray.getClass(), ClassLoader.class};
            Method method = IntrospectionUtils.findMethod(clazz, "newInstance", classArray);
            if (method == null) {
                return null;
            }
            ClassLoader classLoader2 = (ClassLoader)method.invoke(clazz, uRLArray, classLoader);
            return classLoader2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String guessInstall(String string, String string2, String string3) {
        return IntrospectionUtils.guessInstall(string, string2, string3, null);
    }

    public static String guessInstall(String string, String string2, String string3, String string4) {
        String string5 = null;
        String string6 = null;
        if (string != null) {
            string5 = System.getProperty(string);
        }
        if (string2 != null) {
            string6 = System.getProperty(string2);
        }
        if (string5 != null) {
            if (string6 == null) {
                System.getProperties().put(string2, string5);
            }
            return string5;
        }
        String string7 = System.getProperty("java.class.path");
        String string8 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string7, string8);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string9 = stringTokenizer.nextToken();
            if (string9.endsWith(string3)) {
                string6 = string9.substring(0, string9.length() - string3.length());
                try {
                    if ("".equals(string6)) {
                        string6 = new File("./").getCanonicalPath();
                    } else if (string6.endsWith(File.separator)) {
                        string6 = string6.substring(0, string6.length() - 1);
                    }
                    object = new File(string6);
                    String string10 = ((File)object).getParent();
                    if (string10 == null) {
                        string10 = string6;
                    }
                    File file = new File(string10);
                    string5 = file.getCanonicalPath();
                    if (string != null) {
                        System.getProperties().put(string, string5);
                    }
                    if (string6 == null && string2 != null) {
                        System.getProperties().put(string2, string5);
                    }
                    return string5;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
            }
            object = string9 + (string9.endsWith("/") ? "" : "/") + string4;
            if (!new File((String)object).exists()) continue;
            try {
                File file = new File(string9);
                String string11 = file.getParent();
                if (string11 == null) {
                    string11 = string9;
                }
                File file2 = new File(string11);
                string5 = file2.getCanonicalPath();
                if (string != null) {
                    System.getProperties().put(string, string5);
                }
                if (string6 == null && string2 != null) {
                    System.getProperties().put(string2, string5);
                }
                return string5;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (string6 != null) {
            System.getProperties().put(string, string6);
            return string6;
        }
        return null;
    }

    public static void displayClassPath(String string, URL[] uRLArray) {
        System.out.println(string);
        for (int i = 0; i < uRLArray.length; ++i) {
            System.out.println(uRLArray[i].getFile());
        }
    }

    public static String classPathAdd(URL[] uRLArray, String object) {
        if (uRLArray == null) {
            return object;
        }
        for (int i = 0; i < uRLArray.length; ++i) {
            object = object != null ? (String)object + PATH_SEPARATOR + uRLArray[i].getFile() : uRLArray[i].getFile();
        }
        return object;
    }

    public static void setProperty(Object object, String string, String string2) {
        String string3 = "set" + IntrospectionUtils.capitalize(string);
        try {
            int n;
            Method[] methodArray = IntrospectionUtils.findMethods(object.getClass());
            Method method = null;
            for (n = 0; n < methodArray.length; ++n) {
                Class<?>[] classArray = methodArray[n].getParameterTypes();
                if (!string3.equals(methodArray[n].getName()) || classArray.length != 1 || !"java.lang.String".equals(classArray[0].getName())) continue;
                methodArray[n].invoke(object, string2);
                return;
            }
            for (n = 0; n < methodArray.length; ++n) {
                boolean bl = true;
                if (string3.equals(methodArray[n].getName()) && methodArray[n].getParameterTypes().length == 1) {
                    Class<?> clazz = methodArray[n].getParameterTypes()[0];
                    Object[] objectArray = new Object[1];
                    if ("java.lang.Integer".equals(clazz.getName()) || "int".equals(clazz.getName())) {
                        try {
                            objectArray[0] = new Integer(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                        }
                    } else if ("java.lang.Boolean".equals(clazz.getName()) || "boolean".equals(clazz.getName())) {
                        objectArray[0] = new Boolean(string2);
                    } else if ("java.net.InetAddress".equals(clazz.getName())) {
                        try {
                            objectArray[0] = InetAddress.getByName(string2);
                        }
                        catch (UnknownHostException unknownHostException) {
                            IntrospectionUtils.d("Unable to resolve host name:" + string2);
                            bl = false;
                        }
                    } else if ("java.lang.Object".equals(clazz.getName())) {
                        objectArray[0] = string2;
                    } else {
                        IntrospectionUtils.d("Unknown type " + clazz.getName());
                    }
                    if (bl) {
                        methodArray[n].invoke(object, objectArray);
                        return;
                    }
                }
                if (!"setProperty".equals(methodArray[n].getName())) continue;
                method = methodArray[n];
            }
            if (method != null) {
                Object[] objectArray = new Object[]{string, string2};
                method.invoke(object, objectArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("IAE " + object + " " + string + " " + string2);
            illegalArgumentException.printStackTrace();
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static Object getProperty(Object object, String string) {
        String string2 = "get" + IntrospectionUtils.capitalize(string);
        try {
            Method[] methodArray = IntrospectionUtils.findMethods(object.getClass());
            Method method = null;
            for (int i = 0; i < methodArray.length; ++i) {
                Class<?>[] classArray = methodArray[i].getParameterTypes();
                if (string2.equals(methodArray[i].getName()) && classArray.length == 0) {
                    return methodArray[i].invoke(object, (Object[])null);
                }
                if ("getProperty".equals(methodArray[i].getName())) {
                    method = methodArray[i];
                }
                if (!"getAttribute".equals(methodArray[i].getName())) continue;
                method = methodArray[i];
            }
            if (method != null) {
                Object[] objectArray = new Object[]{string};
                method.invoke(object, objectArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("IAE " + object + " " + string);
            illegalArgumentException.printStackTrace();
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public static void setProperty(Object object, String string) {
        String string2 = "set" + IntrospectionUtils.capitalize(string);
        try {
            Method[] methodArray = IntrospectionUtils.findMethods(object.getClass());
            Object var4_5 = null;
            for (int i = 0; i < methodArray.length; ++i) {
                Class<?>[] classArray = methodArray[i].getParameterTypes();
                if (!string2.equals(methodArray[i].getName()) || classArray.length != 0) continue;
                methodArray[i].invoke(object, new Object[0]);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String replaceProperties(String string, Object object) {
        if (object instanceof Hashtable) {
            return IntrospectionUtils.replaceProperties(string, (Hashtable)object, null);
        }
        if (object instanceof PropertySource) {
            PropertySource[] propertySourceArray = new PropertySource[]{(PropertySource)object};
            return IntrospectionUtils.replaceProperties(string, null, propertySourceArray);
        }
        return string;
    }

    public static String replaceProperties(String string, Hashtable hashtable, PropertySource[] propertySourceArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while ((n = string.indexOf("$", n2)) >= 0) {
            if (n > 0) {
                stringBuffer.append(string.substring(n2, n));
            }
            if (n == string.length() - 1) {
                stringBuffer.append('$');
                n2 = n + 1;
                continue;
            }
            if (string.charAt(n + 1) != '{') {
                stringBuffer.append(string.charAt(n + 1));
                n2 = n + 2;
                continue;
            }
            int n3 = string.indexOf(125, n);
            if (n3 < 0) {
                stringBuffer.append(string.substring(n));
                n2 = string.length();
                continue;
            }
            String string2 = string.substring(n + 2, n3);
            Object object = null;
            if (hashtable != null) {
                object = (String)hashtable.get(string2);
            }
            if (object == null && propertySourceArray != null) {
                for (int i = 0; i < propertySourceArray.length && (object = propertySourceArray[i].getProperty(string2)) == null; ++i) {
                }
            }
            if (object == null) {
                object = "${" + string2 + "}";
            }
            stringBuffer.append((String)object);
            n2 = n3 + 1;
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    public static String unCapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    public static void addToClassPath(Vector vector, String string) {
        try {
            String[] stringArray = IntrospectionUtils.getFilesByExt(string, ".jar");
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    URL uRL = IntrospectionUtils.getURL(string, stringArray[i]);
                    if (uRL == null) continue;
                    vector.addElement(uRL);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void addToolsJar(Vector vector) {
        try {
            File file = new File(System.getProperty("java.home") + "/../lib/tools.jar");
            if (!file.exists() && (file = new File(System.getProperty("java.home") + "/lib/tools.jar")).exists()) {
                System.out.println("Detected strange java.home value " + System.getProperty("java.home") + ", it should point to jre");
            }
            URL uRL = new URL("file", "", file.getAbsolutePath());
            vector.addElement(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public static String[] getFilesByExt(String string, String string2) {
        File file = new File(string);
        String[] stringArray = null;
        final String string3 = string2;
        if (file.isDirectory()) {
            stringArray = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(string3);
                }
            });
        }
        return stringArray;
    }

    public static URL getURL(String string, String string2) {
        try {
            File file = new File(string);
            File file2 = new File(file, string2);
            Object object = file2.getCanonicalPath();
            if (file2.isDirectory()) {
                object = (String)object + "/";
            }
            if (!file2.exists()) {
                return null;
            }
            return new URL("file", "", (String)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void addJarsFromClassPath(Vector vector, String string) throws IOException, MalformedURLException {
        String string2 = System.getProperty("path.separator");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreTokens()) {
                URL uRL;
                File file = new File(stringTokenizer.nextToken());
                Object object = file.getCanonicalPath();
                if (file.isDirectory()) {
                    object = (String)object + "/";
                }
                if (vector.contains(uRL = new URL("file", "", (String)object))) continue;
                vector.addElement(uRL);
            }
        }
    }

    public static URL[] getClassPath(Vector vector) {
        URL[] uRLArray = new URL[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            uRLArray[i] = (URL)vector.elementAt(i);
        }
        return uRLArray;
    }

    public static URL[] getClassPath(String string, String string2, String string3, boolean bl) throws IOException, MalformedURLException {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        if (string != null) {
            object = IntrospectionUtils.getURL(string, "classes");
            if (object != null) {
                vector.addElement(object);
            }
            IntrospectionUtils.addToClassPath(vector, string);
        }
        if (string2 != null) {
            IntrospectionUtils.addJarsFromClassPath(vector, string2);
        }
        if (string3 != null) {
            object = System.getProperty(string3);
            IntrospectionUtils.addJarsFromClassPath(vector, (String)object);
        }
        if (bl) {
            IntrospectionUtils.addToolsJar(vector);
        }
        return IntrospectionUtils.getClassPath(vector);
    }

    public static boolean processArgs(Object object, String[] stringArray) throws Exception {
        String[] stringArray2 = null;
        if (null != IntrospectionUtils.findMethod(object.getClass(), "getOptions1", new Class[0])) {
            stringArray2 = (String[])IntrospectionUtils.callMethod0(object, "getOptions1");
        }
        if (stringArray2 == null) {
            stringArray2 = IntrospectionUtils.findBooleanSetters(object.getClass());
        }
        Hashtable hashtable = null;
        if (null != IntrospectionUtils.findMethod(object.getClass(), "getOptionAliases", new Class[0])) {
            hashtable = (Hashtable)IntrospectionUtils.callMethod0(object, "getOptionAliases");
        }
        return IntrospectionUtils.processArgs(object, stringArray, stringArray2, null, hashtable);
    }

    public static boolean processArgs(Object object, String[] stringArray, String[] stringArray2, String[] stringArray3, Hashtable hashtable) throws Exception {
        block0: for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            if (string.startsWith("-")) {
                string = string.substring(1);
            }
            if (hashtable != null && hashtable.get(string) != null) {
                string = (String)hashtable.get(string);
            }
            if (stringArray2 != null) {
                n = 0;
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!stringArray2[j].equalsIgnoreCase(string)) continue;
                    IntrospectionUtils.setProperty(object, stringArray2[j], "true");
                    n = 1;
                    break;
                }
                if (n != 0) continue;
            }
            if (stringArray3 != null) {
                for (n = 0; n < stringArray3.length; ++n) {
                    if (!stringArray3[n].equalsIgnoreCase(string)) continue;
                    if (++i >= stringArray.length) {
                        return false;
                    }
                    IntrospectionUtils.setProperty(object, string, stringArray[i]);
                    continue block0;
                }
                continue;
            }
            if (++i >= stringArray.length) {
                return false;
            }
            IntrospectionUtils.setProperty(object, string, stringArray[i]);
        }
        return true;
    }

    public static String[] findVoidSetters(Class clazz) {
        Method[] methodArray = IntrospectionUtils.findMethods(clazz);
        if (methodArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("set") || methodArray[i].getParameterTypes().length != 0) continue;
            String string = methodArray[i].getName().substring(3);
            vector.addElement(IntrospectionUtils.unCapitalize(string));
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static String[] findBooleanSetters(Class clazz) {
        Method[] methodArray = IntrospectionUtils.findMethods(clazz);
        if (methodArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("set") || methodArray[i].getParameterTypes().length != 1 || !"boolean".equalsIgnoreCase(methodArray[i].getParameterTypes()[0].getName())) continue;
            String string = methodArray[i].getName().substring(3);
            vector.addElement(IntrospectionUtils.unCapitalize(string));
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static void clear() {
        objectMethods.clear();
    }

    public static Method[] findMethods(Class clazz) {
        Method[] methodArray = (Method[])objectMethods.get(clazz);
        if (methodArray != null) {
            return methodArray;
        }
        methodArray = clazz.getMethods();
        objectMethods.put(clazz, methodArray);
        return methodArray;
    }

    public static Method findMethod(Class clazz, String string, Class[] classArray) {
        Method[] methodArray = IntrospectionUtils.findMethods(clazz);
        if (methodArray == null) {
            return null;
        }
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string)) continue;
            Class<?>[] classArray2 = methodArray[i].getParameterTypes();
            if (classArray2 == null && (classArray == null || classArray.length == 0)) {
                return methodArray[i];
            }
            if (classArray == null && (classArray2 == null || classArray2.length == 0)) {
                return methodArray[i];
            }
            if (classArray.length != classArray2.length) continue;
            boolean bl = true;
            for (int j = 0; j < classArray.length; ++j) {
                if (classArray[j] == classArray2[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return methodArray[i];
        }
        return null;
    }

    public static boolean hasHook(Object object, String string) {
        try {
            Method[] methodArray = IntrospectionUtils.findMethods(object.getClass());
            for (int i = 0; i < methodArray.length; ++i) {
                Class<?> clazz;
                Class<?> clazz2;
                if (!string.equals(methodArray[i].getName()) || "java.lang.Object".equals((clazz2 = (clazz = methodArray[i].getDeclaringClass()).getSuperclass()).getName())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static void callMain(Class clazz, String[] stringArray) throws Exception {
        Class[] classArray = new Class[]{stringArray.getClass()};
        Method method = clazz.getMethod("main", classArray);
        method.invoke((Object)clazz, new Object[]{stringArray});
    }

    public static Object callMethod1(Object object, String string, Object object2, String string2, ClassLoader classLoader) throws Exception {
        if (object == null || object2 == null) {
            IntrospectionUtils.d("Assert: Illegal params " + object + " " + object2);
        }
        Class[] classArray = new Class[]{string2 == null ? object2.getClass() : classLoader.loadClass(string2)};
        Method method = IntrospectionUtils.findMethod(object.getClass(), string, classArray);
        if (method == null) {
            throw new NoSuchMethodException(object.getClass().getName() + " " + string);
        }
        return method.invoke(object, object2);
    }

    public static Object callMethod0(Object object, String string) throws Exception {
        if (object == null) {
            IntrospectionUtils.d("Assert: Illegal params " + object);
            return null;
        }
        Class[] classArray = new Class[]{};
        Method method = IntrospectionUtils.findMethod(object.getClass(), string, classArray);
        if (method == null) {
            throw new NoSuchMethodException(object.getClass().getName() + " " + string);
        }
        return method.invoke(object, emptyArray);
    }

    public static Object callMethodN(Object object, String string, Object[] objectArray, Class[] classArray) throws Exception {
        Method method = null;
        method = IntrospectionUtils.findMethod(object.getClass(), string, classArray);
        if (method == null) {
            IntrospectionUtils.d("Can't find method " + string + " in " + object + " CLASS " + object.getClass());
            return null;
        }
        Object object2 = method.invoke(object, objectArray);
        return object2;
    }

    static void d(String string) {
        System.out.println("IntrospectionUtils: " + string);
    }

    public static interface AttributeHolder {
        public void setAttribute(String var1, Object var2);
    }

    public static interface PropertySource {
        public String getProperty(String var1);
    }
}

