/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler.modules;

import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.Registry;
import org.apache.commons.modeler.modules.ModelerSource;

public class MbeansDescriptorsSerSource
extends ModelerSource {
    Registry registry;
    String location;
    String type;
    Object source;
    List mbeans = new ArrayList();

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    @Override
    public List loadDescriptors(Registry registry, String string, String string2, Object object) throws Exception {
        this.setRegistry(registry);
        this.setLocation(string);
        this.setType(string2);
        this.setSource(object);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        long l = System.currentTimeMillis();
        try {
            InputStream inputStream = null;
            if (this.source instanceof URL) {
                inputStream = ((URL)this.source).openStream();
            }
            if (this.source instanceof InputStream) {
                inputStream = (InputStream)this.source;
            }
            if (inputStream == null) {
                throw new Exception("Can't process " + this.source);
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Thread.currentThread().setContextClassLoader(ManagedBean.class.getClassLoader());
            Object object = objectInputStream.readObject();
            ManagedBean[] managedBeanArray = (ManagedBean[])object;
            for (int i = 0; i < managedBeanArray.length; ++i) {
                this.mbeans.add(managedBeanArray[i]);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MbeansDescriptorsSerSource.class).error("Error reading descriptors " + this.source + " " + exception.toString(), (Throwable)exception);
            throw exception;
        }
        long l2 = System.currentTimeMillis();
        WMSLoggerFactory.getLogger(MbeansDescriptorsSerSource.class).info("Reading descriptors ( ser ) " + (l2 - l));
    }
}

