/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler.modules;

import com.wowza.util.NoMBean;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import org.apache.commons.modeler.AttributeInfo;
import org.apache.commons.modeler.ConstructorInfo;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.OperationInfo;
import org.apache.commons.modeler.ParameterInfo;
import org.apache.commons.modeler.Registry;
import org.apache.commons.modeler.modules.ModelerSource;

public class MbeansDescriptorsIntrospectionSource
extends ModelerSource {
    Registry registry;
    String location;
    String type;
    Object source;
    List mbeans = new ArrayList();
    static Hashtable specialMethods = new Hashtable();
    private static String[] strArray;
    private static ObjectName[] objNameArray;
    private static Class[] supportedTypes;

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    @Override
    public List loadDescriptors(Registry registry, String string, String string2, Object object) throws Exception {
        this.setRegistry(registry);
        this.setLocation(string);
        this.setType(string2);
        this.setSource(object);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        try {
            ManagedBean managedBean = this.createManagedBean(this.registry, null, (Class)this.source, this.type);
            if (managedBean == null) {
                return;
            }
            managedBean.setName(this.type);
            this.mbeans.add(managedBean);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MbeansDescriptorsIntrospectionSource.class).error("Error reading descriptors ", (Throwable)exception);
        }
    }

    private boolean supportedType(Class clazz) {
        for (int i = 0; i < supportedTypes.length; ++i) {
            if (clazz != supportedTypes[i]) continue;
            return true;
        }
        return this.isBeanCompatible(clazz);
    }

    protected boolean isBeanCompatible(Class clazz) {
        if (clazz.isArray() || clazz.isPrimitive()) {
            return false;
        }
        if (clazz.getName().startsWith("java.") || clazz.getName().startsWith("jakarta.")) {
            return false;
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        Class clazz2 = clazz.getSuperclass();
        return clazz2 == null || clazz2 == Object.class || clazz2 == Exception.class || clazz2 == Throwable.class || this.isBeanCompatible(clazz2);
    }

    private void initMethods(Class clazz, Method[] methodArray, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, Hashtable hashtable4) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(MbeansDescriptorsIntrospectionSource.class);
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            if (Modifier.isStatic(methodArray[i].getModifiers()) || !Modifier.isPublic(methodArray[i].getModifiers()) || methodArray[i].getDeclaringClass() == Object.class || methodArray[i].isAnnotationPresent(NoMBean.class)) continue;
            Class<?>[] classArray = methodArray[i].getParameterTypes();
            if (string.startsWith("get") && classArray.length == 0) {
                Class<?> clazz2 = methodArray[i].getReturnType();
                if (!this.supportedType(clazz2)) continue;
                string = MbeansDescriptorsIntrospectionSource.unCapitalize(string.substring(3));
                hashtable2.put(string, methodArray[i]);
                hashtable.put(string, methodArray[i]);
                continue;
            }
            if (string.startsWith("is") && classArray.length == 0) {
                Class<?> clazz3 = methodArray[i].getReturnType();
                if (Boolean.TYPE != clazz3) continue;
                string = MbeansDescriptorsIntrospectionSource.unCapitalize(string.substring(2));
                hashtable2.put(string, methodArray[i]);
                hashtable.put(string, methodArray[i]);
                continue;
            }
            if (string.startsWith("set") && classArray.length == 1) {
                if (!this.supportedType(classArray[0])) continue;
                string = MbeansDescriptorsIntrospectionSource.unCapitalize(string.substring(3));
                hashtable3.put(string, methodArray[i]);
                hashtable.put(string, methodArray[i]);
                continue;
            }
            if (classArray.length == 0) {
                if (specialMethods.get(methodArray[i].getName()) != null) continue;
                ArrayList<Method> arrayList = (ArrayList<Method>)hashtable4.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<Method>();
                    hashtable4.put(string, arrayList);
                }
                arrayList.add(methodArray[i]);
                continue;
            }
            boolean bl = true;
            for (int j = 0; j < classArray.length; ++j) {
                if (this.supportedType(classArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            ArrayList<Method> arrayList = (ArrayList<Method>)hashtable4.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<Method>();
                hashtable4.put(string, arrayList);
            }
            arrayList.add(methodArray[i]);
        }
    }

    public ManagedBean createManagedBean(Registry registry, String string, Class clazz, String string2) {
        ManagedBean managedBean = new ManagedBean();
        Method[] methodArray = null;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        methodArray = clazz.getMethods();
        this.initMethods(clazz, methodArray, hashtable, hashtable2, hashtable3, hashtable4);
        try {
            ParameterInfo parameterInfo;
            int n;
            Class<?>[] classArray;
            Serializable serializable;
            Object object;
            Iterator iterator;
            Object object2;
            Object object3;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object3 = (Constructor<?>[])enumeration.nextElement();
                object2 = new AttributeInfo();
                ((AttributeInfo)object2).setName((String)object3);
                iterator = (Method)hashtable2.get(object3);
                if (iterator != null) {
                    ((AttributeInfo)object2).setGetMethod(((Method)((Object)iterator)).getName());
                    object = ((Method)((Object)iterator)).getReturnType();
                    if (object != null) {
                        ((AttributeInfo)object2).setType(((Class)object).getName());
                    }
                }
                if ((object = (Method)hashtable3.get(object3)) != null) {
                    serializable = ((Method)object).getParameterTypes()[0];
                    if (serializable != null) {
                        ((AttributeInfo)object2).setType(((Class)serializable).getName());
                    }
                    ((AttributeInfo)object2).setSetMethod(((Method)object).getName());
                }
                ((AttributeInfo)object2).setDescription("Introspected attribute " + object3);
                if (iterator == null) {
                    ((AttributeInfo)object2).setReadable(false);
                }
                if (object == null) {
                    ((AttributeInfo)object2).setWriteable(false);
                }
                if (object == null && iterator == null) continue;
                managedBean.addAttribute((AttributeInfo)object2);
            }
            enumeration = hashtable4.keys();
            while (enumeration.hasMoreElements()) {
                object3 = (String)enumeration.nextElement();
                object2 = (List)hashtable4.get(object3);
                if (object2 == null) continue;
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (Method)iterator.next();
                    if (object != null && object3 != null) {
                        serializable = new OperationInfo();
                        ((OperationInfo)serializable).setName((String)object3);
                        ((OperationInfo)serializable).setReturnType(((Method)object).getReturnType().getName());
                        ((OperationInfo)serializable).setDescription("Introspected operation " + object3);
                        classArray = ((Method)object).getParameterTypes();
                        for (n = 0; n < classArray.length; ++n) {
                            parameterInfo = new ParameterInfo();
                            parameterInfo.setType(classArray[n].getName());
                            parameterInfo.setName("param" + n);
                            parameterInfo.setDescription("Introspected parameter param" + n);
                            ((OperationInfo)serializable).addParameter(parameterInfo);
                        }
                        managedBean.addOperation((OperationInfo)serializable);
                        continue;
                    }
                    WMSLoggerFactory.getLogger(MbeansDescriptorsIntrospectionSource.class).error("Null arg " + object3 + " " + (Method)object);
                }
            }
            object3 = clazz.getConstructors();
            for (int i = 0; i < ((Constructor<?>[])object3).length; ++i) {
                iterator = new ConstructorInfo();
                object = clazz.getName();
                int n2 = -1;
                n2 = ((String)object).lastIndexOf(46);
                if (n2 != -1) {
                    object = ((String)object).substring(n2 + 1);
                }
                ((ConstructorInfo)((Object)iterator)).setName((String)object);
                ((ConstructorInfo)((Object)iterator)).setDescription(object3[i].getName());
                classArray = object3[i].getParameterTypes();
                for (n = 0; n < classArray.length; ++n) {
                    parameterInfo = new ParameterInfo();
                    parameterInfo.setType(classArray[n].getName());
                    parameterInfo.setName("param" + n);
                    parameterInfo.setDescription("Introspected parameter param" + n);
                    ((ConstructorInfo)((Object)iterator)).addParameter(parameterInfo);
                }
                managedBean.addConstructor((ConstructorInfo)((Object)iterator));
            }
            managedBean.setName(string2);
            return managedBean;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String unCapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    static {
        specialMethods.put("preDeregister", "");
        specialMethods.put("postDeregister", "");
        strArray = new String[0];
        objNameArray = new ObjectName[0];
        supportedTypes = new Class[]{Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, String.class, strArray.getClass(), BigDecimal.class, BigInteger.class, ObjectName.class, objNameArray.getClass(), File.class};
    }
}

