/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import org.apache.commons.modeler.FeatureInfo;

public class AttributeInfo
extends FeatureInfo
implements Serializable {
    static final long serialVersionUID = -2511626862303972143L;
    protected transient ModelMBeanAttributeInfo info = null;
    protected String displayName = null;
    protected String getMethod = null;
    protected String setMethod = null;
    protected transient Method getMethodObj = null;
    protected transient Method setMethodObj = null;
    protected boolean readable = true;
    protected boolean writeable = true;
    protected boolean is = false;
    protected String type = null;
    protected String persist;
    protected String defaultStringValue;

    @Override
    public void setDescription(String string) {
        super.setDescription(string);
        this.info = null;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.info = null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getGetMethod() {
        return this.getMethod;
    }

    public void setGetMethod(String string) {
        this.getMethod = string;
        this.info = null;
    }

    public Method getGetMethodObj() {
        return this.getMethodObj;
    }

    public void setGetMethodObj(Method method) {
        this.getMethodObj = method;
    }

    public Method getSetMethodObj() {
        return this.setMethodObj;
    }

    public void setSetMethodObj(Method method) {
        this.setMethodObj = method;
    }

    public boolean isIs() {
        return this.is;
    }

    public void setIs(boolean bl) {
        this.is = bl;
        this.info = null;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public void setReadable(boolean bl) {
        this.readable = bl;
        this.info = null;
    }

    public String getSetMethod() {
        return this.setMethod;
    }

    public void setSetMethod(String string) {
        this.setMethod = string;
        this.info = null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
        this.info = null;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public void setWriteable(boolean bl) {
        this.writeable = bl;
        this.info = null;
    }

    public String getPersist() {
        return this.persist;
    }

    public void setPersist(String string) {
        this.persist = string;
    }

    public String getDefault() {
        return this.defaultStringValue;
    }

    public void setDefault(String string) {
        this.defaultStringValue = string;
    }

    public ModelMBeanAttributeInfo createAttributeInfo() {
        if (this.info != null) {
            return this.info;
        }
        if (this.getMethodObj != null || this.setMethodObj != null) {
            try {
                this.info = new ModelMBeanAttributeInfo(this.getName(), this.getDescription(), this.getMethodObj, this.setMethodObj);
                return this.info;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.info = new ModelMBeanAttributeInfo(this.getName(), this.getType(), this.getDescription(), this.isReadable(), this.isWriteable(), false);
        Descriptor descriptor = this.info.getDescriptor();
        if (this.getDisplayName() != null) {
            descriptor.setField("displayName", this.getDisplayName());
        }
        if (this.isReadable()) {
            if (this.getGetMethod() != null) {
                descriptor.setField("getMethod", this.getGetMethod());
            } else {
                descriptor.setField("getMethod", this.getMethodName(this.getName(), true, this.isIs()));
            }
        }
        if (this.isWriteable()) {
            if (this.getSetMethod() != null) {
                descriptor.setField("setMethod", this.getSetMethod());
            } else {
                descriptor.setField("setMethod", this.getMethodName(this.getName(), false, false));
            }
        }
        this.addFields(descriptor);
        this.info.setDescriptor(descriptor);
        return this.info;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("AttributeInfo[");
        stringBuffer.append("name=");
        stringBuffer.append(this.name);
        stringBuffer.append(", description=");
        stringBuffer.append(this.description);
        if (!this.readable) {
            stringBuffer.append(", readable=");
            stringBuffer.append(this.readable);
        }
        stringBuffer.append(", type=");
        stringBuffer.append(this.type);
        if (!this.writeable) {
            stringBuffer.append(", writeable=");
            stringBuffer.append(this.writeable);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private String getMethodName(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            if (bl2) {
                stringBuffer.append("is");
            } else {
                stringBuffer.append("get");
            }
        } else {
            stringBuffer.append("set");
        }
        stringBuffer.append(Character.toUpperCase(string.charAt(0)));
        stringBuffer.append(string.substring(1));
        return stringBuffer.toString();
    }
}

