/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.bootstrap;

import com.wowza.wms.bootstrap.BootstrapSystemTuningInfo;
import com.wowza.wms.bootstrap.BootstrapTuningConfig;

public class BootstrapTuningResult {
    private String heapSizeStr = "";
    private long heapSize = 0L;
    private String gcStr = "";
    private int gcNewSize = 0;

    public static BootstrapTuningResult calculateTuning(BootstrapSystemTuningInfo bootstrapSystemTuningInfo, BootstrapTuningConfig bootstrapTuningConfig) {
        BootstrapTuningResult bootstrapTuningResult = new BootstrapTuningResult();
        try {
            String string = bootstrapTuningConfig.heapSize;
            String string2 = bootstrapTuningConfig.garbageCollector;
            if (string == null) {
                string = "${com.wowza.wms.TuningHeapSizeDevelopment}";
            }
            if ("${com.wowza.wms.TuningHeapSizeProduction}".equals(string)) {
                double d = 0.7;
                long l = 20000L;
                bootstrapTuningResult.heapSize = bootstrapSystemTuningInfo.getPhysicalMemory() >= (long)((int)((double)l / d)) ? l : (long)((int)((double)bootstrapSystemTuningInfo.getPhysicalMemory() * d));
                if (!bootstrapSystemTuningInfo.is64Bit()) {
                    if (bootstrapSystemTuningInfo.isWindows() && bootstrapTuningResult.heapSize > 1200L) {
                        bootstrapTuningResult.heapSize = 1200L;
                    } else if (bootstrapTuningResult.heapSize > 1500L) {
                        bootstrapTuningResult.heapSize = 1500L;
                    }
                }
                bootstrapTuningResult.heapSizeStr = "-Xmx" + bootstrapTuningResult.heapSize + "M";
            } else if ("${com.wowza.wms.TuningHeapSizeDevelopment}".equals(string)) {
                double d = 0.4;
                long l = 4000L;
                bootstrapTuningResult.heapSize = bootstrapSystemTuningInfo.getPhysicalMemory() >= (long)((int)((double)l / d)) ? l : (long)((int)((double)bootstrapSystemTuningInfo.getPhysicalMemory() * d));
                if (!bootstrapSystemTuningInfo.is64Bit()) {
                    if (bootstrapSystemTuningInfo.isWindows() && bootstrapTuningResult.heapSize > 1200L) {
                        bootstrapTuningResult.heapSize = 1200L;
                    } else if (bootstrapTuningResult.heapSize > 1500L) {
                        bootstrapTuningResult.heapSize = 1500L;
                    }
                }
                bootstrapTuningResult.heapSizeStr = "-Xmx" + bootstrapTuningResult.heapSize + "M";
            } else if (string.startsWith("$")) {
                bootstrapTuningResult.heapSize = 768L;
                bootstrapTuningResult.heapSizeStr = "-Xmx" + bootstrapTuningResult.heapSize + "M";
            } else {
                long l = 0L;
                if (string.startsWith("-Xmx")) {
                    string = string.substring(4);
                }
                if (string.endsWith("M") || string.endsWith("m")) {
                    l = 1L;
                } else if (string.endsWith("G") || string.endsWith("g")) {
                    l = 1024L;
                } else if (string.endsWith("T") || string.endsWith("t")) {
                    l = 0x100000L;
                }
                String string3 = string;
                if (l >= 1L) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                try {
                    bootstrapTuningResult.heapSize = Long.parseLong(string3);
                }
                catch (Exception exception) {
                    bootstrapTuningResult.heapSize = 512L;
                }
                if (l >= 1L) {
                    bootstrapTuningResult.heapSize *= l;
                }
                bootstrapTuningResult.heapSizeStr = "-Xmx" + string;
            }
            if (string2 != null && !"${com.wowza.wms.TuningGarbageCollectorDefault}".equals(string2)) {
                if ("${com.wowza.wms.TuningGarbageCollectorConcurrentDefault}".equals(string2)) {
                    bootstrapTuningResult.gcNewSize = 512;
                    bootstrapTuningResult.gcNewSize = bootstrapTuningResult.heapSize >= 5000L ? 512 : (bootstrapTuningResult.heapSize >= 3000L ? 256 : 128);
                    bootstrapTuningResult.gcStr = "-XX:+UseConcMarkSweepGC -XX:+UseParNewGC -XX:NewSize=" + bootstrapTuningResult.gcNewSize + "m";
                } else if ("${com.wowza.wms.TuningGarbageCollectorG1Legacy}".equals(string2)) {
                    bootstrapTuningResult.gcStr = "-XX:+UseG1GC -XX:MaxGCPauseMillis=100 -XX:SurvivorRatio=1";
                } else if ("${com.wowza.wms.TuningGarbageCollectorG1Default}".equals(string2)) {
                    bootstrapTuningResult.gcStr = "-XX:+UseG1GC -XX:MaxGCPauseMillis=200 -XX:ParallelGCThreads=4 -XX:ConcGCThreads=2 -XX:InitiatingHeapOccupancyPercent=70";
                } else if ("${com.wowza.wms.TuningGarbageCollectorZGCDefault}".equals(string2)) {
                    bootstrapTuningResult.gcStr = "-XX:+UseZGC -XX:+ZGenerational -XX:MaxGCPauseMillis=200 -XX:ParallelGCThreads=4 -XX:ConcGCThreads=2 -XX:InitiatingHeapOccupancyPercent=70";
                } else if (!string2.startsWith("$")) {
                    bootstrapTuningResult.gcStr = string2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bootstrapTuningResult;
    }

    public String getHeapSizeStr() {
        return this.heapSizeStr;
    }

    public long getHeapSize() {
        return this.heapSize;
    }

    public String getGCStr() {
        return this.gcStr;
    }

    public int getGCNewSize() {
        return this.gcNewSize;
    }
}

