/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.bootstrap;

import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.bootstrap.BootstrapSystemTuningInfo;
import com.wowza.wms.bootstrap.BootstrapTuningConfig;
import com.wowza.wms.bootstrap.BootstrapTuningResult;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class BootstrapTuningHandler {
    public static final String VAR_HEAPSIZE_PRODUCTION = "${com.wowza.wms.TuningHeapSizeProduction}";
    public static final String VAR_HEAPSIZE_DEVELOPMENT = "${com.wowza.wms.TuningHeapSizeDevelopment}";
    public static final String VAR_GC_DEFAULT = "${com.wowza.wms.TuningGarbageCollectorDefault}";
    public static final String VAR_GC_CONCURRENT_DEFAULT = "${com.wowza.wms.TuningGarbageCollectorConcurrentDefault}";
    public static final String VAR_GC_G1_DEFAULT = "${com.wowza.wms.TuningGarbageCollectorG1Default}";
    public static final String VAR_GC_G1_LEGACY = "${com.wowza.wms.TuningGarbageCollectorG1Legacy}";
    public static final String VAR_GC_ZGC_DEFAULT = "${com.wowza.wms.TuningGarbageCollectorZGCDefault}";
    public static final String VAR_GENERAL_DATETIME = "${com.wowza.wms.StartupDateTime}";
    public static final int MAX_HEAPSIZE_64BIT = 20000;
    public static final int MAX_HEAPSIZE_64BIT_DEVELOPMENT = 4000;
    public static final int MAX_HEAPSIZE_32BIT = 1500;
    public static final int MAX_HEAPSIZE_32BIT_WINDOWS = 1200;
    public static final int MIN_HEAPSIZE = 512;

    public static void outputTuningCommandLine() {
        BootstrapTuningResult bootstrapTuningResult;
        BootstrapSystemTuningInfo bootstrapSystemTuningInfo;
        Object object = "";
        Bootstrap.resolveServerHome();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-mm-dd-hh-mm-ss");
        Date date = new Date();
        BootstrapTuningConfig bootstrapTuningConfig = Bootstrap.getTuningConfig();
        if (bootstrapTuningConfig != null && (bootstrapSystemTuningInfo = BootstrapSystemTuningInfo.getSystemTuningInfo()) != null && (bootstrapTuningResult = BootstrapTuningResult.calculateTuning(bootstrapSystemTuningInfo, bootstrapTuningConfig)) != null) {
            String string = bootstrapTuningResult.getHeapSizeStr();
            String string2 = bootstrapTuningResult.getGCStr();
            if (string.length() > 0) {
                object = (String)object + " " + string;
            }
            if (string2.length() > 0) {
                object = (String)object + " " + string2;
            }
            if (bootstrapTuningConfig.vmOptions.size() > 0) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("com.wowza.wms.AppHome", Bootstrap.getServerHome(1));
                hashMap.put("com.wowza.wms.ConfigHome", Bootstrap.getServerHome(2));
                hashMap.put("com.wowza.wms.StartupDateTime", simpleDateFormat.format(date));
                for (String string3 : bootstrapTuningConfig.vmOptions) {
                    string3 = Bootstrap.expandEnvironmentVariables(string3, hashMap);
                    object = (String)object + " " + string3;
                }
            }
        }
        System.out.print((String)object);
    }
}

