/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.bootstrap;

import com.wowza.wms.bootstrap.BootstrapConsoleLogger;
import com.wowza.wms.bootstrap.BootstrapTuningConfig;
import com.wowza.wms.bootstrap.BootstrapTuningHandler;
import com.wowza.wms.bootstrap.IWowzaServerTestRunner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.SystemUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Bootstrap {
    public static final int APPHOME = 1;
    public static final int CONFIGHOME = 2;
    public static final String SYSTEM_PROPERTY_ROOTPATH = "com.wowza.wms.ClearCasterRootPath";
    public static final String SYSTEM_PROPERTY_STORAGEPATH = "com.wowza.wms.ClearCasterStoragePath";
    public static final String SYSTEM_PROPERTY_APPHOMEPATH = "com.wowza.wms.ClearCasterAppHome";
    public static final String SYSTEM_PROPERTY_CONFIGHOMEPATH = "com.wowza.wms.ClearCasterConfigHome";
    public static final String SYSTEM_PROPERTY_ENCODERNAME = "com.wowza.wms.ClearCasterEncoderName";
    public static final String NATIVELIBFOLDER = "lib-native";
    public static ClassLoader loader = null;
    private static final String CRLF = "\r\n";
    private static final String HTTP_PROTOCOL = "HTTP/1.1";
    private static final String[] hexadecimal = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    public static final String DATEFORMAT = "EEE, dd MMM yyyy HH:mm:ss";

    public static void main(String[] stringArray) {
        Bootstrap.resolveServerHome();
        if (stringArray.length > 0) {
            if (stringArray[0].equals("start")) {
                Bootstrap.startServer();
            } else if (stringArray[0].equals("stop")) {
                Bootstrap.stopServer();
            } else if (stringArray[0].equals("runTest")) {
                Bootstrap.runTest(stringArray[1]);
            } else if (stringArray[0].equals("runTestCL")) {
                Bootstrap.runTestCL(stringArray);
            } else if (stringArray[0].equals("runJUnit")) {
                Bootstrap.runJUnit(stringArray);
            } else if (stringArray[0].equals("startDebugger")) {
                Bootstrap.startDebugger();
            } else if (stringArray[0].equals("stopDebugger")) {
                Bootstrap.stopDebugger();
            } else if (stringArray[0].equals("outputTuningCommandLine")) {
                BootstrapTuningHandler.outputTuningCommandLine();
            } else if (stringArray[0].equals("outputLDPRELOAD")) {
                Bootstrap.outputLDPRELOAD();
            } else if (stringArray[0].equals("tailLogFile")) {
                Bootstrap.tailLogFile();
            } else if (stringArray[0].equals("startLicenseUpdateServer")) {
                Bootstrap.startLicenseUpdateServer();
            }
        }
    }

    public static void outputLDPRELOAD() {
        Object object = "";
        try {
            String string;
            if (Bootstrap.isNativeLinux() && Bootstrap.getNativeArchitecture().equals("64") && new File(string = System.getProperty("java.home") + "/lib/amd64/libjsig.so").exists()) {
                object = string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.print((String)object);
    }

    public static void tailLogFile() {
        BootstrapConsoleLogger bootstrapConsoleLogger = new BootstrapConsoleLogger();
        String string = Bootstrap.getServerHome(1);
        String string2 = string + "/conf/log4j.properties";
        bootstrapConsoleLogger.setPropertiesPath(string2);
        bootstrapConsoleLogger.init();
        while (true) {
            try {
                bootstrapConsoleLogger.run();
            }
            catch (Exception exception) {
                System.out.println("*** ERROR: Bootstrap.tailLogFile[" + string2 + "]: " + exception.toString());
                break;
            }
            try {
                Thread.currentThread();
                Thread.sleep(750L);
            }
            catch (Exception exception) {}
        }
    }

    private static void doWait() {
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isRunModeService() {
        boolean bl = false;
        String string = System.getProperty("com.wowza.wms.runmode");
        if (string != null && string.equals("service")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isNativeWindows() {
        boolean bl;
        block0: {
            bl = false;
            String string = Bootstrap.getNativeOS();
            if (string == null || !"win".equals(string)) break block0;
            bl = true;
        }
        return bl;
    }

    public static boolean isNativeLinux() {
        boolean bl;
        block0: {
            bl = false;
            String string = Bootstrap.getNativeOS();
            if (string == null || !"linux".equals(string)) break block0;
            bl = true;
        }
        return bl;
    }

    public static boolean isNativeOSX() {
        boolean bl;
        block0: {
            bl = false;
            String string = Bootstrap.getNativeOS();
            if (string == null || !"osx".equals(string)) break block0;
            bl = true;
        }
        return bl;
    }

    private static String expandEnvironmentVariables(String object) {
        Pattern pattern = Pattern.compile("\\$\\{[^}]*\\}");
        Matcher matcher = pattern.matcher((CharSequence)object);
        while (matcher.find()) {
            String string = matcher.group().substring(2, matcher.group().length() - 1);
            object = ((String)object).substring(0, matcher.start()) + System.getProperty(string) + ((String)object).substring(matcher.end());
        }
        return object;
    }

    private static void classLoaderLoadFolder(String string, List list) {
        block7: {
            try {
                File file = new File(string);
                if (!file.exists()) break block7;
                try {
                    list.add(file.toURL());
                }
                catch (Exception exception) {
                    System.out.println("Error loading folder [" + file + "]: " + exception);
                    exception.printStackTrace();
                    Bootstrap.doWait();
                }
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    String string2 = file2.toString();
                    if (file2.isDirectory() || !string2.toLowerCase().endsWith(".jar") && !string2.toLowerCase().endsWith(".nar") && !string2.toLowerCase().endsWith(".xml") && !string2.toLowerCase().endsWith(".properties") && !string2.toLowerCase().endsWith(".class")) continue;
                    try {
                        list.add(file2.toURL());
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("Error loading jar file [" + file2 + "]: " + exception);
                        exception.printStackTrace();
                        Bootstrap.doWait();
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Error loading folder [" + string + "]: " + exception);
                exception.printStackTrace();
                Bootstrap.doWait();
            }
        }
    }

    private static void classLoaderLoadInc(String string, String string2, List list) {
        block9: {
            try {
                File file = new File(string);
                if (!file.exists()) break block9;
                BufferedReader bufferedReader = null;
                try {
                    Object object;
                    bufferedReader = new BufferedReader(new FileReader(file));
                    while ((object = bufferedReader.readLine()) != null) {
                        if (((String)(object = ((String)object).trim())).startsWith("#") || ((String)object).length() == 0) continue;
                        if (!((String)object).startsWith("/")) {
                            object = string2 + "/" + (String)object;
                        }
                        System.out.println("Class loader loading folder: " + (String)object);
                        Bootstrap.classLoaderLoadFolder((String)object, list);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Error loading classloader.inc [" + string + "][read]: " + exception);
                }
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    bufferedReader = null;
                }
                catch (Exception exception) {
                    System.out.println("Error loading classloader.inc [" + string + "][close]: " + exception);
                }
            }
            catch (Exception exception) {
                System.out.println("Error loading classloader.inc [" + string + "]: " + exception);
                exception.printStackTrace();
                Bootstrap.doWait();
            }
        }
    }

    private static ClassLoader createClassLoader(Map map) {
        Object object = null;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        try {
            Object object2;
            File[] fileArray;
            Object object3;
            File[] fileArray2;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            String string = Bootstrap.getServerHome(1);
            String string2 = (string == null ? "" : string) + File.separatorChar + "lib" + File.separatorChar;
            String string3 = (string == null ? "" : string) + File.separatorChar + "lib-license" + File.separatorChar;
            String string4 = string2 + "/classloader.inc";
            boolean bl = new File(string2).exists();
            if (bl) {
                Bootstrap.classLoaderLoadInc(string4, string2, arrayList);
                Bootstrap.classLoaderLoadFolder(string2, arrayList);
                Bootstrap.classLoaderLoadFolder(string3, arrayList);
            } else {
                object9 = Bootstrap.getConfigURL();
                object8 = object9;
                object8 = object8.indexOf("?") >= 0 ? (String)object8 + "&" : (String)object8 + "?";
                object8 = (String)object8 + "context=server&filename=" + Bootstrap.encodeValue("conf/LibFolder.xml");
                try {
                    object7 = DocumentBuilderFactory.newInstance();
                    object6 = ((DocumentBuilderFactory)object7).newDocumentBuilder();
                    object5 = ((DocumentBuilder)object6).parse((String)object8);
                    object4 = Bootstrap.newXPathFactory();
                    fileArray2 = ((XPathFactory)object4).newXPath();
                    if (object5 != null) {
                        Element element = object5.getDocumentElement();
                        object3 = "/Root/LibFolder/Lib";
                        fileArray = fileArray2.compile((String)object3);
                        NodeList nodeList = (NodeList)fileArray.evaluate(element, XPathConstants.NODESET);
                        if (nodeList != null) {
                            for (int i = 0; i < nodeList.getLength(); ++i) {
                                object2 = nodeList.item(i);
                                String string5 = Bootstrap.getNodeValue((Node)object2);
                                arrayList.add(new URL(string5));
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    System.out.println("Error parsing LibFolder.xml: " + exception.toString());
                    exception.printStackTrace();
                    Bootstrap.doWait();
                }
            }
            object9 = (Map)map.get("VHosts");
            if (object9 != null) {
                object8 = object9.keySet().iterator();
                while (object8.hasNext()) {
                    object7 = (Map)object9.get(object8.next());
                    object6 = Bootstrap.expandEnvironmentVariables((String)object7.get("ConfigDir"));
                    object5 = (String)object6 + File.separatorChar + "applications";
                    object4 = new File((String)object5);
                    if (((File)object4).exists() && ((File)object4).isDirectory()) {
                        fileArray2 = ((File)object4).listFiles();
                        for (int i = 0; i < fileArray2.length; ++i) {
                            object3 = fileArray2[i];
                            if (!((File)object3).isDirectory()) continue;
                            fileArray = ((File)object3).listFiles();
                            for (int j = 0; j < fileArray.length; ++j) {
                                File file = fileArray[j];
                                object2 = file.toString();
                                if (file.isDirectory() || !((String)object2).toLowerCase().endsWith(".jar") && !((String)object2).toLowerCase().endsWith(".nar") && !((String)object2).toLowerCase().endsWith(".xml") && !((String)object2).toLowerCase().endsWith(".properties") && !((String)object2).toLowerCase().endsWith(".class")) continue;
                                arrayList.add(file.toURL());
                            }
                        }
                        continue;
                    }
                    System.out.println("Error: applications folder missing: " + (File)object4);
                }
            }
            object8 = arrayList.toArray(new URL[arrayList.size()]);
            object7 = Thread.currentThread().getContextClassLoader();
            object6 = new BootstrapURLClassLoader((URL[])object8, (ClassLoader)object7);
            Thread.currentThread().setContextClassLoader((ClassLoader)object6);
            object = object6;
        }
        catch (Exception exception) {
            System.out.println("Error creating class loader: " + exception);
            exception.printStackTrace();
            Bootstrap.doWait();
        }
        return object;
    }

    public static boolean loadJar(File file) {
        boolean bl;
        block8: {
            bl = false;
            if (!file.exists() || !(loader instanceof BootstrapURLClassLoader)) break block8;
            BootstrapURLClassLoader bootstrapURLClassLoader = (BootstrapURLClassLoader)loader;
            URL uRL = null;
            try {
                uRL = file.toURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uRL != null) {
                URL[] uRLArray = bootstrapURLClassLoader.getURLs();
                boolean bl2 = false;
                if (uRLArray != null) {
                    for (int i = 0; i < uRLArray.length; ++i) {
                        if (!uRLArray[i].toString().equals(uRL.toString())) continue;
                        bl2 = false;
                        break;
                    }
                }
                if (!bl2) {
                    try {
                        bootstrapURLClassLoader.addURL(uRL);
                    }
                    catch (Exception exception) {
                        break block8;
                    }
                }
                bl = true;
            }
        }
        return bl;
    }

    public static Class findClass(String string) {
        Class<?> clazz = null;
        try {
            if (loader != null) {
                clazz = loader.loadClass(string);
            } else {
                System.out.println("Bootstrap.findClass (" + string + "): Class loader is null");
            }
        }
        catch (Exception exception) {
            System.out.println("Bootstrap.findClass (" + string + "): " + exception);
            exception.printStackTrace();
        }
        return clazz;
    }

    private static void startServer() {
        try {
            Map map = Bootstrap.getServerInfo();
            if (map != null) {
                loader = Bootstrap.createClassLoader(map);
                String string = "com.wowza.wms.server.Server";
                Class<?> clazz = loader.loadClass(string);
                Method method = clazz.getMethod("start", new Class[0]);
                method.invoke(null, (Object[])null);
            }
        }
        catch (Exception exception) {
            System.out.println("Error starting: " + exception);
            exception.printStackTrace();
            Bootstrap.doWait();
        }
    }

    private static void startLicenseUpdateServer() {
        try {
            Map map = Bootstrap.getServerInfo();
            if (map != null) {
                loader = Bootstrap.createClassLoader(map);
                String string = "com.wowza.wms.standalone.rest.LicenseUpdateServer";
                Class<?> clazz = loader.loadClass(string);
                Method method = clazz.getMethod("start", new Class[0]);
                method.invoke(null, (Object[])null);
            }
        }
        catch (Exception exception) {
            System.out.println("Error starting LicenseUpdateServer: " + exception);
            exception.printStackTrace();
            Bootstrap.doWait();
        }
    }

    private static void startDebugger() {
        try {
            Map map = Bootstrap.getServerInfo();
            if (map != null) {
                ClassLoader classLoader = Bootstrap.createClassLoader(map);
                String string = "com.wowza.wms.debugger.DebugServer";
                Class<?> clazz = classLoader.loadClass(string);
                Method method = clazz.getMethod("startServer", new Class[0]);
                method.invoke(null, (Object[])null);
            }
        }
        catch (Exception exception) {
            System.out.println("Error starting: " + exception);
            exception.printStackTrace();
            Bootstrap.doWait();
        }
    }

    private static void stopDebugger() {
    }

    private static String getServerGUID() {
        String string = null;
        BufferedReader bufferedReader = null;
        if (string == null) {
            Object object = Bootstrap.getServerHome(2);
            if (Bootstrap.isClearCaster()) {
                object = Bootstrap.getClearCasterStorageHome();
            }
            object = (String)object + File.separatorChar + "conf" + File.separatorChar + "Server.guid";
            try {
                File file = new File((String)object);
                if (file.exists()) {
                    String string2;
                    bufferedReader = new BufferedReader(new FileReader(file));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if ((string2 = string2.trim()).startsWith("#") || string2.length() == 0) continue;
                        string = string2;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Server.getServerGUID: File error[" + (String)object + "]: " + exception.toString());
            }
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            bufferedReader = null;
        }
        catch (Exception exception) {
            System.out.println("Server.getServerGUID: Close error: " + exception.toString());
        }
        return string;
    }

    private static String getAdminGUID() {
        String string = null;
        BufferedReader bufferedReader = null;
        if (string == null) {
            Object object = Bootstrap.getServerHome(2);
            if (Bootstrap.isClearCaster()) {
                object = Bootstrap.getClearCasterStorageHome();
            }
            object = (String)object + File.separatorChar + "conf" + File.separatorChar + "Admin.guid";
            try {
                File file = new File((String)object);
                if (file.exists()) {
                    String string2;
                    bufferedReader = new BufferedReader(new FileReader(file));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if ((string2 = string2.trim()).startsWith("#") || string2.length() == 0) continue;
                        string = string2;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Server.getAdminGUID: File error[" + (String)object + "]: " + exception.toString());
            }
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            bufferedReader = null;
        }
        catch (Exception exception) {
            System.out.println("Server.getAdminGUID: Close error: " + exception.toString());
        }
        return string;
    }

    private static byte[] getServerCommandEncryptionKey(String string, String string2) {
        byte[] byArray = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray2 = messageDigest.digest((string + ":" + string2).getBytes("UTF-8"));
            if (byArray2 != null) {
                byArray = new byte[16];
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    private static String signServerCommand(String string) {
        String string2 = null;
        byte[] byArray = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byArray = messageDigest.digest(string.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byArray != null) {
            string2 = Bootstrap.encodeHexString(byArray);
        }
        return string2;
    }

    public static String encodeHexString(byte[] byArray) {
        Object object = "";
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xF;
            int n2 = (byArray[i] & 0xF0) >> 4;
            object = (String)object + hexadecimal[n2];
            object = (String)object + hexadecimal[n];
        }
        return object;
    }

    public static String httpDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFORMAT, Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date()) + "GMT";
    }

    private static byte[] encryptMessageServerCommand(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKeySpec);
            byArray3 = cipher.doFinal(byArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray3;
    }

    private static boolean sendServerCommand(String string, byte[] byArray) {
        boolean bl = true;
        try {
            Map map = Bootstrap.getServerInfo();
            String string2 = Bootstrap.getAdminGUID();
            if (string2 != null && map != null) {
                byte[] byArray2;
                String string3 = "GET";
                String string4 = "/ws-admin/current/server?action=" + string;
                String string5 = HTTP_PROTOCOL;
                String string6 = Bootstrap.httpDate();
                long l = byArray == null ? 0 : byArray.length;
                String string7 = string3 + "\n" + string4 + "\n" + string5 + "\n" + string6 + "\n" + l + "\n" + string2;
                String string8 = Bootstrap.signServerCommand(string7);
                byte[] byArray3 = Bootstrap.getServerCommandEncryptionKey(string2, string8);
                InetAddress inetAddress = (InetAddress)map.get("HostPort.address");
                int n = (Integer)map.get("HostPort.port");
                Socket socket = inetAddress == null ? new Socket("127.0.0.1", n) : new Socket(inetAddress, n);
                OutputStream outputStream = socket.getOutputStream();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string3 + " " + string4 + " " + string5 + CRLF);
                stringBuffer.append("Date: " + string6 + CRLF);
                stringBuffer.append("Content-Length: " + l + CRLF);
                stringBuffer.append("Authorization: WOWZA " + string8 + CRLF);
                stringBuffer.append(CRLF);
                byte[] byArray4 = stringBuffer.toString().getBytes();
                outputStream.write(byArray4);
                if (byArray != null && (byArray2 = Bootstrap.encryptMessageServerCommand(byArray3, byArray)) != null) {
                    outputStream.write(byArray2);
                }
                outputStream.flush();
                outputStream.close();
                socket.close();
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static void stopServer() {
        Bootstrap.sendServerCommand("serverstop", null);
    }

    public static void restartServer() {
    }

    public static XPathFactory newXPathFactory() {
        XPathFactory xPathFactory = null;
        if (xPathFactory == null) {
            try {
                xPathFactory = XPathFactory.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (xPathFactory == null) {
            System.out.println("Error: Can't find XPathFactory");
        }
        return xPathFactory;
    }

    public static String encodeValue(String string) {
        String string2 = string;
        try {
            string2 = URLEncoder.encode(string2, "UTF-8");
        }
        catch (Exception exception) {
            System.out.println("encodeValue (" + string + "): " + exception.toString());
            string2 = string;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public static String expandEnvironmentVariables(String object, Map map) {
        if (object == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\$\\{[^}]*\\}");
        Matcher matcher = pattern.matcher((CharSequence)object);
        ArrayList<ReplaceItem> arrayList = new ArrayList<ReplaceItem>();
        while (matcher.find()) {
            void object2;
            void var6_11;
            String string = matcher.group().substring(2, matcher.group().length() - 1);
            Object var6_7 = null;
            if (map == null) {
                String string2 = System.getProperty(string);
            } else if (map.containsKey(string)) {
                String string3 = (String)map.get(string);
            } else {
                String string4 = System.getProperty(string);
            }
            if (var6_11 == null) {
                String string5 = "${" + (String)string + "}";
            }
            arrayList.add(0, new ReplaceItem(matcher.start(), matcher.end(), (String)object2));
        }
        for (ReplaceItem replaceItem : arrayList) {
            object = ((String)object).substring(0, replaceItem.start) + replaceItem.newValue + ((String)object).substring(replaceItem.end);
        }
        return object;
    }

    public static BootstrapTuningConfig getTuningConfig() {
        BootstrapTuningConfig bootstrapTuningConfig = new BootstrapTuningConfig();
        String string = Bootstrap.getTuneXMLURL();
        if (string != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(string);
                XPathFactory xPathFactory = Bootstrap.newXPathFactory();
                XPath xPath = xPathFactory.newXPath();
                if (document != null) {
                    XPathExpression xPathExpression;
                    NodeList nodeList;
                    Element element = document.getDocumentElement();
                    bootstrapTuningConfig.heapSize = Bootstrap.getNodeValue(xPath, "/Root/Tune/HeapSize", element, null);
                    bootstrapTuningConfig.garbageCollector = Bootstrap.getNodeValue(xPath, "/Root/Tune/GarbageCollector", element, null);
                    if (bootstrapTuningConfig.heapSize != null) {
                        bootstrapTuningConfig.heapSize = bootstrapTuningConfig.heapSize.trim();
                        if (bootstrapTuningConfig.heapSize.length() <= 0) {
                            bootstrapTuningConfig.heapSize = null;
                        }
                    }
                    if (bootstrapTuningConfig.garbageCollector != null) {
                        bootstrapTuningConfig.garbageCollector = bootstrapTuningConfig.garbageCollector.trim();
                        if (bootstrapTuningConfig.garbageCollector.length() <= 0) {
                            bootstrapTuningConfig.garbageCollector = null;
                        }
                    }
                    if ((nodeList = (NodeList)(xPathExpression = xPath.compile("/Root/Tune/VMOptions/VMOption")).evaluate(element, XPathConstants.NODESET)) != null) {
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            Node node = nodeList.item(i);
                            Element element2 = (Element)node;
                            String string2 = Bootstrap.getNodeValue(element2);
                            if (string2 == null || (string2 = string2.trim()).length() <= 0) continue;
                            bootstrapTuningConfig.vmOptions.add(string2);
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Error parsing Tune.xml[" + string + "]: " + exception.toString());
            }
        }
        return bootstrapTuningConfig;
    }

    private static Map getServerInfo() {
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Node node;
        Node node2;
        Object object7;
        XPathExpression xPathExpression;
        String string2;
        Element element;
        XPath xPath;
        XPathFactory xPathFactory;
        Document document;
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory;
        String string3;
        HashMap<String, Serializable> hashMap = null;
        String string4 = Bootstrap.getServerXMLURL();
        if (string4 == null) {
            System.out.println("ERROR: Server.xml not found: exiting.");
            System.exit(1);
        }
        if ((string3 = Bootstrap.getVHostsXMLURL()) == null) {
            System.out.println("ERROR: VHosts.xml not found: exiting.");
            System.exit(1);
        }
        hashMap = new HashMap<String, Serializable>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        hashMap.put("VHosts", hashMap2);
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(string4);
            xPathFactory = Bootstrap.newXPathFactory();
            xPath = xPathFactory.newXPath();
            if (document != null) {
                element = document.getDocumentElement();
                string2 = "/Root/Server/CommandInterface/HostPort";
                xPathExpression = xPath.compile(string2);
                object7 = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
                if (object7 != null) {
                    Node node3 = Bootstrap.getNodeByTagName((Element)object7, "DomainName");
                    node2 = Bootstrap.getNodeByTagName((Element)object7, "IpAddress");
                    node = Bootstrap.getNodeByTagName((Element)object7, "Port");
                    if ((node3 != null || node2 != null) && node != null) {
                        object6 = Bootstrap.getNodeValue(node3);
                        object5 = Bootstrap.getNodeValue(node2);
                        object4 = Bootstrap.getNodeValue(node);
                        object3 = null;
                        string = null;
                        if (node2 != null) {
                            if (((String)object5).equals("*")) {
                                object3 = null;
                            } else {
                                object2 = ((String)object5).split("[.]");
                                if (((String[])object2).length == 4) {
                                    object = new byte[((String[])object2).length];
                                    for (int i = 0; i < ((String[])object2).length; ++i) {
                                        object[i] = (byte)Integer.parseInt(object2[i]);
                                    }
                                    object3 = InetAddress.getByAddress((byte[])object);
                                } else {
                                    System.out.println("setIpAddress: invalid ipAddress: " + (String)object5);
                                }
                            }
                        } else if (node3 != null) {
                            object3 = ((String)object6).equals("*") ? null : InetAddress.getByName((String)object6);
                        }
                        hashMap.put("HostPort.address", (Serializable)object3);
                        hashMap.put("HostPort.port", new Integer(Integer.parseInt((String)object4)));
                    } else {
                        System.out.println("Error parsing Server.xml: <DomainName> or <IpAddress> and <Port> required");
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error parsing Server.xml: <DomainName> or <IpAddress> and <Port> required: " + exception.toString());
            exception.printStackTrace();
            Bootstrap.doWait();
        }
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(string3);
            xPathFactory = Bootstrap.newXPathFactory();
            xPath = xPathFactory.newXPath();
            if (document != null) {
                element = document.getDocumentElement();
                string2 = "/Root/VHosts/VHost";
                xPathExpression = xPath.compile(string2);
                object7 = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
                if (object7 != null) {
                    for (int i = 0; i < object7.getLength(); ++i) {
                        node2 = object7.item(i);
                        node = (Element)node2;
                        object6 = Bootstrap.getNodeByTagName((Element)node, "Name");
                        object5 = Bootstrap.getNodeByTagName((Element)node, "ConfigDir");
                        object4 = Bootstrap.getNodeByTagName((Element)node, "ConnectionLimit");
                        if (object6 != null && object5 != null) {
                            object3 = Bootstrap.getNodeValue((Node)object6);
                            string = Bootstrap.getNodeValue((Node)object5);
                            object2 = null;
                            if (object4 != null) {
                                object2 = Bootstrap.getNodeValue((Node)object4);
                            }
                            object = new HashMap();
                            object.put("Name", object3);
                            object.put("ConfigDir", string);
                            object.put("ConnectionLimit", object2);
                            hashMap2.put(object3, object);
                            continue;
                        }
                        System.out.println("loadConfigFile: error parsing vhosts config file: (" + string3 + ") : error <Name> and <ConfigDir> required.");
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error parsing VHosts.xml (" + string3 + "): " + exception.toString());
            exception.printStackTrace();
            Bootstrap.doWait();
        }
        return hashMap;
    }

    private static Node getNodeByTagName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            return nodeList.item(0);
        }
        return null;
    }

    private static String getNodeValue(Node node) {
        Object object = "";
        if (node != null) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                object = (String)object + node2.getNodeValue();
            }
        }
        return object;
    }

    public static String getNodeValue(XPath xPath, String string, Element element, String string2) {
        String string3 = string2;
        try {
            String string4 = xPath.evaluate(string, element);
            if (string4.length() > 0) {
                string3 = string4;
            }
        }
        catch (Exception exception) {
            System.out.println("getNodeValue: " + exception.toString());
        }
        return string3;
    }

    public static String getServerLog4jPropertiesURL() {
        Object object = null;
        String string = Bootstrap.getConfigURL();
        String string2 = Bootstrap.getServerHome(2);
        String string3 = (string2 == null ? "" : string2) + File.separatorChar + "conf" + File.separatorChar + "log4j.properties";
        if (new File(string3).exists()) {
            object = string3.replace("\\", "/");
            if (((String)object).charAt(1) == ':') {
                object = "/" + (String)object;
            }
            object = "file://" + (String)object;
        } else if (string != null) {
            object = string;
            object = ((String)object).indexOf("?") >= 0 ? (String)object + "&" : (String)object + "?";
            object = (String)object + "context=server&filename=" + Bootstrap.encodeValue("conf/log4j.properties");
        }
        return object;
    }

    public static String getServerLicenseURL() {
        Object object = null;
        String string = Bootstrap.getServerHome(2);
        String string2 = (string == null ? "" : string) + File.separatorChar + "conf" + File.separatorChar + "Server.license";
        if (new File(string2).exists()) {
            object = string2.replace("\\", "/");
            if (((String)object).charAt(1) == ':') {
                object = "/" + (String)object;
            }
            object = "file://" + (String)object;
        }
        return object;
    }

    public static String getTuneXMLURL() {
        Object object = null;
        String string = Bootstrap.getConfigURL();
        String string2 = Bootstrap.getServerHome(2);
        String string3 = (string2 == null ? "" : string2) + File.separatorChar + "conf" + File.separatorChar + "Tune.xml";
        if (new File(string3).exists()) {
            object = string3.replace("\\", "/");
            if (((String)object).charAt(1) == ':') {
                object = "/" + (String)object;
            }
            object = "file://" + (String)object;
        } else if (string != null) {
            object = string;
            object = ((String)object).indexOf("?") >= 0 ? (String)object + "&" : (String)object + "?";
            object = (String)object + "context=server&filename=" + Bootstrap.encodeValue("conf/Tune.xml");
        }
        return object;
    }

    public static String getServerXMLURL() {
        Object object = null;
        String string = Bootstrap.getConfigURL();
        String string2 = Bootstrap.getServerHome(2);
        String string3 = (string2 == null ? "" : string2) + File.separatorChar + "conf" + File.separatorChar + "Server.xml";
        if (new File(string3).exists()) {
            object = string3.replace("\\", "/");
            if (((String)object).charAt(1) == ':') {
                object = "/" + (String)object;
            }
            object = "file://" + (String)object;
        } else if (string != null) {
            object = string;
            object = ((String)object).indexOf("?") >= 0 ? (String)object + "&" : (String)object + "?";
            object = (String)object + "context=server&filename=" + Bootstrap.encodeValue("conf/Server.xml");
        }
        return object;
    }

    public static String getVHostsXMLURL() {
        Object object = null;
        String string = Bootstrap.getConfigURL();
        String string2 = Bootstrap.getServerHome(2);
        String string3 = (string2 == null ? "" : string2) + File.separatorChar + "conf" + File.separatorChar + "VHosts.xml";
        if (new File(string3).exists()) {
            object = string3.replace("\\", "/");
            if (((String)object).charAt(1) == ':') {
                object = "/" + (String)object;
            }
            object = "file://" + (String)object;
        } else if (string != null) {
            object = string;
            object = ((String)object).indexOf("?") >= 0 ? (String)object + "&" : (String)object + "?";
            object = (String)object + "context=server&filename=" + Bootstrap.encodeValue("conf/VHosts.xml");
        }
        return object;
    }

    public static String getConfigURL() {
        String string = System.getProperty("com.wowza.wms.ConfigURL");
        if (string == null) {
            return null;
        }
        if (string.trim().length() == 0) {
            return null;
        }
        return string.trim();
    }

    public static boolean isServerURLConfig() {
        return Bootstrap.getConfigURL() != null;
    }

    public static void resolveServerHome() {
        String string = System.getProperty("com.wowza.wms.AppHome");
        if (string == null) {
            string = System.getenv("WMSAPP_HOME");
        }
        if (string != null) {
            string = string.trim();
            string = string.replace("\\", "/");
            if ((string = string.replace("//", "/")).endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.length() == 0) {
                string = null;
            }
        }
        if (string == null) {
            string = "";
        }
        System.setProperty("com.wowza.wms.AppHome", string);
        String string2 = System.getProperty("com.wowza.wms.ConfigHome");
        if (string2 == null) {
            string2 = System.getenv("WMSCONFIG_HOME");
        }
        if (string2 != null) {
            string2 = string2.trim();
            string2 = string2.replace("\\", "/");
            if ((string2 = string2.replace("//", "/")).endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.length() == 0) {
                string2 = null;
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        System.setProperty("com.wowza.wms.ConfigHome", string2);
    }

    public static String getServerHome(int n) {
        return n == 1 ? System.getProperty("com.wowza.wms.AppHome") : System.getProperty("com.wowza.wms.ConfigHome");
    }

    private static void runTest(String string) {
        try {
            Map map = Bootstrap.getServerInfo();
            if (map != null) {
                ClassLoader classLoader = Bootstrap.createClassLoader(map);
                String string2 = "com.wowza.wms.performance.PerformanceTestList";
                Class<?> clazz = classLoader.loadClass(string2);
                Method method = clazz.getMethod("run", String.class);
                method.invoke(null, string);
            }
        }
        catch (Exception exception) {
            System.out.println("Error running test (" + string + "): " + exception);
            exception.printStackTrace();
            Bootstrap.doWait();
        }
    }

    private static void runTestCL(String[] stringArray) {
        try {
            Map map = Bootstrap.getServerInfo();
            if (map != null) {
                ClassLoader classLoader = Bootstrap.createClassLoader(map);
                String string = stringArray[1];
                Class<?> clazz = classLoader.loadClass(string);
                Method method = clazz.getMethod("run", List.class);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 2; i < stringArray.length; ++i) {
                    arrayList.add(stringArray[i]);
                }
                method.invoke(null, arrayList);
            }
        }
        catch (Exception exception) {
            System.out.println("Error running test (" + stringArray[1] + "): " + exception);
            exception.printStackTrace();
            Bootstrap.doWait();
        }
    }

    private static void runJUnit(String[] stringArray) {
        Object object;
        Object object2;
        String string = "com.wowza.wms.plugin.junit.runner.WowzaServerJUnitRunner";
        boolean bl = false;
        boolean bl2 = false;
        Map map = null;
        try {
            map = Bootstrap.getServerInfo();
            if (map != null) {
                loader = Bootstrap.createClassLoader(map);
            }
        }
        catch (Exception exception) {
            bl = false;
            System.out.println("Bootstrap.runJUnit: Error starting bootstrap loader: " + exception);
            exception.printStackTrace();
            return;
        }
        Class<?> clazz = null;
        try {
            clazz = loader.loadClass(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (clazz == null) {
            System.out.printf("Bootstrap.runJUnit: Class '%s' cannot be found. No JUnit tests run.\n", string);
            return;
        }
        IWowzaServerTestRunner iWowzaServerTestRunner = null;
        try {
            if (clazz != null) {
                object2 = clazz.getMethod("createRunner", String[].class);
                if (object2 == null) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.createRunner(String, String[]) not found. No JUnit tests run.\n", string);
                }
                if (!((object = ((Method)object2).invoke(null, new Object[]{stringArray})) instanceof IWowzaServerTestRunner)) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.createRunner(String[]) was unsuccessful,  Return value: %s\n", string, object);
                    return;
                }
                iWowzaServerTestRunner = (IWowzaServerTestRunner)object;
            }
        }
        catch (Exception exception) {
            bl2 = false;
            System.out.printf("Bootstrap.runJUnit: Method %s.createRunner(String[]) was unsuccessful,  e:\n", exception);
            return;
        }
        try {
            if (iWowzaServerTestRunner != null) {
                object2 = clazz.getMethod("setUp", String.class);
                if (object2 == null) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.setUp(String) not found. No JUnit tests run.\n", string);
                }
                if (!(object = ((Method)object2).invoke(iWowzaServerTestRunner, Bootstrap.getServerHome(1))).toString().equals("0")) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.setUp(String[]) was unsuccessful,  Return value: %s\n", string, object);
                    return;
                }
            }
        }
        catch (Exception exception) {
            bl2 = false;
            System.out.printf("Bootstrap.runJUnit: Method %s.setUp(String[]) was unsuccessful,  e:\n", exception);
            return;
        }
        try {
            if (loader != null) {
                object2 = "com.wowza.wms.server.Server";
                object = loader.loadClass((String)object2);
                Method method = ((Class)object).getMethod("start", new Class[0]);
                method.invoke(null, (Object[])null);
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
            System.out.println("Bootstrap.runJUnit: Error starting: " + exception);
            exception.printStackTrace();
        }
        try {
            if (bl && clazz != null) {
                object2 = clazz.getMethod("runTests", new Class[0]);
                if (object2 == null) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.runTests(String[]) not found. No JUnit tests run.\n", string);
                }
                object = ((Method)object2).invoke(iWowzaServerTestRunner, new Object[0]);
                bl2 = true;
                if (!object.toString().equals("0")) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.runTests(String[]) did not run tests,  Return value: %s\n", string, object);
                }
            }
        }
        catch (Exception exception) {
            bl2 = false;
            System.out.println("Bootstrap.runTests: Error starting JUnit tests: " + exception);
            exception.printStackTrace();
        }
        try {
            if (clazz != null) {
                object2 = clazz.getMethod("tearDown", String.class);
                if (object2 == null) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.tearDown(String) not found. No JUnit tests run.\n", string);
                }
                if (!(object = ((Method)object2).invoke((Object)iWowzaServerTestRunner, Bootstrap.getServerHome(1))).toString().equals("0")) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.tearDown(String[]) was unsuccessful,  Return value: %s\n", string, object);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl2 = false;
            System.out.printf("Bootstrap.runJUnit: Method %s.tearDown(String[]) was unsuccessful,  e:\n", exception);
        }
        Bootstrap.stopServer();
    }

    public static String getNativeOS() {
        String string = System.getProperty("com.wowza.wms.native.base");
        if (string == null) {
            if (SystemUtils.IS_OS_WINDOWS) {
                string = "win";
            } else if (SystemUtils.IS_OS_LINUX) {
                string = "linux";
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                string = "osx";
            }
        }
        return string;
    }

    public static String getNativeArchitecture() {
        String string = System.getProperty("sun.arch.data.model");
        return string;
    }

    public static String getNativeLibPath() {
        String string = System.getProperty("sun.arch.data.model");
        String string2 = System.getProperty("com.wowza.wms.native.base");
        if (string2 == null) {
            if (SystemUtils.IS_OS_WINDOWS) {
                string2 = "win";
            } else if (SystemUtils.IS_OS_LINUX) {
                string2 = "linux";
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                string2 = "osx";
            }
        }
        String string3 = Bootstrap.getServerHome(1) + "/" + NATIVELIBFOLDER + "/" + string2 + string;
        return string3;
    }

    public static boolean isClearCaster() {
        String string = System.getProperty("com.wowza.wms.application");
        return string != null && string.equals("clearcaster");
    }

    public static String getClearCasterEncoderName() {
        String string = System.getProperty(SYSTEM_PROPERTY_ENCODERNAME);
        return string;
    }

    public static String getClearCasterRootHome() {
        String string = System.getProperty(SYSTEM_PROPERTY_ROOTPATH);
        return string;
    }

    public static String getClearCasterStorageHome() {
        String string = System.getProperty(SYSTEM_PROPERTY_STORAGEPATH);
        if (string != null) {
            return string;
        }
        return Bootstrap.getClearCasterAddOnConfigHome();
    }

    public static String getClearCasterAddOnAppHome() {
        String string = Bootstrap.getServerHome(2);
        String string2 = System.getProperty(SYSTEM_PROPERTY_APPHOMEPATH);
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    public static String getClearCasterAddOnConfigHome() {
        String string = Bootstrap.getServerHome(2);
        String string2 = System.getProperty(SYSTEM_PROPERTY_CONFIGHOMEPATH);
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    public static class BootstrapURLClassLoader
    extends URLClassLoader {
        public BootstrapURLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        @Override
        public void addURL(URL uRL) {
            super.addURL(uRL);
        }
    }

    public static class ReplaceItem {
        public int start = 0;
        public int end = 0;
        public String newValue = null;

        public ReplaceItem(int n, int n2, String string) {
            this.start = n;
            this.end = n2;
            this.newValue = string;
        }
    }
}

