/*
 * Decompiled with CFR 0.152.
 */
package com.pallycon.wowza.util;

import com.pallycon.wowza.util.JsonUtils;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;

public class PropUtils {
    private WMSLogger logger = WMSLoggerFactory.getLogger(null);
    Properties props;

    public PropUtils() {
    }

    public String set(String PallyconMapFilePath) throws Exception {
        String content = PropUtils.readFile(PallyconMapFilePath);
        return content;
    }

    public PropUtils(String properties) throws IOException {
        this.props = new Properties();
        this.props.load(new StringReader(properties));
    }

    public String toString() {
        try {
            return this.props.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String get(String streamName, String key) throws Exception {
        try {
            String value = JsonUtils.jsonNvl(JsonUtils.getStrToJson(this.props.getProperty(streamName)), key);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String keySearch(String key) throws Exception {
        String result = null;
        Set<Object> keys = this.props.keySet();
        ArrayList<Object> keyList = Collections.list(Collections.enumeration(keys));
        Collections.sort(keyList);
        try {
            for (Object e : keyList) {
                if ("*".equals(e.toString()) || !e.toString().contains("*") || !key.toLowerCase().contains(e.toString().replace("*", "").toLowerCase())) continue;
                result = e.toString();
                break;
            }
        }
        catch (Exception e) {
            throw new Exception("keySearch ::" + key + " > " + e.getMessage(), e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String sFilePath) throws Exception {
        byte[] ba = null;
        try (FileInputStream fis = null;){
            File f = new File(sFilePath);
            fis = new FileInputStream(f);
            long lLength = f.length();
            ba = new byte[(int)lLength];
            fis.read(ba);
        }
        return new String(ba, "UTF-8");
    }
}

