/*
 * Decompiled with CFR 0.152.
 */
package com.pallycon.wowza.session;

import com.pallycon.cpix.dto.ContentPackagingInfo;
import com.wowza.wms.logging.WMSLogger;
import java.util.HashMap;

public class SessionChecker {
    public static HashMap<String, ContentPackagingInfo> dashHashMap = new HashMap();
    public static HashMap<String, ContentPackagingInfo> hlsHashMap = new HashMap();
    public static SessionChecker instance = null;
    public static final String HLS = "HLS";
    public static final String DASH = "DASH";
    public WMSLogger logger = null;

    public static SessionChecker getInstance(WMSLogger logger) {
        if (instance == null) {
            instance = new SessionChecker(logger);
        }
        return instance;
    }

    public SessionChecker(WMSLogger logger) {
        this.logger = logger;
    }

    public boolean isValid(String sessionId, String streamType) {
        if (HLS.equals(streamType)) {
            return hlsHashMap.containsKey(sessionId);
        }
        return dashHashMap.containsKey(sessionId);
    }

    public void setSessionData(String sessionId, ContentPackagingInfo value, String streamType) {
        if (HLS.equals(streamType)) {
            hlsHashMap.put(sessionId, value);
            this.logger.info("Session added. total hls count : " + hlsHashMap.size());
        }
        if (DASH.equals(streamType)) {
            dashHashMap.put(sessionId, value);
            this.logger.info("Session added. total dash count : " + dashHashMap.size());
        }
    }

    public ContentPackagingInfo getSessionData(String sessionId, String streamType) {
        if (HLS.equals(streamType)) {
            return hlsHashMap.get(sessionId);
        }
        return dashHashMap.get(sessionId);
    }

    public void removeSession(String sessionId) {
        dashHashMap.remove(sessionId);
        hlsHashMap.remove(sessionId);
        this.logger.info("Session removed. total dash count : " + dashHashMap.size());
        this.logger.info("Session removed. total hls count : " + hlsHashMap.size());
    }
}

