/*
 * Decompiled with CFR 0.152.
 */
package com.pallycon.wowza;

import com.google.protobuf.ByteString;
import com.pallycon.cpix.PallyConCpixClient;
import com.pallycon.cpix.dto.ContentPackagingInfo;
import com.pallycon.cpix.dto.DrmType;
import com.pallycon.cpix.dto.EncryptionScheme;
import com.pallycon.cpix.dto.MultiDrmInfo;
import com.pallycon.cpix.dto.TrackType;
import com.pallycon.cpix.exception.CpixClientException;
import com.pallycon.wowza.CencDRMInfoWisePlay;
import com.pallycon.wowza.DrmModule;
import com.pallycon.wowza.WidevinePSSH;
import com.pallycon.wowza.WowzaModule;
import com.pallycon.wowza.session.SessionChecker;
import com.pallycon.wowza.util.PropUtils;
import com.pallycon.wowza.util.StringUtil;
import com.wowza.util.Base64;
import com.wowza.wms.drm.cenc.CencDRMInfoPlayready;
import com.wowza.wms.drm.cenc.CencDRMInfoWidevine;
import com.wowza.wms.drm.cenc.CencInfo;
import com.wowza.wms.drm.cenc.ICencDRMInfo;
import com.wowza.wms.drm.playready.PlayReadyKeyInfo;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.util.EnumSet;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;

public class PallyConModule
implements WowzaModule {
    private WMSLogger logger = WMSLoggerFactory.getLogger(null);
    public static final String PALLYCON_PLAYREADY_URL = "https://license-global.pallycon.com/ri/licenseManager.do";
    private static final String PROVIDER_NAME = "inkaentworks";
    private static final String WIDEVINE_DRM_INFO = "myWidevineDRM:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed";
    private static final String PLAYREADY_DRM_INFO = "myPlayReadyDRM:9a04f079-9840-4286-ab92-e65be0885f95";
    private static final String WISEPLAY_DRM_INFO = "myWisePlayDRM:3d5e6d35-9b9a-41e8-b843-dd3c6e72c42c";
    private static final String FPS_KEYFORMAT = "com.apple.streamingkeydelivery";
    private static final String FPS_KEYFORMAT_VERSION = "1";

    protected String getPlayReadyKeyServerUrl() {
        return PALLYCON_PLAYREADY_URL;
    }

    private String getStreamName(String filePath) throws NullPointerException {
        String streamName;
        String[] stream = filePath.replace('\\', '/').split("/");
        if (stream == null) {
            throw new NullPointerException("stream name is null.");
        }
        if (stream.length < 1) {
            streamName = filePath;
        } else {
            streamName = stream[stream.length - 1];
            int sepaIndex = streamName.lastIndexOf(".");
            if (sepaIndex > -1) {
                streamName = streamName.substring(0, sepaIndex);
            }
        }
        return streamName;
    }

    @Override
    public void setWidevineAndPlayReady(ContentPackagingInfo packagingInfo, CencInfo cencInfo) throws CpixClientException {
        if (0 < packagingInfo.getMultiDrmInfos().size()) {
            for (MultiDrmInfo drmInfo : packagingInfo.getMultiDrmInfos()) {
                cencInfo.setScheme("cenc");
                byte[] keyId = StringUtil.guidStringToByteArray(drmInfo.getKeyId());
                byte[] key = Base64.decode((String)drmInfo.getKey());
                cencInfo.setKID(keyId);
                cencInfo.setEncKeyBytes(key);
                CencDRMInfoWidevine cencDRMInfoWidevine = new CencDRMInfoWidevine();
                cencDRMInfoWidevine.setPsshData(Base64.decode((String)drmInfo.getWidevinePsshPayload()));
                cencInfo.addDRM(WIDEVINE_DRM_INFO, (ICencDRMInfo)cencDRMInfoWidevine);
                CencDRMInfoPlayready cencDRMInfoPlayready = new CencDRMInfoPlayready();
                PlayReadyKeyInfo playReadyKeyInfo = new PlayReadyKeyInfo();
                playReadyKeyInfo.setLicenseURL(PALLYCON_PLAYREADY_URL);
                playReadyKeyInfo.setKeyId(keyId);
                playReadyKeyInfo.setContentKey(key);
                playReadyKeyInfo.generateChecksum();
                cencDRMInfoPlayready.setPlayReadyKeyInfo(playReadyKeyInfo);
                cencDRMInfoPlayready.setPsshData(Base64.decode((String)drmInfo.getPlayreadyPsshPayload()));
                cencInfo.addDRM(PLAYREADY_DRM_INFO, (ICencDRMInfo)cencDRMInfoPlayready);
            }
        } else {
            throw new CpixClientException("Key informations are invalid.");
        }
    }

    @Override
    public void setWisePlay(ContentPackagingInfo packagingInfo, CencInfo cencInfo) throws CpixClientException {
        if (0 < packagingInfo.getMultiDrmInfos().size()) {
            for (MultiDrmInfo drmInfo : packagingInfo.getMultiDrmInfos()) {
                CencDRMInfoWisePlay cencDRMInfoWisePlay = new CencDRMInfoWisePlay();
                cencDRMInfoWisePlay.setPsshData(Base64.decode((String)drmInfo.getWiseplayPsshPayload()));
                cencInfo.addDRM(WISEPLAY_DRM_INFO, (ICencDRMInfo)cencDRMInfoWisePlay);
            }
        } else {
            throw new CpixClientException("Key informations are invalid.");
        }
    }

    @Override
    public void setFairPlay(ContentPackagingInfo packagingInfo, CupertinoEncInfo encInfo) throws CpixClientException {
        if (0 < packagingInfo.getMultiDrmInfos().size()) {
            for (MultiDrmInfo drmInfo : packagingInfo.getMultiDrmInfos()) {
                byte[] key = Base64.decode((String)drmInfo.getKey());
                byte[] iv = Base64.decode((String)drmInfo.getIv());
                encInfo.setEncMethod(2);
                encInfo.setEncKeyFormat(FPS_KEYFORMAT);
                encInfo.setEncUrl(drmInfo.getFairplayHlsKeyUri());
                encInfo.setEncKeyBytes(key);
                encInfo.setEncIVBytes(iv);
                encInfo.setEncKeyFormatVersion(FPS_KEYFORMAT_VERSION);
                encInfo.setEncIVBytesInChunklist(false);
            }
        } else {
            throw new CpixClientException("Key informations are invalid.");
        }
    }

    @Override
    public ContentPackagingInfo getDrmPackagingKeyInfo(String appName, String streamName, String streamType, EnumSet<DrmType> drmTypes, EncryptionScheme encryptionScheme, EnumSet<TrackType> trackTypes, long periodIndex) throws CpixClientException {
        ContentPackagingInfo contentPackagingInfo;
        String pattern = "[-_.,:;|]+$";
        if (DrmModule.pallyConCidOfStreamName.booleanValue()) {
            this.logger.debug("[PallyCon] pallyConCidOfStreamName : " + DrmModule.pallyConCidOfStreamNameSeparator);
            if (Pattern.matches(pattern, DrmModule.pallyConCidOfStreamNameSeparator)) {
                int separatorIndex = streamName.indexOf(DrmModule.pallyConCidOfStreamNameSeparator);
                if (-1 < separatorIndex) {
                    streamName = streamName.substring(0, separatorIndex);
                } else {
                    this.logger.error("[PallyCon] The separator does not exist in StreamName. Packaged by StreamName.");
                }
            } else {
                this.logger.error("[PallyCon] PallyConCidOfStreamNameSeparator does not correspond to [-_.,:;|]+$, so it is packaged by streamName.");
            }
        }
        if (DrmModule.pallyConMasterCid != null && !"".equals(DrmModule.pallyConMasterCid.trim())) {
            streamName = DrmModule.pallyConMasterCid;
        }
        if (DrmModule.pallyconStreamMap != null) {
            try {
                String pallyconStream = DrmModule.pallyconStreamMap.get(appName);
                if (pallyconStream != null) {
                    PropUtils prop = new PropUtils(pallyconStream);
                    this.logger.info("appName :: " + appName + " >> prop :: " + prop.toString());
                    String masterId = prop.get("*", "contentId");
                    String customContentId = prop.get(streamName, "contentId");
                    if (customContentId != null && !"".equals(customContentId)) {
                        this.logger.info("customContentId :: " + streamName + " >> " + customContentId);
                        streamName = customContentId;
                    } else {
                        String wildcardKey = prop.keySearch(streamName);
                        if (wildcardKey != null) {
                            customContentId = prop.get(wildcardKey, "contentId");
                        }
                        if (customContentId == null && masterId != null && !"".equals(masterId)) {
                            this.logger.info("masterId :: " + streamName + " >> " + masterId);
                            streamName = masterId;
                        } else if (customContentId != null) {
                            this.logger.info("customContentId :: " + streamName + " >> " + customContentId);
                            streamName = customContentId;
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        Boolean keyRotation = false;
        Map<String, String> queryMap = StringUtil.getUrlQueryMap(DrmModule.requestUrl);
        if (queryMap != null && queryMap.get("key-rotation") != null) {
            keyRotation = Boolean.valueOf(queryMap.get("key-rotation"));
        }
        if (!keyRotation.booleanValue() && SessionChecker.getInstance(this.logger).isValid(streamName, streamType)) {
            contentPackagingInfo = SessionChecker.getInstance(this.logger).getSessionData(streamName, streamType);
        } else {
            PallyConCpixClient cpixClient = new PallyConCpixClient(DrmModule.requestUrl);
            contentPackagingInfo = cpixClient.GetContentKeyInfoFromPallyConKMS(streamName, drmTypes, encryptionScheme, trackTypes, keyRotation != false ? periodIndex : 0L);
            SessionChecker.getInstance(this.logger).setSessionData(streamName, contentPackagingInfo, streamType);
        }
        return contentPackagingInfo;
    }

    @Override
    public void createFairPlayRandomKey(CupertinoEncInfo encInfo) {
        byte[] block = new byte[16];
        new Random().nextBytes(block);
        byte[] iv = new byte[16];
        new Random().nextBytes(iv);
        String extXKey = "skd://" + Base64.encodeBytes((byte[])block);
        this.logger.info("createRandomKey extXKey : " + extXKey);
        encInfo.setEncMethod(2);
        encInfo.setEncKeyFormat(FPS_KEYFORMAT);
        encInfo.setEncUrl(extXKey);
        encInfo.setEncKeyBytes(block);
        encInfo.setEncIVBytes(iv);
        encInfo.setEncKeyFormatVersion(FPS_KEYFORMAT_VERSION);
        encInfo.setEncIVBytesInChunklist(false);
        this.logger.info("[PallyCon] createFairPlayRandomKey END");
    }

    @Override
    public void createWidevineAndPlayReadyRandomKey(CencInfo cencInfo) {
        byte[] block = new byte[16];
        new Random().nextBytes(block);
        CencDRMInfoWidevine cencDRMInfoWidevine = new CencDRMInfoWidevine();
        cencDRMInfoWidevine.setPsshData(PallyConModule.getPSSHData(block, "errorCid".getBytes()));
        this.logger.info("errorPSSH : " + new String(cencDRMInfoWidevine.getPsshData(true)));
        cencInfo.addDRM(WIDEVINE_DRM_INFO, (ICencDRMInfo)cencDRMInfoWidevine);
        CencDRMInfoPlayready cencDRMInfoPlayready = new CencDRMInfoPlayready();
        PlayReadyKeyInfo playReadyKeyInfo = new PlayReadyKeyInfo();
        playReadyKeyInfo.setLicenseURL(PALLYCON_PLAYREADY_URL);
        playReadyKeyInfo.setKeyId(block);
        playReadyKeyInfo.setContentKey(block);
        playReadyKeyInfo.generateChecksum();
        cencDRMInfoPlayready.setPlayReadyKeyInfo(playReadyKeyInfo);
        cencInfo.addDRM(PLAYREADY_DRM_INFO, (ICencDRMInfo)cencDRMInfoPlayready);
        this.logger.info("[PallyCon] createWidevineAndPlayReadyRandomKey END");
    }

    public static byte[] getPSSHData(byte[] sB64KeyID, byte[] sContentID) {
        byte[] psshData;
        try {
            WidevinePSSH.WidevineCencHeader.Builder cencHeader = WidevinePSSH.WidevineCencHeader.newBuilder();
            cencHeader.setAlgorithm(WidevinePSSH.WidevineCencHeader.Algorithm.valueOf(1));
            ByteString bsKeyId = ByteString.copyFrom((byte[])sB64KeyID);
            cencHeader.addKeyId(bsKeyId);
            cencHeader.setProvider(PROVIDER_NAME);
            ByteString bsContentId = ByteString.copyFrom((byte[])sContentID);
            cencHeader.setContentId(bsContentId);
            cencHeader.setTrackType("HD");
            psshData = cencHeader.build().toByteArray();
        }
        catch (Exception e) {
            String m_sErrorMsg = "[ERROR]sPSSHData Exception ==> " + e.getMessage();
            e.printStackTrace();
            return null;
        }
        return psshData;
    }
}

