/*
 * Decompiled with CFR 0.152.
 */
package com.pallycon.wowza;

import com.pallycon.cpix.dto.ContentPackagingInfo;
import com.pallycon.cpix.dto.DrmType;
import com.pallycon.cpix.dto.EncryptionScheme;
import com.pallycon.cpix.dto.TrackType;
import com.pallycon.cpix.exception.CpixClientException;
import com.pallycon.wowza.PallyConModule;
import com.pallycon.wowza.session.SessionChecker;
import com.pallycon.wowza.util.PropUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.drm.cenc.CencInfo;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndex;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerSessionCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.mpegdashstreaming.file.IHTTPStreamerMPEGDashIndex;
import com.wowza.wms.httpstreamer.mpegdashstreaming.httpstreamer.HTTPStreamerSessionMPEGDash;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import java.util.EnumSet;
import java.util.HashMap;

public class DrmModule
extends ModuleBase {
    private WMSLogger logger = WMSLoggerFactory.getLogger(null);
    public static String requestUrl;
    public static Boolean enableWisePlay;
    public static Boolean pallyConCidOfStreamName;
    public static String pallyConCidOfStreamNameSeparator;
    public static String pallyConMasterCid;
    public static HashMap<String, String> pallyconStreamMap;

    public void onAppStart(IApplicationInstance appInstance) {
        String fullName = appInstance.getApplication().getName() + "/" + appInstance.getName();
        this.logger.info("[PallyCon] DRM CPIX onAppStart: " + fullName);
        requestUrl = appInstance.getProperties().getPropertyStr("KmsUrl");
        this.logger.info("[PallyCon] [On App Start] requestUrl : " + requestUrl);
        enableWisePlay = appInstance.getProperties().getPropertyBoolean("EnableWisePlay", false);
        this.logger.info("[PallyCon] [On App Start] enableWisePlay : " + enableWisePlay);
        pallyConCidOfStreamName = appInstance.getProperties().getPropertyBoolean("PallyConCidOfStreamName", false);
        this.logger.info("[PallyCon] [On App Start] PallyConCidOfStreamName : " + pallyConCidOfStreamName);
        pallyConCidOfStreamNameSeparator = appInstance.getProperties().getPropertyStr("PallyConCidOfStreamNameSeparator", ";");
        this.logger.info("[PallyCon] [On App Start] PallyConCidOfStreamNameSeparator : " + pallyConCidOfStreamNameSeparator);
        pallyConMasterCid = appInstance.getProperties().getPropertyStr("PallyConMasterCid", "");
        this.logger.info("[PallyCon] [On App Start] PallyConMasterCid : " + pallyConMasterCid);
        String pallyconMapFileName = appInstance.getProperties().getPropertyStr("PallyconMapFile", "");
        this.logger.info("[PallyCon] [On App Start] PallyconMapFileName : " + pallyconMapFileName);
        if (!"".equalsIgnoreCase(pallyconMapFileName)) {
            String pallyconMapFilePath = appInstance.getVHost().getHomePath() + "/conf/" + appInstance.getApplication().getName() + "/" + pallyconMapFileName;
            try {
                pallyconStreamMap.put(appInstance.getApplication().getName(), new PropUtils().set(pallyconMapFilePath));
                this.logger.info("[PallyCon] [On App Start] PallyconStreamMap : " + pallyconStreamMap.toString());
            }
            catch (Exception e) {
                this.logger.error(pallyconMapFilePath + " is Invalid.");
            }
        } else {
            pallyconStreamMap.put(appInstance.getApplication().getName(), null);
        }
    }

    public void onAppStop(IApplicationInstance appInstance) {
        String fullName = appInstance.getApplication().getName() + "/" + appInstance.getName();
        this.logger.info("[PallyCon] [On App Stop] pallyconEncToken : " + fullName);
    }

    public void onStreamCreate(IMediaStream stream) {
        this.logger.info("onStreamCreate: " + stream.getSrc());
        this.logger.info("onStreamCreate getName : " + stream.getName());
        this.logger.info("onStreamCreate getClientId : " + stream.getClientId());
    }

    public void onHTTPSessionDestroy(IHTTPStreamerSession httpSession) {
        this.logger.info("onHTTPSessionDestroy: " + httpSession.getSessionId());
        SessionChecker.getInstance(this.logger).removeSession(httpSession.getSessionId());
    }

    public void onHTTPMPEGDashEncryptionKeyVODChunk(HTTPStreamerSessionMPEGDash httpSession, IHTTPStreamerMPEGDashIndex index, CencInfo cencInfo, long chunkId) {
        PallyConModule wowzaModule = new PallyConModule();
        try {
            String streamName = httpSession.getStreamName();
            String appName = httpSession.getAppInstance().getApplication().getName();
            EnumSet<DrmType> drmTypes = EnumSet.of(DrmType.WIDEVINE, DrmType.PLAYREADY);
            if (enableWisePlay.booleanValue()) {
                drmTypes.add(DrmType.WISEPLAY);
            }
            EncryptionScheme encryptionScheme = EncryptionScheme.CENC;
            EnumSet<TrackType> trackTypes = EnumSet.of(TrackType.ALL_TRACKS);
            ContentPackagingInfo packagingInfo = wowzaModule.getDrmPackagingKeyInfo(appName, streamName, "DASH", drmTypes, encryptionScheme, trackTypes, chunkId);
            wowzaModule.setWidevineAndPlayReady(packagingInfo, cencInfo);
            if (enableWisePlay.booleanValue()) {
                wowzaModule.setWisePlay(packagingInfo, cencInfo);
            }
        }
        catch (CpixClientException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.error("[PallyCon] create Widevine and PlayReady random key");
            wowzaModule.createWidevineAndPlayReadyRandomKey(cencInfo);
        }
    }

    public void onHTTPMPEGDashEncryptionKeyLiveChunk(ILiveStreamPacketizer liveStreamPacketizer, String streamName, CencInfo cencInfo, long chunkId) {
        PallyConModule wowzaModule = new PallyConModule();
        try {
            String appName = liveStreamPacketizer.getApplicationInstance().getApplication().getName();
            EnumSet<DrmType> drmTypes = EnumSet.of(DrmType.WIDEVINE, DrmType.PLAYREADY);
            if (enableWisePlay.booleanValue()) {
                drmTypes.add(DrmType.WISEPLAY);
            }
            EncryptionScheme encryptionScheme = EncryptionScheme.CENC;
            EnumSet<TrackType> trackTypes = EnumSet.of(TrackType.ALL_TRACKS);
            ContentPackagingInfo packagingInfo = wowzaModule.getDrmPackagingKeyInfo(appName, streamName, "DASH", drmTypes, encryptionScheme, trackTypes, chunkId);
            wowzaModule.setWidevineAndPlayReady(packagingInfo, cencInfo);
            if (enableWisePlay.booleanValue()) {
                wowzaModule.setWisePlay(packagingInfo, cencInfo);
            }
        }
        catch (CpixClientException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.error("[PallyCon] create Widevine and PlayReady random key");
            wowzaModule.createWidevineAndPlayReadyRandomKey(cencInfo);
        }
    }

    public void onHTTPCupertinoEncryptionKeyVODChunk(HTTPStreamerSessionCupertino httpSession, IHTTPStreamerCupertinoIndex index, CupertinoEncInfo encInfo, long chunkId, int mode) {
        PallyConModule wowzaModule = new PallyConModule();
        try {
            String streamName = httpSession.getStreamName();
            String appName = httpSession.getAppInstance().getApplication().getName();
            EnumSet<DrmType> drmTypes = EnumSet.of(DrmType.FAIRPLAY);
            EncryptionScheme encryptionScheme = EncryptionScheme.CBCS;
            EnumSet<TrackType> trackTypes = EnumSet.of(TrackType.ALL_TRACKS);
            ContentPackagingInfo packagingInfo = wowzaModule.getDrmPackagingKeyInfo(appName, streamName, "HLS", drmTypes, encryptionScheme, trackTypes, chunkId);
            wowzaModule.setFairPlay(packagingInfo, encInfo);
        }
        catch (CpixClientException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.error("[PallyCon] create FairPlay random key");
            wowzaModule.createFairPlayRandomKey(encInfo);
        }
    }

    public void onHTTPCupertinoEncryptionKeyLiveChunk(ILiveStreamPacketizer liveStreamPacketizer, String streamName, CupertinoEncInfo encInfo, long chunkId, int mode) {
        PallyConModule wowzaModule = new PallyConModule();
        try {
            String appName = liveStreamPacketizer.getApplicationInstance().getApplication().getName();
            EnumSet<DrmType> drmTypes = EnumSet.of(DrmType.FAIRPLAY);
            EncryptionScheme encryptionScheme = EncryptionScheme.CBCS;
            EnumSet<TrackType> trackTypes = EnumSet.of(TrackType.ALL_TRACKS);
            ContentPackagingInfo packagingInfo = wowzaModule.getDrmPackagingKeyInfo(appName, streamName, "HLS", drmTypes, encryptionScheme, trackTypes, chunkId);
            wowzaModule.setFairPlay(packagingInfo, encInfo);
        }
        catch (CpixClientException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.error("[PallyCon] create FairPlay random key");
            wowzaModule.createFairPlayRandomKey(encInfo);
        }
    }

    public void onHTTPCmafEncryptionKeyVODSegment(HTTPStreamerSessionMPEGDash httpSession, IHTTPStreamerMPEGDashIndex index, CencInfo cencInfo, long chunkId) {
        PallyConModule wowzaModule = new PallyConModule();
        try {
            String streamName = httpSession.getStreamName();
            String appName = httpSession.getAppInstance().getApplication().getName();
            EnumSet<DrmType> drmTypes = EnumSet.of(DrmType.WIDEVINE, DrmType.PLAYREADY);
            EncryptionScheme encryptionScheme = EncryptionScheme.CENC;
            EnumSet<TrackType> trackTypes = EnumSet.of(TrackType.ALL_TRACKS);
            ContentPackagingInfo packagingInfo = wowzaModule.getDrmPackagingKeyInfo(appName, streamName, "DASH", drmTypes, encryptionScheme, trackTypes, chunkId);
            wowzaModule.setWidevineAndPlayReady(packagingInfo, cencInfo);
        }
        catch (CpixClientException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.error("[PallyCon] create Widevine and PlayReady random key");
            wowzaModule.createWidevineAndPlayReadyRandomKey(cencInfo);
        }
    }

    public void onHTTPCmafEncryptionKeyLiveSegment(ILiveStreamPacketizer liveStreamPacketizer, String streamName, CencInfo cencInfo, long segmentId, int contentType) {
        PallyConModule wowzaModule = new PallyConModule();
        try {
            String appName = liveStreamPacketizer.getApplicationInstance().getApplication().getName();
            EnumSet<DrmType> drmTypes = EnumSet.of(DrmType.WIDEVINE, DrmType.PLAYREADY);
            EncryptionScheme encryptionScheme = EncryptionScheme.CENC;
            EnumSet<TrackType> trackTypes = EnumSet.of(TrackType.ALL_TRACKS);
            ContentPackagingInfo packagingInfo = wowzaModule.getDrmPackagingKeyInfo(appName, streamName, "DASH", drmTypes, encryptionScheme, trackTypes, segmentId);
            wowzaModule.setWidevineAndPlayReady(packagingInfo, cencInfo);
        }
        catch (CpixClientException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.error("[PallyCon] create Widevine and PlayReady random key");
            wowzaModule.createWidevineAndPlayReadyRandomKey(cencInfo);
        }
    }

    static {
        enableWisePlay = false;
        pallyConCidOfStreamName = false;
        pallyconStreamMap = new HashMap();
    }
}

