/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.object.AbstractMP3Object;
import org.farng.mp3.object.ObjectLyrics3TimeStamp;

public class ObjectLyrics3Image
extends AbstractMP3Object {
    private ObjectLyrics3TimeStamp time = null;
    private String description = "";
    private String filename = "";

    public ObjectLyrics3Image(String string) {
        this.identifier = string;
    }

    public ObjectLyrics3Image(ObjectLyrics3Image objectLyrics3Image) {
        super(objectLyrics3Image);
        this.time = new ObjectLyrics3TimeStamp(objectLyrics3Image.time);
        this.description = new String(objectLyrics3Image.description);
        this.filename = new String(objectLyrics3Image.filename);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public int getSize() {
        int n = this.filename.length() + 2 + this.description.length() + 2;
        if (this.time != null) {
            n += this.time.getSize();
        }
        return n;
    }

    public void setTimeStamp(ObjectLyrics3TimeStamp objectLyrics3TimeStamp) {
        this.time = objectLyrics3TimeStamp;
    }

    public ObjectLyrics3TimeStamp getTimeStamp() {
        return this.time;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ObjectLyrics3Image)) {
            return false;
        }
        ObjectLyrics3Image objectLyrics3Image = (ObjectLyrics3Image)object;
        if (!this.description.equals(objectLyrics3Image.description)) {
            return false;
        }
        if (!this.filename.equals(objectLyrics3Image.filename)) {
            return false;
        }
        if (this.time == null ? objectLyrics3Image.time != null : !this.time.equals(objectLyrics3Image.time)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public void readString(String string, int n) {
        if (string == null) {
            throw new NullPointerException("Image string is null");
        }
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Offset to image string is out of bounds: offset = " + n + ", string.length()" + string.length());
        }
        int n2 = string.indexOf("||", n);
        this.filename = string.substring(n, n2);
        n = n2 + 2;
        n2 = string.indexOf("||", n);
        this.description = string.substring(n, n2);
        n = n2 + 2;
        String string2 = string.substring(n);
        if (string2.length() == 7) {
            this.time = new ObjectLyrics3TimeStamp("Time Stamp");
            this.time.readString(string2);
        }
    }

    @Override
    public String toString() {
        String string = "filename = " + this.filename + ", description = " + this.description;
        if (this.time != null) {
            string = string + ", timestamp = " + this.time.toString();
        }
        return string + "\n";
    }

    @Override
    public String writeString() {
        Object object = this.filename == null ? "||" : this.filename + "||";
        object = this.description == null ? (String)object + "||" : (String)object + this.description + "||";
        if (this.time != null) {
            object = (String)object + this.time.writeString();
        }
        return object;
    }
}

