/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.object.AbstractMP3Object;

public class ObjectBooleanByte
extends AbstractMP3Object {
    int bitPosition = -1;

    public ObjectBooleanByte(String string, int n) {
        if (n < 0 || n > 7) {
            throw new IndexOutOfBoundsException("Bit position needs to be from 0 - 7 : " + n);
        }
        this.bitPosition = n;
        this.identifier = string;
    }

    public ObjectBooleanByte(ObjectBooleanByte objectBooleanByte) {
        super(objectBooleanByte);
        this.bitPosition = objectBooleanByte.bitPosition;
    }

    public int getBitPosition() {
        return this.bitPosition;
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ObjectBooleanByte)) {
            return false;
        }
        ObjectBooleanByte objectBooleanByte = (ObjectBooleanByte)object;
        if (this.bitPosition != objectBooleanByte.bitPosition) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public void readByteArray(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (n < 0 || n >= byArray.length) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + n + ", array.length = " + byArray.length);
        }
        byte by = byArray[n];
        by = (byte)(by >> this.bitPosition);
        this.value = new Boolean((by = (byte)(by & 1)) == 1);
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    public byte[] writeByteArray() {
        byte[] byArray = new byte[1];
        if (this.value != null) {
            byArray[0] = (byte)((Boolean)this.value != false ? 1 : 0);
            byArray[0] = (byte)(byArray[0] << this.bitPosition);
        }
        return byArray;
    }
}

