/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.RandomAccessFile;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractID3v2;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.ID3v2_2Frame;

public class ID3v2_3Frame
extends ID3v2_2Frame {
    protected boolean compression = false;
    protected boolean encryption = false;
    protected boolean fileAlterPreservation = false;
    protected boolean groupingIdentity = false;
    protected boolean readOnly = false;
    protected boolean tagAlterPreservation = false;

    public ID3v2_3Frame() {
        this.setAlterPreservation();
    }

    public ID3v2_3Frame(AbstractID3v2FrameBody abstractID3v2FrameBody) {
        super(abstractID3v2FrameBody);
        this.setAlterPreservation();
    }

    public ID3v2_3Frame(ID3v2_3Frame iD3v2_3Frame) {
        super(iD3v2_3Frame);
        this.compression = iD3v2_3Frame.compression;
        this.encryption = iD3v2_3Frame.encryption;
        this.fileAlterPreservation = iD3v2_3Frame.fileAlterPreservation;
        this.groupingIdentity = iD3v2_3Frame.groupingIdentity;
        this.readOnly = iD3v2_3Frame.readOnly;
        this.tagAlterPreservation = iD3v2_3Frame.tagAlterPreservation;
    }

    public ID3v2_3Frame(boolean bl, boolean bl2, boolean bl3, boolean bl4, AbstractID3v2FrameBody abstractID3v2FrameBody) {
        super(abstractID3v2FrameBody);
        this.readOnly = bl;
        this.groupingIdentity = bl2;
        this.compression = bl3;
        this.encryption = bl4;
        this.setAlterPreservation();
    }

    public ID3v2_3Frame(AbstractID3v2Frame abstractID3v2Frame) {
        if (abstractID3v2Frame instanceof ID3v2_3Frame) {
            ID3v2_3Frame iD3v2_3Frame = (ID3v2_3Frame)abstractID3v2Frame;
            this.tagAlterPreservation = iD3v2_3Frame.tagAlterPreservation;
            this.fileAlterPreservation = iD3v2_3Frame.fileAlterPreservation;
            this.readOnly = iD3v2_3Frame.readOnly;
            this.groupingIdentity = iD3v2_3Frame.groupingIdentity;
            this.compression = iD3v2_3Frame.compression;
            this.encryption = iD3v2_3Frame.encryption;
        }
        if (abstractID3v2Frame instanceof ID3v2_2Frame) {
            // empty if block
        }
        if (abstractID3v2Frame.getBody() != null && TagUtility.isID3v2_3FrameIdentifier(abstractID3v2Frame.getIdentifier())) {
            this.setBody((AbstractID3v2FrameBody)TagUtility.copyObject(abstractID3v2Frame.getBody()));
        }
    }

    public ID3v2_3Frame(RandomAccessFile randomAccessFile) throws IOException, InvalidTagException {
        this.read(randomAccessFile);
    }

    @Override
    public int getSize() {
        return this.getBody().getSize() + 4 + 2 + 4;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ID3v2_3Frame)) {
            return false;
        }
        ID3v2_3Frame iD3v2_3Frame = (ID3v2_3Frame)object;
        if (this.compression != iD3v2_3Frame.compression) {
            return false;
        }
        if (this.encryption != iD3v2_3Frame.encryption) {
            return false;
        }
        if (this.fileAlterPreservation != iD3v2_3Frame.fileAlterPreservation) {
            return false;
        }
        if (this.groupingIdentity != iD3v2_3Frame.groupingIdentity) {
            return false;
        }
        if (this.readOnly != iD3v2_3Frame.readOnly) {
            return false;
        }
        if (this.tagAlterPreservation != iD3v2_3Frame.tagAlterPreservation) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public void read(RandomAccessFile randomAccessFile) throws IOException, InvalidTagException {
        long l;
        byte by;
        byte[] byArray = new byte[4];
        do {
            l = randomAccessFile.getFilePointer();
            by = randomAccessFile.readByte();
            AbstractID3v2.incrementPaddingCounter();
        } while (by == 0);
        randomAccessFile.seek(l);
        AbstractID3v2.decrementPaddingCounter();
        randomAccessFile.read(byArray, 0, 4);
        String string = new String(byArray, 0, 4);
        if (!ID3v2_3Frame.isValidID3v2FrameIdentifier(string)) {
            randomAccessFile.seek(randomAccessFile.getFilePointer() - 3L);
            throw new InvalidTagException(string + " is not a valid ID3v2.30 frame");
        }
        l = randomAccessFile.getFilePointer();
        randomAccessFile.skipBytes(4);
        randomAccessFile.read(byArray, 0, 2);
        this.tagAlterPreservation = (byArray[0] & 0x80) != 0;
        this.fileAlterPreservation = (byArray[0] & 0x40) != 0;
        this.readOnly = (byArray[0] & 0x20) != 0;
        this.compression = (byArray[1] & 0x80) != 0;
        this.encryption = (byArray[1] & 0x40) != 0;
        this.groupingIdentity = (byArray[1] & 0x20) != 0;
        randomAccessFile.seek(l);
        this.setBody(ID3v2_3Frame.readBody(string, randomAccessFile));
    }

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[4];
        String string = TagUtility.truncate(this.getIdentifier(), 4);
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        randomAccessFile.write(byArray, 0, string.length());
        long l = randomAccessFile.getFilePointer();
        randomAccessFile.skipBytes(4);
        this.setAlterPreservation();
        byArray[0] = 0;
        byArray[1] = 0;
        if (this.tagAlterPreservation) {
            byArray[0] = (byte)(byArray[0] | 0x80);
        }
        if (this.fileAlterPreservation) {
            byArray[0] = (byte)(byArray[0] | 0x40);
        }
        if (this.readOnly) {
            byArray[0] = (byte)(byArray[0] | 0x20);
        }
        if (this.compression) {
            byArray[1] = (byte)(byArray[1] | 0x80);
        }
        if (this.encryption) {
            byArray[1] = (byte)(byArray[1] | 0x40);
        }
        if (this.groupingIdentity) {
            byArray[1] = (byte)(byArray[1] | 0x20);
        }
        randomAccessFile.write(byArray, 0, 2);
        randomAccessFile.seek(l);
        this.getBody().write(randomAccessFile);
    }

    protected void setAlterPreservation() {
        String string = this.getIdentifier();
        if (string.equals("ETCO") || string.equals("EQUA") || string.equals("MLLT") || string.equals("POSS") || string.equals("SYLT") || string.equals("SYTC") || string.equals("RVAD") || string.equals("TENC") || string.equals("TLEN") || string.equals("TSIZ")) {
            this.tagAlterPreservation = false;
            this.fileAlterPreservation = true;
        } else {
            this.tagAlterPreservation = false;
            this.fileAlterPreservation = true;
        }
    }
}

