/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.RandomAccessFile;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.object.ObjectID3v2LyricLine;
import org.farng.mp3.object.ObjectLyrics3Line;
import org.farng.mp3.object.ObjectLyrics3TimeStamp;

public class FrameBodySYLT
extends AbstractID3v2FrameBody {
    LinkedList lines = new LinkedList();
    String description = "";
    String language = "";
    byte contentType = 0;
    byte textEncoding = 0;
    byte timeStampFormat = 0;

    public FrameBodySYLT() {
    }

    public FrameBodySYLT(FrameBodySYLT frameBodySYLT) {
        super(frameBodySYLT);
        this.description = new String(frameBodySYLT.description);
        this.language = new String(frameBodySYLT.language);
        this.contentType = frameBodySYLT.contentType;
        this.textEncoding = frameBodySYLT.textEncoding;
        this.timeStampFormat = frameBodySYLT.timeStampFormat;
        for (int i = 0; i < frameBodySYLT.lines.size(); ++i) {
            ObjectID3v2LyricLine objectID3v2LyricLine = new ObjectID3v2LyricLine((ObjectID3v2LyricLine)frameBodySYLT.lines.get(i));
            this.lines.add(objectID3v2LyricLine);
        }
    }

    public FrameBodySYLT(byte by, String string, byte by2, byte by3, String string2) {
        this.textEncoding = by;
        this.language = string;
        this.timeStampFormat = by2;
        this.contentType = by3;
        this.description = string2;
    }

    public FrameBodySYLT(RandomAccessFile randomAccessFile) throws IOException, InvalidTagException {
        this.read(randomAccessFile);
    }

    public byte getContentType() {
        return this.contentType;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getIdentifier() {
        return "SYLT";
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLyric() {
        Object object = "";
        for (int i = 0; i < this.lines.size(); ++i) {
            object = (String)object + this.lines.get(i);
        }
        return object;
    }

    @Override
    public int getSize() {
        int n = 6 + this.description.length();
        for (int i = 0; i < this.lines.size(); ++i) {
            n += ((ObjectID3v2LyricLine)this.lines.get(i)).getSize();
        }
        return n;
    }

    public byte getTextEncoding() {
        return this.textEncoding;
    }

    public byte getTimeStampFormat() {
        return this.timeStampFormat;
    }

    public void addLyric(int n, String string) {
        ObjectID3v2LyricLine objectID3v2LyricLine = new ObjectID3v2LyricLine("Lyric Line");
        objectID3v2LyricLine.setTimeStamp(n);
        objectID3v2LyricLine.setText(string);
        this.lines.add(objectID3v2LyricLine);
    }

    public void addLyric(ObjectLyrics3Line objectLyrics3Line) {
        Iterator iterator = objectLyrics3Line.getTimeStamp();
        String string = objectLyrics3Line.getLyric();
        ObjectID3v2LyricLine objectID3v2LyricLine = new ObjectID3v2LyricLine("Lyric Line");
        if (!iterator.hasNext()) {
            long l = 0L;
            objectID3v2LyricLine.setTimeStamp(l);
            objectID3v2LyricLine.setText(string);
            this.lines.add(objectID3v2LyricLine);
        } else {
            while (iterator.hasNext()) {
                ObjectLyrics3TimeStamp objectLyrics3TimeStamp = (ObjectLyrics3TimeStamp)iterator.next();
                long l = objectLyrics3TimeStamp.getMinute() * 60L + objectLyrics3TimeStamp.getSecond();
                objectID3v2LyricLine.setTimeStamp(l *= 1000L);
                objectID3v2LyricLine.setText(string);
                this.lines.add(objectID3v2LyricLine);
            }
        }
    }

    public void equals() {
        throw new UnsupportedOperationException("Method equals() not yet implemented.");
    }

    @Override
    public Iterator iterator() {
        return this.lines.iterator();
    }

    @Override
    protected void setupObjectList() {
    }

    @Override
    public void read(RandomAccessFile randomAccessFile) throws IOException, InvalidTagException {
        int n = 0;
        int n2 = this.readHeader(randomAccessFile);
        byte[] byArray = new byte[n2];
        randomAccessFile.read(byArray);
        String string = new String(byArray);
        this.textEncoding = byArray[n++];
        this.language = string.substring(n, n + 3);
        n += 3;
        this.timeStampFormat = byArray[n++];
        this.contentType = byArray[n++];
        int n3 = string.indexOf(0, n);
        this.description = string.substring(n, n3);
        n = n3 + 1;
        byte[] byArray2 = new byte[n2 - n];
        System.arraycopy(byArray, n, byArray2, 0, n2 - n);
        this.readByteArray(byArray2);
    }

    public void readByteArray(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            int n2 = i;
            byte[] byArray2 = new byte[n - n2 + 4];
            System.arraycopy(byArray, n, byArray2, 0, n - n2 + 4);
            this.lines.add(new ObjectID3v2LyricLine("Lyric Line"));
            i += 4;
            n += 4;
        }
    }

    @Override
    public String toString() {
        String string = this.getIdentifier() + " " + this.textEncoding + " " + this.language + " " + this.timeStampFormat + " " + this.contentType + " " + this.description;
        for (int i = 0; i < this.lines.size(); ++i) {
            string = string + this.lines.get(i).toString();
        }
        return string;
    }

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        int n2 = 0;
        this.writeHeader(randomAccessFile, this.getSize());
        byte[] byArray = new byte[this.getSize()];
        byArray[n2++] = this.textEncoding;
        this.language = TagUtility.truncate(this.language, 3);
        for (n = 0; n < this.language.length(); ++n) {
            byArray[n + n2] = (byte)this.language.charAt(n);
        }
        n2 += this.language.length();
        byArray[n2++] = this.timeStampFormat;
        byArray[n2++] = this.contentType;
        for (n = 0; n < this.description.length(); ++n) {
            byArray[n + n2] = (byte)this.description.charAt(n);
        }
        n2 += this.description.length();
        byArray[n2++] = 0;
        System.arraycopy(this.writeByteArray(), 0, byArray, n2, byArray.length - n2);
        randomAccessFile.write(byArray);
    }

    public byte[] writeByteArray() {
        int n;
        ObjectID3v2LyricLine objectID3v2LyricLine = null;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.lines.size(); ++n) {
            objectID3v2LyricLine = (ObjectID3v2LyricLine)this.lines.get(n);
            n3 += objectID3v2LyricLine.getSize();
        }
        byte[] byArray = new byte[n3];
        for (n = 0; n < this.lines.size(); ++n) {
            objectID3v2LyricLine = (ObjectID3v2LyricLine)this.lines.get(n);
        }
        if (objectID3v2LyricLine != null) {
            System.arraycopy(objectID3v2LyricLine.writeByteArray(), 0, byArray, n2, objectID3v2LyricLine.getSize());
            n2 += objectID3v2LyricLine.getSize();
        }
        return byArray;
    }
}

