/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.RandomAccessFile;
import org.farng.mp3.id3.AbstractID3v2FrameBody;

public class FrameBodyRVAD
extends AbstractID3v2FrameBody {
    byte bytesUsed = (byte)16;
    byte increment = 0;
    long peakBass = 0L;
    long peakCenter = 0L;
    long peakLeft = 0L;
    long peakLeftBack = 0L;
    long peakRight = 0L;
    long peakRightBack = 0L;
    long relativeBass = 0L;
    long relativeCenter = 0L;
    long relativeLeft = 0L;
    long relativeLeftBack = 0L;
    long relativeRight = 0L;
    long relativeRightBack = 0L;

    public FrameBodyRVAD() {
    }

    public FrameBodyRVAD(FrameBodyRVAD frameBodyRVAD) {
        super(frameBodyRVAD);
        this.bytesUsed = frameBodyRVAD.bytesUsed;
        this.increment = frameBodyRVAD.increment;
        this.peakBass = frameBodyRVAD.peakBass;
        this.peakCenter = frameBodyRVAD.peakCenter;
        this.peakLeft = frameBodyRVAD.peakLeft;
        this.peakLeftBack = frameBodyRVAD.peakLeftBack;
        this.peakRight = frameBodyRVAD.peakRight;
        this.peakRightBack = frameBodyRVAD.peakRightBack;
        this.relativeBass = frameBodyRVAD.relativeBass;
        this.relativeCenter = frameBodyRVAD.relativeCenter;
        this.relativeLeft = frameBodyRVAD.relativeLeft;
        this.relativeLeftBack = frameBodyRVAD.relativeLeftBack;
        this.relativeRight = frameBodyRVAD.relativeRight;
        this.relativeRightBack = frameBodyRVAD.relativeRightBack;
    }

    public FrameBodyRVAD(byte by, byte by2, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12) {
        this.increment = by;
        this.bytesUsed = (byte)((by2 - 1) / 8 + 1);
        this.relativeRight = l;
        this.relativeLeft = l2;
        this.peakRight = l3;
        this.peakLeft = l4;
        this.relativeRightBack = l5;
        this.relativeLeftBack = l6;
        this.peakRightBack = l7;
        this.peakLeftBack = l8;
        this.relativeCenter = l9;
        this.peakCenter = l10;
        this.relativeBass = l11;
        this.peakBass = l12;
    }

    public FrameBodyRVAD(RandomAccessFile randomAccessFile) throws IOException, InvalidTagException {
        this.read(randomAccessFile);
    }

    @Override
    public String getIdentifier() {
        return "RVAD";
    }

    @Override
    public int getSize() {
        int n = 2 + this.bytesUsed * 4;
        if (this.relativeRightBack != 0L || this.relativeLeftBack != 0L || this.peakRightBack != 0L || this.peakLeftBack != 0L) {
            n += this.bytesUsed * 4;
        }
        if (this.relativeCenter != 0L || this.peakCenter != 0L) {
            n += this.bytesUsed * 2;
        }
        if (this.relativeBass != 0L || this.peakBass != 0L) {
            n += this.bytesUsed * 2;
        }
        return n;
    }

    public void equals() {
        throw new UnsupportedOperationException("Method equals() not yet implemented.");
    }

    @Override
    protected void setupObjectList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void read(RandomAccessFile randomAccessFile) throws IOException, InvalidTagException {
        int n;
        int n2 = 0;
        int n3 = this.readHeader(randomAccessFile);
        byte[] byArray = new byte[n3];
        randomAccessFile.read(byArray);
        this.increment = byArray[n2++];
        this.bytesUsed = (byte)((byArray[n2++] - 1) / 8 * 8 + 1);
        for (n = 0; n < this.bytesUsed; ++n) {
            this.relativeRight = (this.relativeRight << 8) + (long)byArray[n + n2];
        }
        n2 += this.bytesUsed;
        for (n = 0; n < this.bytesUsed; ++n) {
            this.relativeLeft = (this.relativeLeft << 8) + (long)byArray[n + n2];
        }
        n2 += this.bytesUsed;
        for (n = 0; n < this.bytesUsed; ++n) {
            this.peakRight = (this.peakRight << 8) + (long)byArray[n + n2];
        }
        n2 += this.bytesUsed;
        for (n = 0; n < this.bytesUsed; ++n) {
            this.peakLeft = (this.peakLeft << 8) + (long)byArray[n + n2];
        }
        n2 += this.bytesUsed;
        if (n3 > 2 + this.bytesUsed * 4) {
            for (n = 0; n < this.bytesUsed; ++n) {
                this.relativeRightBack = (this.relativeRightBack << 8) + (long)byArray[n + n2];
            }
            n2 += this.bytesUsed;
            for (n = 0; n < this.bytesUsed; ++n) {
                this.relativeLeftBack = (this.relativeLeftBack << 8) + (long)byArray[n + n2];
            }
            n2 += this.bytesUsed;
            for (n = 0; n < this.bytesUsed; ++n) {
                this.peakRightBack = (this.peakRightBack << 8) + (long)byArray[n + n2];
            }
            n2 += this.bytesUsed;
            for (n = 0; n < this.bytesUsed; ++n) {
                this.peakLeftBack = (this.peakLeftBack << 8) + (long)byArray[n + n2];
            }
            n2 += this.bytesUsed;
        }
        if (n3 > 2 + this.bytesUsed * 8) {
            for (n = 0; n < this.bytesUsed; ++n) {
                this.relativeCenter = (this.relativeCenter << 8) + (long)byArray[n + n2];
            }
            n2 += this.bytesUsed;
            for (n = 0; n < this.bytesUsed; ++n) {
                this.peakCenter = (this.peakCenter << 8) + (long)byArray[n + n2];
            }
            n2 += this.bytesUsed;
        }
        if (n3 > 2 + this.bytesUsed * 10) {
            for (n = 0; n < this.bytesUsed; ++n) {
                this.relativeBass = (this.relativeBass << 8) + (long)byArray[n + n2];
            }
            n2 += this.bytesUsed;
            for (n = 0; n < this.bytesUsed; ++n) {
                this.peakBass = (this.peakBass << 8) + (long)byArray[n + n2];
            }
            n2 += this.bytesUsed;
        }
    }

    @Override
    public String toString() {
        return this.increment + " " + this.bytesUsed * 8 + " " + this.relativeRight + " " + this.relativeLeft + " " + this.peakRight + " " + this.peakLeft + " " + this.relativeRightBack + " " + this.relativeLeftBack + " " + this.peakRightBack + " " + this.peakLeftBack + " " + this.relativeCenter + " " + this.peakCenter + " " + this.relativeBass + " " + this.peakBass;
    }

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        int n2 = 0;
        this.writeHeader(randomAccessFile, this.getSize());
        byte[] byArray = new byte[this.getSize()];
        byArray[n2++] = this.increment;
        byArray[n2++] = this.bytesUsed;
        for (n = 0; n < this.bytesUsed; ++n) {
            byArray[n + n2] = (byte)(this.relativeRight >> (this.bytesUsed - n - 1) * 8);
        }
        n2 += this.bytesUsed;
        for (n = 0; n < this.bytesUsed; ++n) {
            byArray[n + n2] = (byte)(this.relativeLeft >> (this.bytesUsed - n - 1) * 8);
        }
        n2 += this.bytesUsed;
        for (n = 0; n < this.bytesUsed; ++n) {
            byArray[n + n2] = (byte)(this.peakRight >> (this.bytesUsed - n - 1) * 8);
        }
        n2 += this.bytesUsed;
        for (n = 0; n < this.bytesUsed; ++n) {
            byArray[n + n2] = (byte)(this.peakLeft >> (this.bytesUsed - n - 1) * 8);
        }
        n2 += this.bytesUsed;
        if (this.relativeRightBack != 0L || this.relativeLeftBack != 0L || this.peakRightBack != 0L || this.peakLeftBack != 0L) {
            for (n = 0; n < this.bytesUsed; ++n) {
                byArray[n + n2] = (byte)(this.relativeRightBack >> (this.bytesUsed - n - 1) * 8);
            }
            n2 += this.bytesUsed;
            for (n = 0; n < this.bytesUsed; ++n) {
                byArray[n + n2] = (byte)(this.relativeLeftBack >> (this.bytesUsed - n - 1) * 8);
            }
            n2 += this.bytesUsed;
            for (n = 0; n < this.bytesUsed; ++n) {
                byArray[n + n2] = (byte)(this.peakRightBack >> (this.bytesUsed - n - 1) * 8);
            }
            n2 += this.bytesUsed;
            for (n = 0; n < this.bytesUsed; ++n) {
                byArray[n + n2] = (byte)(this.peakLeftBack >> (this.bytesUsed - n - 1) * 8);
            }
            n2 += this.bytesUsed;
        }
        if (this.relativeCenter != 0L || this.peakCenter != 0L) {
            for (n = 0; n < this.bytesUsed; ++n) {
                byArray[n + n2] = (byte)(this.relativeCenter >> (this.bytesUsed - n - 1) * 8);
            }
            n2 += this.bytesUsed;
            for (n = 0; n < this.bytesUsed; ++n) {
                byArray[n + n2] = (byte)(this.peakCenter >> (this.bytesUsed - n - 1) * 8);
            }
            n2 += this.bytesUsed;
        }
        if (this.relativeBass != 0L || this.peakBass != 0L) {
            for (n = 0; n < this.bytesUsed; ++n) {
                byArray[n + n2] = (byte)(this.relativeBass >> (this.bytesUsed - n - 1) * 8);
            }
            n2 += this.bytesUsed;
            for (n = 0; n < this.bytesUsed; ++n) {
                byArray[n + n2] = (byte)(this.peakBass >> (this.bytesUsed - n - 1) * 8);
            }
            n2 += this.bytesUsed;
        }
        randomAccessFile.write(byArray);
    }
}

