/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.metric;

import com.google.api.MetricDescriptor;
import com.google.api.client.util.Preconditions;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.cloud.opentelemetry.metric.AggregateByLabelMetricTimeSeriesBuilder;
import com.google.cloud.opentelemetry.metric.CloudMetricClient;
import com.google.cloud.opentelemetry.metric.CloudMetricClientImpl;
import com.google.cloud.opentelemetry.metric.MetricConfiguration;
import com.google.cloud.opentelemetry.metric.MetricDescriptorStrategy;
import com.google.cloud.opentelemetry.metric.MetricTimeSeriesBuilder;
import com.google.cloud.opentelemetry.metric.MonitoredResourceDescription;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeSeries;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Duration;

class InternalMetricExporter
implements MetricExporter {
    private static final Logger logger = LoggerFactory.getLogger(InternalMetricExporter.class);
    private static final String PROJECT_NAME_PREFIX = "projects/";
    private static final int MAX_BATCH_SIZE = 200;
    private final CloudMetricClient metricServiceClient;
    private final String projectId;
    private final String prefix;
    private final MetricDescriptorStrategy metricDescriptorStrategy;
    private final Predicate<AttributeKey<?>> resourceAttributesFilter;
    private final boolean useCreateServiceTimeSeries;
    private final MonitoredResourceDescription monitoredResourceDescription;
    private final boolean instrumentationLibraryLabelsEnabled;

    InternalMetricExporter(String projectId, String prefix, CloudMetricClient client, MetricDescriptorStrategy descriptorStrategy, Predicate<AttributeKey<?>> resourceAttributesFilter, boolean useCreateServiceTimeSeries, MonitoredResourceDescription monitoredResourceDescription, boolean instrumentationLibraryLabelsEnabled) {
        this.projectId = projectId;
        this.prefix = prefix;
        this.metricServiceClient = client;
        this.metricDescriptorStrategy = descriptorStrategy;
        this.resourceAttributesFilter = resourceAttributesFilter;
        this.useCreateServiceTimeSeries = useCreateServiceTimeSeries;
        this.monitoredResourceDescription = monitoredResourceDescription;
        this.instrumentationLibraryLabelsEnabled = instrumentationLibraryLabelsEnabled;
    }

    static InternalMetricExporter createWithConfiguration(MetricConfiguration configuration) throws IOException {
        String projectId = configuration.getProjectId();
        String prefix = configuration.getPrefix();
        MetricServiceSettings serviceClientSettings = configuration.getMetricServiceSettings() == null ? InternalMetricExporter.generateMetricServiceSettings(configuration) : configuration.getMetricServiceSettings();
        return new InternalMetricExporter(projectId, prefix, new CloudMetricClientImpl(MetricServiceClient.create((MetricServiceSettings)serviceClientSettings)), configuration.getDescriptorStrategy(), configuration.getResourceAttributesFilter(), configuration.getUseServiceTimeSeries(), configuration.getMonitoredResourceDescription(), configuration.getInstrumentationLibraryLabelsEnabled());
    }

    @VisibleForTesting
    static InternalMetricExporter createWithClient(String projectId, String prefix, CloudMetricClient metricServiceClient, MetricDescriptorStrategy descriptorStrategy, Predicate<AttributeKey<?>> resourceAttributesFilter, boolean useCreateServiceTimeSeries, MonitoredResourceDescription monitoredResourceDescription, boolean instrumentationLibraryLabelsEnabled) {
        return new InternalMetricExporter(projectId, prefix, metricServiceClient, descriptorStrategy, resourceAttributesFilter, useCreateServiceTimeSeries, monitoredResourceDescription, instrumentationLibraryLabelsEnabled);
    }

    private static MetricServiceSettings generateMetricServiceSettings(MetricConfiguration configuration) throws IOException {
        MetricServiceSettings.Builder builder = MetricServiceSettings.newBuilder();
        if (configuration.getInsecureEndpoint()) {
            builder.setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create());
            builder.setTransportChannelProvider((TransportChannelProvider)FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)ManagedChannelBuilder.forTarget((String)configuration.getMetricServiceEndpoint()).usePlaintext().build())));
        } else {
            GoogleCredentials credentials = configuration.getCredentials() == null ? GoogleCredentials.getApplicationDefault() : configuration.getCredentials();
            builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)((Credentials)Preconditions.checkNotNull((Object)credentials, (Object)"Credentials not provided."))));
            builder.setEndpoint(configuration.getMetricServiceEndpoint());
        }
        builder.createMetricDescriptorSettings().setSimpleTimeoutNoRetries(Duration.ofMillis((long)configuration.getDeadline().toMillis()));
        return builder.build();
    }

    private void exportDescriptor(MetricDescriptor descriptor) {
        logger.trace("Creating metric descriptor: {}", (Object)descriptor);
        this.metricServiceClient.createMetricDescriptor(CreateMetricDescriptorRequest.newBuilder().setName(PROJECT_NAME_PREFIX + this.projectId).setMetricDescriptor(descriptor).build());
    }

    public AggregationTemporality getAggregationTemporality(@Nonnull InstrumentType instrumentType) {
        return AggregationTemporality.CUMULATIVE;
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        AggregateByLabelMetricTimeSeriesBuilder builder = new AggregateByLabelMetricTimeSeriesBuilder(this.projectId, this.prefix, this.resourceAttributesFilter, this.monitoredResourceDescription, this.instrumentationLibraryLabelsEnabled);
        block7: for (MetricData metricData : metrics) {
            switch (metricData.getType()) {
                case LONG_GAUGE: {
                    for (LongPointData point : metricData.getLongGaugeData().getPoints()) {
                        builder.recordPoint(metricData, point);
                    }
                    continue block7;
                }
                case LONG_SUM: {
                    for (LongPointData point : metricData.getLongSumData().getPoints()) {
                        builder.recordPoint(metricData, point);
                    }
                    continue block7;
                }
                case DOUBLE_GAUGE: {
                    for (LongPointData point : metricData.getDoubleGaugeData().getPoints()) {
                        builder.recordPoint(metricData, (DoublePointData)point);
                    }
                    continue block7;
                }
                case DOUBLE_SUM: {
                    for (LongPointData point : metricData.getDoubleSumData().getPoints()) {
                        builder.recordPoint(metricData, (DoublePointData)point);
                    }
                    continue block7;
                }
                case HISTOGRAM: {
                    for (LongPointData point : metricData.getHistogramData().getPoints()) {
                        builder.recordPoint(metricData, (HistogramPointData)point);
                    }
                    continue block7;
                }
                default: {
                    logger.error("OpenTelemetry Metric type {} not supported.", (Object)metricData.getType());
                }
            }
        }
        this.exportDescriptors(builder);
        List<TimeSeries> series = builder.getTimeSeries();
        Consumer<List<TimeSeries>> timeSeriesGenerator = timeSeries -> {
            if (this.useCreateServiceTimeSeries) {
                this.metricServiceClient.createServiceTimeSeries(ProjectName.of((String)this.projectId), (List<TimeSeries>)timeSeries);
            } else {
                this.metricServiceClient.createTimeSeries(ProjectName.of((String)this.projectId), (List<TimeSeries>)timeSeries);
            }
        };
        this.createTimeSeriesBatch(series, timeSeriesGenerator);
        if (series.size() < metrics.size()) {
            return CompletableResultCode.ofFailure();
        }
        return CompletableResultCode.ofSuccess();
    }

    private void exportDescriptors(MetricTimeSeriesBuilder timeSeriesBuilder) {
        if (this.useCreateServiceTimeSeries) {
            return;
        }
        try {
            Collection<MetricDescriptor> descriptors = timeSeriesBuilder.getDescriptors();
            if (!descriptors.isEmpty()) {
                this.metricDescriptorStrategy.exportDescriptors(descriptors, this::exportDescriptor);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to create metric descriptors", (Throwable)e);
        }
    }

    private void createTimeSeriesBatch(List<TimeSeries> allTimesSeries, Consumer<List<TimeSeries>> timeSeriesGenerator) {
        List batches = Lists.partition(allTimesSeries, (int)200);
        for (List timeSeries : batches) {
            timeSeriesGenerator.accept(new ArrayList(timeSeries));
        }
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.metricServiceClient.shutdown();
        return CompletableResultCode.ofSuccess();
    }
}

